/*
 * Copyright 2005-2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @bug 6311051
 * @run main/othervm -XX:SoftRefLRUPolicyMSPerMB=0 Test6311051
 * @summary Tests listener method with many paramenters
 * @author Peter Zhelezniakov
 */

import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.EventObject;

public class Test6311051 {
    public static void main(String[] args) throws IntrospectionException, NoSuchMethodException {
        EventSetDescriptor esd = new EventSetDescriptor(
                "foo",
                FooListener.class,
                new Method[] {
                        FooListener.class.getMethod("fooHappened", EventObject.class),
                        FooListener.class.getMethod("moreFooHappened", EventObject.class, Object.class),
                        FooListener.class.getMethod("lessFooHappened"),
                },
                Bean.class.getMethod("addFooListener", FooListener.class),
                Bean.class.getMethod("removeFooListener", FooListener.class)
        );
        System.gc();
        for (Method method : esd.getListenerMethods()) {
            System.out.println(method);
        }
    }

    public static class Bean {
        public void addFooListener(FooListener listener) {
        }

        public void removeFooListener(FooListener listener) {
        }
    }

    public static interface FooListener {
        void fooHappened(EventObject event);

        void moreFooHappened(EventObject event, Object data);

        void lessFooHappened();
    }
}
