/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Member;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.NodeType;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public final class MemberImpl
implements Member,
HazelcastInstanceAware,
DataSerializable {
    protected boolean localMember;
    protected Address address;
    protected NodeType nodeType;
    protected String uuid;
    protected transient long lastRead = 0L;
    protected transient long lastWrite = 0L;
    protected volatile transient long lastPing = 0L;
    private volatile transient ILogger logger;

    public MemberImpl() {
    }

    public MemberImpl(Address address, boolean localMember) {
        this(address, localMember, NodeType.MEMBER, null);
    }

    public MemberImpl(Address address, boolean localMember, NodeType nodeType, String uuid) {
        this();
        this.nodeType = nodeType;
        this.localMember = localMember;
        this.address = address;
        this.lastRead = Clock.currentTimeMillis();
        this.uuid = uuid;
    }

    public Address getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public InetAddress getInetAddress() {
        try {
            return this.address.getInetAddress();
        }
        catch (UnknownHostException e) {
            if (this.logger != null) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }

    public InetSocketAddress getInetSocketAddress() {
        try {
            return this.address.getInetSocketAddress();
        }
        catch (UnknownHostException e) {
            if (this.logger != null) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }

    public boolean localMember() {
        return this.localMember;
    }

    public void didWrite() {
        this.lastWrite = Clock.currentTimeMillis();
    }

    public void didRead() {
        this.lastRead = Clock.currentTimeMillis();
    }

    public void didPing() {
        this.lastPing = Clock.currentTimeMillis();
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public long getLastRead() {
        return this.lastRead;
    }

    public long getLastWrite() {
        return this.lastWrite;
    }

    @Deprecated
    public boolean isSuperClient() {
        return this.isLiteMember();
    }

    public boolean isLiteMember() {
        return this.nodeType == NodeType.LITE_MEMBER;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        FactoryImpl factoryImpl = (FactoryImpl)hazelcastInstance;
        this.localMember = factoryImpl.node.address.equals(this.address);
        this.logger = factoryImpl.node.getLogger(this.getClass().getName());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeData(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readData(in);
    }

    public void readData(DataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        this.nodeType = NodeType.create(in.readInt());
        this.lastRead = Clock.currentTimeMillis();
        if (in.readBoolean()) {
            this.uuid = in.readUTF();
        }
    }

    public void writeData(DataOutput out) throws IOException {
        this.address.writeData(out);
        out.writeInt(this.nodeType.getValue());
        boolean hasUuid = this.uuid != null;
        out.writeBoolean(hasUuid);
        if (hasUuid) {
            out.writeUTF(this.uuid);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Member [");
        sb.append(this.address.getHost());
        sb.append("]");
        sb.append(":");
        sb.append(this.address.getPort());
        if (this.localMember) {
            sb.append(" this");
        }
        if (this.nodeType == NodeType.LITE_MEMBER) {
            sb.append(" lite");
        }
        return sb.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberImpl other = (MemberImpl)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }
}

