/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.CustomScreen;
import com.install4j.api.InstallerContext;
import com.install4j.api.InstallerEvent;
import com.install4j.api.ProgressInterface;
import com.install4j.runtime.installer.Installer;
import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.BaseScreenConfig;
import com.install4j.runtime.installer.config.CustomScreenConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ServiceConfig;
import com.install4j.runtime.installer.config.StandardScreenConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.InstallerFrontend;
import com.install4j.runtime.installer.frontend.InstallerScreen;
import com.install4j.runtime.installer.frontend.InstallerWizardContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.screens.AdditionalTasksScreen;
import com.install4j.runtime.installer.frontend.screens.AssociationsScreen;
import com.install4j.runtime.installer.frontend.screens.ComponentsScreen;
import com.install4j.runtime.installer.frontend.screens.CustomScreenAdapter;
import com.install4j.runtime.installer.frontend.screens.FinishedScreen;
import com.install4j.runtime.installer.frontend.screens.InfoScreen;
import com.install4j.runtime.installer.frontend.screens.InstallationScreen;
import com.install4j.runtime.installer.frontend.screens.LicenseScreen;
import com.install4j.runtime.installer.frontend.screens.LinkScreen;
import com.install4j.runtime.installer.frontend.screens.LocationScreen;
import com.install4j.runtime.installer.frontend.screens.MacosServiceScreen;
import com.install4j.runtime.installer.frontend.screens.ProgramGroupScreen;
import com.install4j.runtime.installer.frontend.screens.ServiceScreen;
import com.install4j.runtime.installer.frontend.screens.UnixServiceScreen;
import com.install4j.runtime.installer.frontend.screens.WelcomeScreen;
import com.install4j.runtime.installer.frontend.screens.Win32ServiceScreen;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.wizard.WizardBase;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;

public class InstallerWizard
extends WizardBase
implements InstallerFrontend {
    private static final ImageIcon ICON_FRAME = GUIHelper.loadIcon("install4j_icon.png");
    private static final String LICENSE_FILE_NAME = "License";
    private static final String PREINFO_FILE_NAME = "PreInfo";
    private static final String POSTINFO_FILE_NAME = "PostInfo";
    private Installer installer;
    private WelcomeScreen welcomeScreen;
    private LicenseScreen licenseScreen;
    private InfoScreen preInfoScreen;
    private LocationScreen locationScreen;
    private ProgramGroupScreen programGroupScreen;
    private LinkScreen linkScreen;
    private AssociationsScreen associationsScreen;
    private ComponentsScreen componentsScreen;
    private ServiceScreen serviceScreen;
    private AdditionalTasksScreen additionalTasksScreen;
    private InstallationScreen installerScreen;
    private InfoScreen postInfoScreen;
    private FinishedScreen finishedScreen;
    private InstallerWizardContextImpl context;
    private List customScreens = new LinkedList();
    private Map customScreenToAdapter = new HashMap();
    private Map idToSystemScreen = new HashMap();
    private boolean canceled = false;
    private String licenseText;
    private String preInfoText;
    private String postInfoText;
    private InstallerScreen currentScreen;
    static /* synthetic */ Class class$com$install4j$api$CustomScreen;

    public InstallerWizard(Installer installer) {
        super("");
        this.installer = installer;
        String string = MessageFormat.format(Messages.getMessages().getString("SetupWindowTitle"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        this.setTitle(string);
        this.loadTexts();
        this.setupScreens();
    }

    public void showFrame() {
        super.showFrame(null, ICON_FRAME);
    }

    public boolean isCancelling() {
        return this.canceled && Installer.getInstance().getInstallationState() != 5;
    }

    public File getDestDir() {
        return this.locationScreen.getDestDir();
    }

    public File getSelectedDir() {
        return this.locationScreen.getSelectedDir();
    }

    public List getCustomScreens() {
        return this.customScreens;
    }

    public synchronized void quit() {
        FileResourceBundle fileResourceBundle = Messages.getMessages();
        int n = GUIHelper.showOptionDialog(this, fileResourceBundle.getString("ExitSetupMessage"), new String[]{fileResourceBundle.getString("ButtonYes"), fileResourceBundle.getString("ButtonNo")}, 3);
        if (n == 0) {
            this.installerScreen.setCancelButtonEnabled(false);
            this.installer.abort(this.installerScreen);
            this.canceled = true;
            this.fireEvent(5);
        }
    }

    public Installer getInstaller() {
        return this.installer;
    }

    public boolean isLaunchApplication() {
        return this.currentScreen == this.finishedScreen && this.finishedScreen.isLaunchApplication();
    }

    protected void setupComponent() {
        super.setupComponent();
        this.setMinimumSize(new Dimension(500, 300));
    }

    protected void setupScreens() {
        this.welcomeScreen = new WelcomeScreen(this);
        this.licenseScreen = new LicenseScreen(this, this.licenseText);
        this.preInfoScreen = new InfoScreen(this, this.preInfoText, true);
        this.locationScreen = new LocationScreen(this);
        this.componentsScreen = new ComponentsScreen(this);
        this.associationsScreen = new AssociationsScreen(this);
        if (InstallerUtil.isWindows()) {
            this.programGroupScreen = new ProgramGroupScreen(this);
        } else if (!InstallerUtil.isMacOS()) {
            this.linkScreen = new LinkScreen(this);
        }
        this.additionalTasksScreen = new AdditionalTasksScreen(this);
        if (!this.additionalTasksScreen.hasTasks()) {
            this.additionalTasksScreen = null;
        }
        this.installerScreen = new InstallationScreen(this);
        this.postInfoScreen = new InfoScreen(this, this.postInfoText, false);
        this.finishedScreen = new FinishedScreen(this);
        Iterator iterator = InstallerConfig.getCurrentInstance().getScreens().iterator();
        while (iterator.hasNext()) {
            BaseScreenConfig baseScreenConfig = (BaseScreenConfig)iterator.next();
            if (baseScreenConfig instanceof StandardScreenConfig) {
                this.registerStandardScreenConfig((StandardScreenConfig)baseScreenConfig);
                continue;
            }
            if (baseScreenConfig instanceof CustomScreenConfig) {
                try {
                    this.registerCustomScreen((CustomScreenConfig)baseScreenConfig);
                }
                catch (Exception exception) {
                    GUIHelper.showMessage(null, exception.getMessage(), 0);
                    System.exit(1);
                }
                continue;
            }
            System.err.println("unknown screen type " + baseScreenConfig.getClass().getName());
        }
        this.context = new InstallerWizardContextImpl(this, this.installerScreen);
        this.context.setContextForCustomScreens();
    }

    protected int getFrameWidth() {
        return InstallerConfig.getCurrentInstance().getWindowWidth();
    }

    protected int getFrameHeight() {
        return InstallerConfig.getCurrentInstance().getWindowHeight();
    }

    protected void beforeShow() {
        this.fireEvent(1);
    }

    protected void beforeHide() {
        this.fireEvent(4);
    }

    protected void afterHide() {
        if (this.isLaunchApplication()) {
            this.getInstaller().launchApplication();
        }
        this.getInstaller().checkReboot();
        System.exit(0);
    }

    void fireEvent(int n) {
        this.context.fireInstallerEvent(new InstallerEvent(this.context, n));
    }

    void setCurrentScreen(InstallerScreen installerScreen) {
        if (this.currentScreen != null) {
            this.currentScreen.deactivate();
        }
        this.currentScreen = installerScreen;
    }

    boolean activateStandardScreen(String string) {
        if (this.installer.getInstallationState() == 1) {
            return false;
        }
        InstallerScreen installerScreen = (InstallerScreen)this.idToSystemScreen.get(string);
        if (installerScreen == null) {
            return false;
        }
        return this.setScreen(installerScreen);
    }

    boolean activateCustomScreen(CustomScreen customScreen) {
        if (this.installer.getInstallationState() == 1) {
            return false;
        }
        CustomScreenAdapter customScreenAdapter = (CustomScreenAdapter)this.customScreenToAdapter.get(customScreen);
        if (customScreenAdapter == null) {
            return false;
        }
        return this.setScreen(customScreenAdapter);
    }

    InstallerScreen getCurrentScreen() {
        return this.currentScreen;
    }

    private void loadTexts() {
        this.licenseText = this.loadFile(LICENSE_FILE_NAME);
        this.preInfoText = this.loadFile(PREINFO_FILE_NAME);
        this.postInfoText = this.loadFile(POSTINFO_FILE_NAME);
    }

    private String loadFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            StringWriter stringWriter = new StringWriter();
            while ((n = inputStreamReader.read()) != -1) {
                stringWriter.write(n);
            }
            inputStreamReader.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void registerStandardScreenConfig(StandardScreenConfig standardScreenConfig) {
        String string = standardScreenConfig.getId();
        if (string.equals("welcome")) {
            this.registerStandardScreen(string, this.welcomeScreen);
        } else if (string.equals("license")) {
            this.registerStandardScreen(string, this.licenseScreen);
        } else if (string.equals("preInfo")) {
            this.registerStandardScreen(string, this.preInfoScreen);
        } else if (string.equals("location")) {
            this.registerStandardScreen(string, this.locationScreen);
        } else if (string.equals("programGroup")) {
            if (InstallerUtil.isWindows()) {
                this.registerStandardScreen(string, this.programGroupScreen);
            } else if (!InstallerUtil.isMacOS()) {
                this.registerStandardScreen(string, this.linkScreen);
            }
        } else if (string.equals("fileAssociations")) {
            if ((InstallerUtil.isWindows() || InstallerUtil.isMacOS()) && InstallerConfig.getCurrentInstance().getAssociations().size() > 0) {
                this.registerStandardScreen(string, this.associationsScreen);
            }
        } else if (string.equals("components")) {
            if (InstallerConfig.getCurrentInstance().getComponents().size() > 0) {
                this.registerStandardScreen(string, this.componentsScreen);
            }
        } else if (string.equals("services")) {
            this.registerServiceScreen();
        } else if (string.equals("additionalTasks")) {
            this.registerStandardScreen(string, this.additionalTasksScreen);
        } else if (string.equals("install")) {
            this.registerStandardScreen(string, this.installerScreen);
        } else if (string.equals("postInfo")) {
            this.registerStandardScreen(string, this.postInfoScreen);
        } else if (string.equals("finished")) {
            this.registerStandardScreen(string, this.finishedScreen);
        } else {
            System.err.println("unknown screen id " + string);
        }
    }

    private void registerStandardScreen(String string, InstallerScreen installerScreen) {
        this.registerScreen(installerScreen);
        this.idToSystemScreen.put(string, installerScreen);
    }

    private void registerCustomScreen(CustomScreenConfig customScreenConfig) throws Exception {
        String string = customScreenConfig.getScreenClass();
        if (string.length() == 0) {
            System.err.println("no screen class specified");
        }
        try {
            Object object = InstallerUtil.newUserInstance(string);
            try {
                CustomScreen customScreen = (CustomScreen)object;
                this.customScreens.add(customScreen);
                CustomScreenAdapter customScreenAdapter = new CustomScreenAdapter(this, customScreen);
                this.registerScreen(customScreenAdapter);
                this.customScreenToAdapter.put(customScreen, customScreenAdapter);
            }
            catch (ClassCastException classCastException) {
                System.err.println("screen class " + string + " is not derived from CustomScreen: " + classCastException.getMessage());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("The screen class " + string + " \ncould not be found.");
        }
        catch (InstantiationException instantiationException) {
            throw new Exception("The screen class " + string + " \ncould not be instantiated: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Exception("The screen class " + string + " \nhas no public constructor: " + illegalAccessException.getMessage());
        }
        catch (ClassCastException classCastException) {
            throw new Exception("The screen class " + string + " \nis not derived from " + (class$com$install4j$api$CustomScreen == null ? (class$com$install4j$api$CustomScreen = InstallerWizard.class$("com.install4j.api.CustomScreen")) : class$com$install4j$api$CustomScreen).getName());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new Exception("An exception of type " + exception.getClass().getName() + " \noccurred when instantiating " + string + ":\n" + exception.getMessage());
        }
    }

    private void registerServiceScreen() {
        if (InstallerUtil.isWindows9X()) {
            return;
        }
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        List list = installerConfig.getServices();
        if (list.size() == 0) {
            return;
        }
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceConfig serviceConfig = (ServiceConfig)iterator.next();
            if (!serviceConfig.isAllowUserChangeStartupType()) continue;
            bl = true;
            break;
        }
        if (!bl && !installerConfig.getType().equals("unix")) {
            return;
        }
        this.serviceScreen = null;
        if (installerConfig.getType().equals("windows")) {
            this.serviceScreen = new Win32ServiceScreen(this);
        } else if (installerConfig.getType().equals("macos")) {
            this.serviceScreen = new MacosServiceScreen(this);
        } else if (installerConfig.getType().equals("unix")) {
            this.serviceScreen = new UnixServiceScreen(this);
        }
        if (this.serviceScreen != null) {
            this.registerStandardScreen("services", this.serviceScreen);
        }
    }

    public InstallerContext getInstallerContext() {
        return this.context;
    }

    public ProgressInterface getProgressInterface() {
        return this.installerScreen;
    }

    public String getProgramGroup() {
        if (this.programGroupScreen != null) {
            return this.programGroupScreen.getSelectedProgramGroup();
        }
        return null;
    }

    public boolean isCreateMenu() {
        if (this.programGroupScreen != null) {
            return this.programGroupScreen.isCreateMenu();
        }
        return false;
    }

    public boolean isCreateMenuAllUsers() {
        if (this.programGroupScreen != null) {
            return this.programGroupScreen.isAllUsers();
        }
        return true;
    }

    public boolean isCreateDesktopIcon() {
        if (this.additionalTasksScreen != null) {
            return this.additionalTasksScreen.isCreateDesktopIcon();
        }
        return false;
    }

    public boolean isCreateQuickLaunchIcon() {
        if (this.additionalTasksScreen != null) {
            return this.additionalTasksScreen.isCreateQuickLaunchIcon();
        }
        return false;
    }

    public File getLinkDestDir() {
        if (this.linkScreen != null) {
            return this.linkScreen.getDestDir();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

