<?php 
class ControllerPaymentHSBC extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/hsbc');

		$this->document->title = $this->language->get('heading_title');
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			
			$this->model_setting_setting->editSetting('hsbc', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->https('extension/payment'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');		
		$this->data['text_approved'] = $this->language->get('text_approved');
		$this->data['text_declined'] = $this->language->get('text_declined');
		$this->data['text_off'] = $this->language->get('text_off');
		
		$this->data['entry_client'] = $this->language->get('entry_client');
		$this->data['entry_user'] = $this->language->get('entry_user');
		$this->data['entry_password'] = $this->language->get('entry_password');
		$this->data['entry_gateway'] = $this->language->get('entry_gateway');
		$this->data['entry_pas'] = $this->language->get('entry_pas');
		$this->data['entry_avs'] = $this->language->get('entry_avs');
		$this->data['entry_test'] = $this->language->get('entry_test');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');		
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		$this->data['error_warning'] = @$this->error['warning'];
		$this->data['error_client'] = @$this->error['client'];
		$this->data['error_user'] = @$this->error['user'];
		$this->data['error_password'] = @$this->error['password'];
		$this->data['error_gateway'] = @$this->error['gateway'];
		$this->data['error_pas'] = @$this->error['pas'];

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('common/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('extension/payment'),
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('payment/hsbc'),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->https('payment/hsbc');
		
		$this->data['cancel'] = $this->url->https('extension/payment');
		
		if (isset($this->request->post['hsbc_client'])) {
			$this->data['hsbc_client'] = $this->request->post['hsbc_client'];
		} else {
			$this->data['hsbc_client'] = $this->config->get('hsbc_client');
		}

		if (isset($this->request->post['hsbc_user'])) {
			$this->data['hsbc_user'] = $this->request->post['hsbc_user'];
		} else {
			$this->data['hsbc_user'] = $this->config->get('hsbc_user');
		}

		if (isset($this->request->post['hsbc_password'])) {
			$this->data['hsbc_password'] = $this->request->post['hsbc_password'];
		} else {
			$this->data['hsbc_password'] = $this->config->get('hsbc_password');
		}

		if (isset($this->request->post['hsbc_gateway'])) {
			$this->data['hsbc_gateway'] = $this->request->post['hsbc_gateway'];
		} else {
			$this->data['hsbc_gateway'] = $this->config->get('hsbc_gateway');
		}

		if (isset($this->request->post['hsbc_pas'])) {
			$this->data['hsbc_pas'] = $this->request->post['hsbc_pas'];
		} else {
			$this->data['hsbc_pas'] = $this->config->get('hsbc_pas');
		}
		
		if (isset($this->request->post['hsbc_avs'])) {
			$this->data['hsbc_avs'] = $this->request->post['hsbc_avs'];
		} else {
			$this->data['hsbc_avs'] = $this->config->get('hsbc_avs');
		}
		
		if (isset($this->request->post['hsbc_test'])) {
			$this->data['hsbc_test'] = $this->request->post['hsbc_test'];
		} else {
			$this->data['hsbc_test'] = $this->config->get('hsbc_test');
		}
		
		if (isset($this->request->post['hsbc_order_status_id'])) {
			$this->data['hsbc_order_status_id'] = $this->request->post['hsbc_order_status_id'];
		} else {
			$this->data['hsbc_order_status_id'] = $this->config->get('hsbc_order_status_id'); 
		} 
		
		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		if (isset($this->request->post['hsbc_geo_zone_id'])) {
			$this->data['hsbc_geo_zone_id'] = $this->request->post['hsbc_geo_zone_id'];
		} else {
			$this->data['hsbc_geo_zone_id'] = $this->config->get('hsbc_geo_zone_id'); 
		} 
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();
		
		if (isset($this->request->post['hsbc_status'])) {
			$this->data['hsbc_status'] = $this->request->post['hsbc_status'];
		} else {
			$this->data['hsbc_status'] = $this->config->get('hsbc_status');
		}
		
		if (isset($this->request->post['hsbc_sort_order'])) {
			$this->data['hsbc_sort_order'] = $this->request->post['hsbc_sort_order'];
		} else {
			$this->data['hsbc_sort_order'] = $this->config->get('hsbc_sort_order');
		}

		$this->id       = 'content';
		$this->template = 'payment/hsbc.tpl';
		$this->layout   = 'common/layout';
		
 		$this->render();
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/hsbc')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!@$this->request->post['hsbc_client']) {
			$this->error['client'] = $this->language->get('error_client');
		}

		if (!@$this->request->post['hsbc_user']) {
			$this->error['user'] = $this->language->get('error_user');
		}

		if (!@$this->request->post['hsbc_password']) {
			$this->error['password'] = $this->language->get('error_password');
		}

		if (!@$this->request->post['hsbc_gateway']) {
			$this->error['gateway'] = $this->language->get('error_gateway');
		}
		
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}	
	}
}
?>