<?php 
class ControllerPaymentBluePay extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/bluepay');

		$this->document->title = $this->language->get('heading_title');
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			
			$this->model_setting_setting->editSetting('bluepay', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->https('extension/payment'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_yes'] = $this->language->get('text_yes');
		$this->data['text_no'] = $this->language->get('text_no');
				
		$this->data['entry_merchant'] = $this->language->get('entry_merchant');
		$this->data['entry_key'] = $this->language->get('entry_key');
		$this->data['entry_test'] = $this->language->get('entry_test');
		$this->data['entry_debug'] = $this->language->get('entry_debug');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');		
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		$this->data['error_warning'] = @$this->error['warning'];
		$this->data['error_merchant'] = @$this->error['merchant'];
		$this->data['error_key'] = @$this->error['key'];

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('common/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('extension/payment'),
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('payment/bluepay'),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->https('payment/bluepay');
		
		$this->data['cancel'] = $this->url->https('extension/payment');
		
		
		if (isset($this->request->post['bluepay_merchant'])) {
			$this->data['bluepay_merchant'] = $this->request->post['bluepay_merchant'];
		} else {
			$this->data['bluepay_merchant'] = $this->config->get('bluepay_merchant');
		}

		if (isset($this->request->post['bluepay_key'])) {
			$this->data['bluepay_key'] = $this->request->post['bluepay_key'];
		} else {
			$this->data['bluepay_key'] = $this->config->get('bluepay_key');
		}
		
		if (isset($this->request->post['bluepay_test'])) {
			$this->data['bluepay_test'] = $this->request->post['bluepay_test'];
		} else {
			$this->data['bluepay_test'] = $this->config->get('bluepay_test');
		}

		if (isset($this->request->post['bluepay_debug'])) {
			$this->data['bluepay_debug'] = $this->request->post['bluepay_debug'];
		} else {
			$this->data['bluepay_debug'] = $this->config->get('bluepay_debug');
		}
		
		if (isset($this->request->post['bluepay_order_status_id'])) {
			$this->data['bluepay_order_status_id'] = $this->request->post['bluepay_order_status_id'];
		} else {
			$this->data['bluepay_order_status_id'] = $this->config->get('bluepay_order_status_id'); 
		} 
		
		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		if (isset($this->request->post['bluepay_geo_zone_id'])) {
			$this->data['bluepay_geo_zone_id'] = $this->request->post['bluepay_geo_zone_id'];
		} else {
			$this->data['bluepay_geo_zone_id'] = $this->config->get('bluepay_geo_zone_id'); 
		} 
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

		if (isset($this->request->post['bluepay_status'])) {
			$this->data['bluepay_status'] = $this->request->post['bluepay_status'];
		} else {
			$this->data['bluepay_status'] = $this->config->get('bluepay_status');
		}
		
		if (isset($this->request->post['bluepay_sort_order'])) {
			$this->data['bluepay_sort_order'] = $this->request->post['bluepay_sort_order'];
		} else {
			$this->data['bluepay_sort_order'] = $this->config->get('bluepay_sort_order');
		}
		
		$this->id       = 'content';
		$this->template = 'payment/bluepay.tpl';
		$this->layout   = 'common/layout';
		
 		$this->render();
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/bluepay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!@$this->request->post['bluepay_merchant']) {
			$this->error['merchant'] = $this->language->get('error_merchant');
		}

		if (!@$this->request->post['bluepay_key']) {
			$this->error['key'] = $this->language->get('error_key');
		}
		
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}	
	}
}
?>