<?php 
class ControllerPaymentAsiaPay extends Controller {
	private $error = array(); 

	public function index() {
		$this->load->language('payment/asiapay');

		$this->document->title = $this->language->get('heading_title');
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && ($this->validate())) {
			$this->load->model('setting/setting');
			
			$this->model_setting_setting->editSetting('asiapay', $this->request->post);				
			
			$this->session->data['success'] = $this->language->get('text_success');

			$this->redirect($this->url->https('extension/payment'));
		}

		$this->data['heading_title'] = $this->language->get('heading_title');

		$this->data['text_enabled'] = $this->language->get('text_enabled');
		$this->data['text_disabled'] = $this->language->get('text_disabled');
		$this->data['text_all_zones'] = $this->language->get('text_all_zones');
		$this->data['text_none'] = $this->language->get('text_none');
		$this->data['text_standard'] = $this->language->get('text_standard');
		$this->data['text_ipn'] = $this->language->get('text_ipn');
		
		$this->data['entry_email'] = $this->language->get('entry_email');
		$this->data['entry_receiver'] = $this->language->get('entry_receiver');
		$this->data['entry_account'] = $this->language->get('entry_account');
		$this->data['entry_method'] = $this->language->get('entry_method');
		$this->data['entry_callback'] = $this->language->get('entry_callback');
		$this->data['entry_order_status'] = $this->language->get('entry_order_status');		
		$this->data['entry_geo_zone'] = $this->language->get('entry_geo_zone');
		$this->data['entry_status'] = $this->language->get('entry_status');
		$this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
		
		$this->data['help_callback'] = $this->language->get('help_callback');
		
		$this->data['button_save'] = $this->language->get('button_save');
		$this->data['button_cancel'] = $this->language->get('button_cancel');

		$this->data['tab_general'] = $this->language->get('tab_general');

		$this->data['error_warning'] = @$this->error['warning'];
		$this->data['error_email'] = @$this->error['email'];
		$this->data['error_receiver'] = @$this->error['receiver'];
		$this->data['error_account'] = @$this->error['account'];

  		$this->document->breadcrumbs = array();

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('common/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('extension/payment'),
       		'text'      => $this->language->get('text_payment'),
      		'separator' => ' :: '
   		);

   		$this->document->breadcrumbs[] = array(
       		'href'      => $this->url->https('payment/asiapay'),
       		'text'      => $this->language->get('heading_title'),
      		'separator' => ' :: '
   		);
				
		$this->data['action'] = $this->url->https('payment/asiapay');
		
		$this->data['cancel'] = $this->url->https('extension/payment');
		
		if (isset($this->request->post['asiapay_email'])) {
			$this->data['asiapay_email'] = $this->request->post['asiapay_email'];
		} else {
			$this->data['asiapay_email'] = $this->config->get('asiapay_email');
		}

		if (isset($this->request->post['asiapay_receiver_id'])) {
			$this->data['asiapay_receiver'] = $this->request->post['asiapay_receiver'];
		} else {
			$this->data['asiapay_receiver'] = $this->config->get('asiapay_receiver');
		}

		if (isset($this->request->post['asiapay_account_id'])) {
			$this->data['asiapay_account'] = $this->request->post['asiapay_account'];
		} else {
			$this->data['asiapay_account'] = $this->config->get('asiapay_account');
		}

		if (isset($this->request->post['asiapay_method'])) {
			$this->data['asiapay_method'] = $this->request->post['asiapay_method'];
		} else {
			$this->data['asiapay_method'] = $this->config->get('asiapay_method');
		}
		
		$this->data['callback'] = HTTP_CATALOG . 'index.php?route=payment/asiapay/callback';

		if (isset($this->request->post['asiapay_order_status_id'])) {
			$this->data['asiapay_order_status_id'] = $this->request->post['asiapay_order_status_id'];
		} else {
			$this->data['asiapay_order_status_id'] = $this->config->get('asiapay_order_status_id'); 
		} 

		$this->load->model('localisation/order_status');
		
		$this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
		
		if (isset($this->request->post['asiapay_geo_zone_id'])) {
			$this->data['asiapay_geo_zone_id'] = $this->request->post['asiapay_geo_zone_id'];
		} else {
			$this->data['asiapay_geo_zone_id'] = $this->config->get('asiapay_geo_zone_id'); 
		}
		
		$this->load->model('localisation/geo_zone');
										
		$this->data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();	
		
		if (isset($this->request->post['asiapay_status'])) {
			$this->data['asiapay_status'] = $this->request->post['asiapay_status'];
		} else {
			$this->data['asiapay_status'] = $this->config->get('asiapay_status');
		}
		 
		if (isset($this->request->post['asiapay_sort_order'])) {
			$this->data['asiapay_sort_order'] = $this->request->post['asiapay_sort_order'];
		} else {
			$this->data['asiapay_sort_order'] = $this->config->get('asiapay_sort_order');
		}

		$this->id       = 'content';
		$this->template = 'payment/asiapay.tpl';
		$this->layout   = 'common/layout';
		
 		$this->render();
	}

	private function validate() {
		if (!$this->user->hasPermission('modify', 'payment/asiapay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!@$this->request->post['asiapay_email']) {
			$this->error['email'] = $this->language->get('error_email');
		}
		
		if (!@$this->request->post['asiapay_receiver']) {
			$this->error['receiver'] = $this->language->get('error_receiver');
		}
		
		if (!@$this->request->post['asiapay_account']) {
			$this->error['account'] = $this->language->get('error_account');
		}
		
		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}	
	}
}
?>