/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.tabbedpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SmartIconJButton
implements Icon,
PropertyChangeListener {
    protected Action action;
    protected Icon defaultIcon;
    protected Icon rolloverIcon;
    protected Icon pressedIcon;
    protected Icon disabledIcon;
    protected String tooltipText;
    private boolean isRollover;
    private boolean isPressed;
    private boolean isEnabled;
    private boolean isVisible;

    public SmartIconJButton(Action action) {
        this.action = action;
        this.defaultIcon = (Icon)action.getValue("SmallIcon");
        this.tooltipText = (String)action.getValue("ShortDescription");
        this.isVisible = true;
        this.isEnabled = action.isEnabled();
        action.addPropertyChangeListener(this);
    }

    public void setIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    public Icon getIcon() {
        return this.defaultIcon;
    }

    public void setRolloverIcon(Icon icon) {
        this.rolloverIcon = icon;
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setPressedIcon(Icon icon) {
        this.pressedIcon = icon;
    }

    public Icon getPressedIcon() {
        return this.pressedIcon;
    }

    public void setDisabledIcon(Icon icon) {
        this.disabledIcon = icon;
    }

    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    public void setRollover(boolean isRollover) {
        this.isRollover = isRollover;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void setPressed(boolean isPressed) {
        this.isPressed = isPressed;
    }

    public boolean isRollover() {
        return this.isRollover;
    }

    public boolean isPressed() {
        return this.isPressed;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (!this.isVisible) {
            return;
        }
        if (this.isEnabled) {
            if (this.isPressed) {
                if (this.pressedIcon != null) {
                    this.pressedIcon.paintIcon(c, g, x, y);
                } else {
                    this.defaultIcon.paintIcon(c, g, x + 1, y + 1);
                }
            } else if (this.isRollover) {
                if (this.rolloverIcon != null) {
                    this.rolloverIcon.paintIcon(c, g, x, y);
                } else {
                    this.defaultIcon.paintIcon(c, g, x - 1, y - 1);
                }
            } else if (this.defaultIcon != null) {
                this.defaultIcon.paintIcon(c, g, x, y);
            }
        } else {
            if (this.disabledIcon == null) {
                this.disabledIcon = this.createDisabledIcon();
            }
            this.disabledIcon.paintIcon(c, g, x, y);
        }
    }

    private Icon createDisabledIcon() {
        if (this.defaultIcon instanceof ImageIcon) {
            Image i = GrayFilter.createDisabledImage(((ImageIcon)this.defaultIcon).getImage());
            return new ImageIcon(i);
        }
        BufferedImage bi = new BufferedImage(this.defaultIcon.getIconWidth(), this.defaultIcon.getIconHeight(), 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(new Color(0, 0, 0, 0));
        g.fillRect(0, 0, this.defaultIcon.getIconWidth(), this.defaultIcon.getIconHeight());
        this.defaultIcon.paintIcon(null, g, 0, 0);
        g.dispose();
        Image i = GrayFilter.createDisabledImage(bi);
        return new ImageIcon(i);
    }

    public int getIconWidth() {
        int w = 0;
        if (this.defaultIcon != null) {
            w = Math.max(w, this.defaultIcon.getIconWidth());
        }
        if (this.rolloverIcon != null) {
            w = Math.max(w, this.rolloverIcon.getIconWidth());
        }
        if (this.pressedIcon != null) {
            w = Math.max(w, this.pressedIcon.getIconWidth());
        }
        return w;
    }

    public int getIconHeight() {
        int h = 0;
        if (this.defaultIcon != null) {
            h = Math.max(h, this.defaultIcon.getIconHeight());
        }
        if (this.rolloverIcon != null) {
            h = Math.max(h, this.rolloverIcon.getIconHeight());
        }
        if (this.pressedIcon != null) {
            h = Math.max(h, this.pressedIcon.getIconHeight());
        }
        return h;
    }

    public void fireAction(ActionEvent e) {
        this.action.actionPerformed(e);
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltip) {
        this.tooltipText = tooltip;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("ShortDescription")) {
            this.setTooltipText((String)evt.getNewValue());
        } else if (prop.equals("SmallIcon")) {
            this.setIcon((Icon)evt.getNewValue());
        } else if (prop.equals("enabled")) {
            this.setEnabled((Boolean)evt.getNewValue());
        }
    }
}

