/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockDropReceiver;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingPreferences;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import com.vlsolutions.swing.docking.event.DockingActionSplitComponentEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class SplitContainer
extends JSplitPane
implements DockDropReceiver {
    private static Color[] colors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.WHITE, Color.YELLOW};
    private static int colorindex = -1;
    private static final boolean DEBUG = false;
    private static final String uiClassID = "DockingSplitPaneUI";
    private boolean isPainted;
    private boolean hasProportionalLocation;
    private double proportionalLocation;

    public SplitContainer() {
        this(0);
    }

    public SplitContainer(int orientation) {
        super(orientation);
        this.setBorder(null);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public String toString() {
        if (this.getOrientation() == 1) {
            return "SplitContainer[HORIZONTAL, " + this.getTopComponent() + " / " + this.getBottomComponent() + ']';
        }
        return "SplitContainer[VERTICAL, " + this.getTopComponent() + " / " + this.getBottomComponent() + ']';
    }

    public String getTabName() {
        Component left = this.getLeftComponent();
        if (left instanceof SingleDockableContainer) {
            return ((SingleDockableContainer)((Object)left)).getDockable().getDockKey().getTabName();
        }
        if (left instanceof SplitContainer) {
            return ((SplitContainer)left).getTabName();
        }
        return null;
    }

    public void processDockableDrag(DockDragEvent event) {
        this.scanContainer(event, false);
    }

    public void processDockableDrop(DockDropEvent event) {
        this.scanContainer(event, true);
    }

    private void scanContainer(DockEvent event, boolean drop) {
        if (event.getDragSource().getDockableContainer().isAncestorOf(this)) {
            if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).delegateDrag();
            }
            return;
        }
        Point p = event.getMouseEvent().getPoint();
        Rectangle compBounds = this.getLeftComponent().getBounds();
        if (compBounds.contains(p)) {
            this.scanComponent(this.getLeftComponent(), event, drop, p, compBounds);
        } else {
            this.getRightComponent().getBounds(compBounds);
            if (compBounds.contains(p)) {
                this.scanComponent(this.getRightComponent(), event, drop, p, compBounds);
            } else if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
        }
    }

    public void setDividerLocation(double proportionalLocation) {
        if (!this.isPainted) {
            this.hasProportionalLocation = true;
            this.proportionalLocation = proportionalLocation;
        } else if (proportionalLocation < 0.0) {
            proportionalLocation = 0.0;
        } else if (proportionalLocation > 1.0) {
            proportionalLocation = 1.0;
        } else {
            super.setDividerLocation(proportionalLocation);
        }
    }

    public void setDividerLocation(int location) {
        Window w;
        super.setDividerLocation(location);
        if (!DockingPreferences.isLightWeightUsageEnabled() && (w = SwingUtilities.getWindowAncestor(this)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    w.repaint();
                }
            });
        }
    }

    public void paint(Graphics g) {
        if (!this.isPainted) {
            this.isPainted = true;
            if (this.hasProportionalLocation) {
                this.setDividerLocation(this.proportionalLocation);
                this.doLayout();
            }
        }
        super.paint(g);
    }

    public void resetToPreferredSizes() {
        super.resetToPreferredSizes();
        if (this.getLeftComponent() instanceof SplitContainer) {
            ((SplitContainer)this.getLeftComponent()).resetToPreferredSizes();
        }
        if (this.getRightComponent() instanceof SplitContainer) {
            ((SplitContainer)this.getRightComponent()).resetToPreferredSizes();
        }
    }

    public void split(Component newComp, Component child, DockingConstants.Split position) {
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (this.getLeftComponent() == child) {
            this.remove(child);
            this.setLeftComponent(split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent(newComp);
                split.setRightComponent(child);
            } else {
                split.setLeftComponent(child);
                split.setRightComponent(newComp);
            }
        } else {
            this.remove(child);
            this.setRightComponent(split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent(newComp);
                split.setRightComponent(child);
            } else {
                split.setLeftComponent(child);
                split.setRightComponent(newComp);
            }
        }
    }

    private void scanComponent(Component comp, DockEvent event, boolean drop, Point p, Rectangle compBounds) {
        int distTop = p.y - compBounds.y;
        int distLeft = p.x - compBounds.x;
        int min = Math.min(distTop, distLeft);
        int distRight = compBounds.x + compBounds.width - p.x;
        int distBottom = compBounds.y + compBounds.height - p.y;
        int min2 = Math.min(distBottom, distRight);
        min = Math.min(min, min2);
        Dockable dockable = event.getDragSource().getDockable();
        int splitState = DockingUtilities.getDockableStateFromHierarchy(this);
        int dockableState = dockable.getDockKey().getDockableState();
        if (min == distTop) {
            if (drop) {
                event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_TOP, 0.5f));
                ((DockDropEvent)event).acceptDrop();
                event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_TOP);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x, compBounds.y, compBounds.width, 20.0f);
                event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_TOP, 0.5f));
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (min == distLeft) {
            if (drop) {
                event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_LEFT, 0.5f));
                ((DockDropEvent)event).acceptDrop();
                event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_LEFT);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x, compBounds.y, 20.0f, compBounds.height);
                event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_LEFT, 0.5f));
                event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockable.getDockKey().getDockableState(), splitState, comp, DockingConstants.SPLIT_TOP, 0.5f));
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (min == distBottom) {
            if (drop) {
                event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_BOTTOM, 0.5f));
                ((DockDropEvent)event).acceptDrop();
                event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_BOTTOM);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x, compBounds.y + compBounds.height - 20, compBounds.width, 20.0f);
                event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_BOTTOM, 0.5f));
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (drop) {
            event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_RIGHT, 0.5f));
            ((DockDropEvent)event).acceptDrop();
            event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_RIGHT);
        } else {
            Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x + compBounds.width - 20, compBounds.y, 20.0f, compBounds.height);
            event.setDockingAction(new DockingActionSplitComponentEvent(event.getDesktop(), dockable, dockableState, splitState, comp, DockingConstants.SPLIT_RIGHT, 0.5f));
            ((DockDragEvent)event).acceptDrag(r2d);
        }
    }
}

