/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockGroup;
import com.vlsolutions.swing.docking.DockableActionCustomizer;
import com.vlsolutions.swing.docking.DockingConstants;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import javax.swing.Icon;

public class DockKey {
    public static final String PROPERTY_TOOLTIP = "tooltip";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_TAB_NAME = "tabName";
    public static final String PROPERTY_DOCKKEY = "dockKey";
    public static final String PROPERTY_ICON = "icon";
    public static final String PROPERTY_AUTOHIDEABLE = "autohide";
    public static final String PROPERTY_CLOSEABLE = "close";
    public static final String PROPERTY_MAXIMIZABLE = "maximizable";
    public static final String PROPERTY_NOTIFICATION = "notification";
    public static final String PROPERTY_FLOATABLE = "floatable";
    public static final String PROPERTY_DOCKABLE_STATE = "dockablestate";
    private String dockKey;
    private String name;
    private String tabName;
    private String tooltip;
    private Icon icon;
    private DockingConstants.Hide autoHideBorder;
    private boolean isAutoHideEnabled = true;
    private boolean isCloseEnabled = true;
    private boolean isMaximizeEnabled = true;
    private boolean isFloatEnabled = false;
    private float resizeWeight = 0.0f;
    private boolean notification = false;
    private HashMap clientProperties = null;
    private int dockableState = 0;
    private DockGroup dockGroup;
    private DockableActionCustomizer actionCustomizer;
    private transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public DockKey() {
    }

    public DockKey(String dockKey) {
        this(dockKey, dockKey, null, null, null);
    }

    public DockKey(String dockKey, String name) {
        this(dockKey, name, null, null, null);
    }

    public DockKey(String dockKey, String name, String tooltip) {
        this(dockKey, name, tooltip, null, null);
    }

    public DockKey(String dockKey, String name, String tooltip, Icon icon) {
        this(dockKey, name, tooltip, icon, null);
    }

    public DockKey(String dockKey, String name, String tooltip, Icon icon, DockingConstants.Hide hideBorder) {
        this.dockKey = dockKey;
        this.name = name;
        this.tooltip = tooltip;
        this.icon = icon;
        this.autoHideBorder = hideBorder;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        if (this.tooltip == null) {
            return this.name;
        }
        return this.tooltip;
    }

    public String getKey() {
        return this.dockKey;
    }

    public void setTooltip(String tooltip) {
        String old = this.tooltip;
        this.tooltip = tooltip;
        this.propertySupport.firePropertyChange(PROPERTY_TOOLTIP, old, tooltip);
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.propertySupport.firePropertyChange(PROPERTY_NAME, old, name);
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        String old = this.tabName;
        this.tabName = tabName;
        this.propertySupport.firePropertyChange(PROPERTY_TAB_NAME, old, tabName);
    }

    public void setIcon(Icon icon) {
        Icon old = this.icon;
        this.icon = icon;
        this.propertySupport.firePropertyChange(PROPERTY_ICON, old, icon);
    }

    public void setKey(String dockKey) {
        String old = this.dockKey;
        this.dockKey = dockKey;
        this.propertySupport.firePropertyChange(PROPERTY_DOCKKEY, old, dockKey);
    }

    public String getDockName() {
        return this.getKey();
    }

    public void setDockName(String name) {
        this.setKey(name);
    }

    public DockingConstants.Hide getAutoHideBorder() {
        return this.autoHideBorder;
    }

    public void setAutoHideBorder(DockingConstants.Hide border) {
        this.autoHideBorder = border;
    }

    public boolean isAutoHideEnabled() {
        return this.isAutoHideEnabled;
    }

    public void setAutoHideEnabled(boolean enabled) {
        boolean old = this.isAutoHideEnabled;
        this.isAutoHideEnabled = enabled;
        this.propertySupport.firePropertyChange(PROPERTY_AUTOHIDEABLE, old, enabled);
    }

    public boolean isCloseEnabled() {
        return this.isCloseEnabled;
    }

    public void setCloseEnabled(boolean enabled) {
        boolean old = this.isCloseEnabled;
        this.isCloseEnabled = enabled;
        this.propertySupport.firePropertyChange(PROPERTY_CLOSEABLE, old, enabled);
    }

    public boolean isMaximizeEnabled() {
        return this.isMaximizeEnabled;
    }

    public void setMaximizeEnabled(boolean enabled) {
        boolean old = this.isMaximizeEnabled;
        this.isMaximizeEnabled = enabled;
        this.propertySupport.firePropertyChange(PROPERTY_MAXIMIZABLE, old, enabled);
    }

    public boolean isFloatEnabled() {
        return this.isFloatEnabled;
    }

    public void setFloatEnabled(boolean enabled) {
        boolean old = this.isFloatEnabled;
        this.isFloatEnabled = enabled;
        this.propertySupport.firePropertyChange(PROPERTY_FLOATABLE, old, enabled);
    }

    public boolean isNotification() {
        return this.notification;
    }

    public void setNotification(boolean notification) {
        boolean old = this.notification;
        this.notification = notification;
        this.propertySupport.firePropertyChange(PROPERTY_NOTIFICATION, old, notification);
    }

    public int hashCode() {
        return this.dockKey.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof DockKey && this.dockKey.equals(((DockKey)o).dockKey);
    }

    public String toString() {
        return "DockKey[" + this.name + ']';
    }

    public DockableActionCustomizer getActionCustomizer() {
        return this.actionCustomizer;
    }

    public void setActionCustomizer(DockableActionCustomizer actionCustomizer) {
        this.actionCustomizer = actionCustomizer;
    }

    public void setDockGroup(DockGroup group) {
        this.dockGroup = group;
    }

    public DockGroup getDockGroup() {
        return this.dockGroup;
    }

    public int getDockableState() {
        return this.dockableState;
    }

    public void setDockableState(int dockableState) {
        int old = this.dockableState;
        this.dockableState = dockableState;
        this.propertySupport.firePropertyChange(PROPERTY_DOCKABLE_STATE, old, dockableState);
    }

    public float getResizeWeight() {
        return this.resizeWeight;
    }

    public void setResizeWeight(float weight) {
        this.resizeWeight = weight;
    }

    public void putProperty(String name, Object value) {
        if (this.clientProperties == null) {
            this.clientProperties = new HashMap();
        }
        this.clientProperties.put(name, value);
        this.propertySupport.firePropertyChange("clientProperty." + name, null, value);
    }

    public Object getProperty(String name) {
        if (this.clientProperties != null) {
            return this.clientProperties.get(name);
        }
        return null;
    }

    public Object removeProperty(String name) {
        if (this.clientProperties != null) {
            return this.clientProperties.remove(name);
        }
        return null;
    }
}

