/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2000-2006 Keith Godfrey and Maxym Mykhalchuk
               2007-2009 Didier Briel
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************/

package org.omegat.filters3.xml.opendoc;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

import org.omegat.util.OStrings;

/**
 * Modal dialog to edit OpenDoc filter options.
 *
 * @author Maxym Mykhalchuk
 * @author Didier Briel
 */
public class EditOpenDocOptionsDialog extends javax.swing.JDialog
{
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;
    
    /** Creates new form EditOpenDocOptionsDialog */
    public EditOpenDocOptionsDialog(java.awt.Dialog parent, OpenDocOptions options)
    {
        super(parent, true);
        this.options = options;
        initComponents();
        if (options==null)
            options = new OpenDocOptions(); // Set default options
        
        translateIndexesCB.setSelected(options.getTranslateIndexes());
        translateBookmarksCB.setSelected(options.getTranslateBookmarks());
        translateBookmarkRefsCB.setSelected(options.getTranslateBookmarkRefs());
        translateNotesCB.setSelected(options.getTranslateNotes());
        translateCommentsCB.setSelected(options.getTranslateComments());
        
        //  Handle escape key to close the window
        KeyStroke escape = KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false);
        Action escapeAction = new AbstractAction()
        {
            public void actionPerformed(ActionEvent e)
            {
                doClose(RET_CANCEL);
            }
        };
        getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).
        put(escape, "ESCAPE");                                                  // NOI18N
        getRootPane().getActionMap().put("ESCAPE", escapeAction);               // NOI18N
    }
    
    
    private OpenDocOptions options;
    public OpenDocOptions getOptions()
    {
        return options;
    }
    
    private int returnStatus = RET_CANCEL;
    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus()
    {
        return returnStatus;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        translateIndexesCB = new javax.swing.JCheckBox();
        translateBookmarksCB = new javax.swing.JCheckBox();
        translateBookmarkRefsCB = new javax.swing.JCheckBox();
        translateNotesCB = new javax.swing.JCheckBox();
        translateCommentsCB = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();

        setTitle(OStrings.getString("OpenDoc_FILTER_OPTIONS"));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        buttonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        buttonPanel.setMinimumSize(new java.awt.Dimension(143, 33));
        org.openide.awt.Mnemonics.setLocalizedText(okButton, OStrings.getString("BUTTON_OK"));
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(okButton);

        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, OStrings.getString("BUTTON_CANCEL"));
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(cancelButton);

        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

        jPanel1.setLayout(new java.awt.GridLayout(0, 1));

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel1.setMinimumSize(new java.awt.Dimension(167, 121));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, OStrings.getString("OpenDoc_TRANSLATE_ELEMENTS"));
        jPanel1.add(jLabel2);

        translateIndexesCB.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(translateIndexesCB, OStrings.getString("OpenDoc_TRANSLATE_INDEXES"));
        translateIndexesCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                translateIndexesCBradiosActionPerformed(evt);
            }
        });

        jPanel1.add(translateIndexesCB);

        org.openide.awt.Mnemonics.setLocalizedText(translateBookmarksCB, OStrings.getString("OpenDoc_TRANSLATE_BOOKMARKS"));
        translateBookmarksCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                translateBookmarksCBradiosActionPerformed(evt);
            }
        });

        jPanel1.add(translateBookmarksCB);

        translateBookmarkRefsCB.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(translateBookmarkRefsCB, OStrings.getString("OpenDoc_TRANSLATE_BOOKMARKREFS"));
        translateBookmarkRefsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                translateBookmarkRefsCBradiosActionPerformed(evt);
            }
        });

        jPanel1.add(translateBookmarkRefsCB);

        translateNotesCB.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(translateNotesCB, OStrings.getString("OpenDoc_TRANSLATE_NOTES"));
        translateNotesCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                translateNotesCBradiosActionPerformed(evt);
            }
        });

        jPanel1.add(translateNotesCB);

        translateCommentsCB.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(translateCommentsCB, OStrings.getString("OpenDoc_TRANSLATE_COMMENTS"));
        translateCommentsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                translateCommentsCBradiosActionPerformed(evt);
            }
        });

        jPanel1.add(translateCommentsCB);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, "                                                                       ");
        jLabel1.setEnabled(false);
        jPanel1.add(jLabel1);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension dialogSize = getSize();
        setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
    }// </editor-fold>//GEN-END:initComponents

    private void translateCommentsCBradiosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_translateCommentsCBradiosActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_translateCommentsCBradiosActionPerformed

    private void translateNotesCBradiosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_translateNotesCBradiosActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_translateNotesCBradiosActionPerformed

    private void translateBookmarksCBradiosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_translateBookmarksCBradiosActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_translateBookmarksCBradiosActionPerformed

    private void translateBookmarkRefsCBradiosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_translateBookmarkRefsCBradiosActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_translateBookmarkRefsCBradiosActionPerformed

    private void translateIndexesCBradiosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_translateIndexesCBradiosActionPerformed
    }//GEN-LAST:event_translateIndexesCBradiosActionPerformed
    
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_okButtonActionPerformed
    {
        options = new OpenDocOptions();
        
        options.setTranslateIndexes(translateIndexesCB.isSelected());
        options.setTranslateBookmarks(translateBookmarksCB.isSelected());
        options.setTranslateBookmarkRefs(translateBookmarkRefsCB.isSelected());
        options.setTranslateNotes(translateNotesCB.isSelected());
        options.setTranslateComments(translateCommentsCB.isSelected());
        
        doClose(RET_OK);
    }//GEN-LAST:event_okButtonActionPerformed
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
    {
        doClose(RET_CANCEL);
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
    {
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog
    
    private void doClose(int retStatus)
    {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton okButton;
    private javax.swing.JCheckBox translateBookmarksCB;
    private javax.swing.JCheckBox translateBookmarkRefsCB;
    private javax.swing.JCheckBox translateCommentsCB;
    private javax.swing.JCheckBox translateIndexesCB;
    private javax.swing.JCheckBox translateNotesCB;
    // End of variables declaration//GEN-END:variables
}
