/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.tokenizer;

import org.dts.spell.finder.Word;
import org.dts.spell.tokenizer.WordTokenizer;

public abstract class AbstractWordTokenizer
implements WordTokenizer {
    private CharSequence charSequence = "";

    public Word nextWord(int index) {
        Word orgWord;
        int length = this.getCharSequence().length();
        Word current = orgWord = this.currentWord(index);
        Word result = null;
        while (index < length && current == null) {
            current = this.currentWord(++index);
        }
        if (index < length && current != null) {
            if (current.equals(orgWord)) {
                index = orgWord.getEnd();
                while (index < length && result == null) {
                    if (current != null && !current.equals(orgWord)) {
                        result = current;
                        continue;
                    }
                    current = this.currentWord(++index);
                }
            } else {
                result = current;
            }
        }
        return result;
    }

    public Word previousWord(int index) {
        Word orgWord;
        Word current = orgWord = this.currentWord(index);
        Word result = null;
        while (index > 0 && current == null) {
            current = this.currentWord(--index);
        }
        if (index > 0 && current != null) {
            if (current.equals(orgWord)) {
                index = orgWord.getStart();
                while (index > 0 && result == null) {
                    if (current != null && !current.equals(orgWord)) {
                        result = current;
                        continue;
                    }
                    current = this.currentWord(--index);
                }
            } else {
                result = current;
            }
        }
        return result;
    }

    public CharSequence getCharSequence() {
        return this.charSequence;
    }

    public void setCharSequence(CharSequence sequence) {
        if (sequence != this.charSequence) {
            this.charSequence = sequence;
            this.updateCharSequence(0, sequence != null ? sequence.length() : 0, 2);
        }
    }

    protected boolean isStartOfSentence(CharSequence sequence, int start) {
        boolean found = false;
        --start;
        while (start >= 0 && !found) {
            if (Character.isWhitespace(sequence.charAt(start))) {
                --start;
                continue;
            }
            found = true;
        }
        return start < 0 || sequence.charAt(start) == '.';
    }
}

