/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.sourceforge.retroweaver.runtime.java.lang.StringBuffer_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    public static int XPRODUCT = 1;
    private static ResourceBundle boundle = null;

    static {
        try {
            boundle = ResourceBundle.getBundle("org.dts.spell.dictionary.myspell.messages");
        }
        catch (Exception ex) {
            boundle = null;
        }
    }

    private Utils() {
    }

    public static boolean TestAff(String a, char b, int c) {
        int i = 0;
        while (i < c) {
            if (a.charAt(i) == b) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String myRevStrDup(String s) {
        StringBuffer builder = new StringBuffer(s);
        return builder.reverse().toString();
    }

    public static boolean isSubset(String s1, String s2) {
        return s2.startsWith(s1);
    }

    public static void close(Reader rd) throws IOException {
        if (rd != null) {
            rd.close();
        }
    }

    public static void close(Writer wt) throws IOException {
        if (wt != null) {
            wt.close();
        }
    }

    public static void close(InputStream in) throws IOException {
        if (in != null) {
            in.close();
        }
    }

    public static String mkInitCap(CharSequence word) {
        StringBuffer bd = StringBuffer_.StringBuffer((CharSequence)word);
        bd.setCharAt(0, Character.toUpperCase(bd.charAt(0)));
        return bd.toString();
    }

    private static void swap(long[] numbers, int index1, int index2) {
        long temp = numbers[index1];
        numbers[index1] = numbers[index2];
        numbers[index2] = temp;
    }

    private static void siftDown(long[] numbers, int root, int bottom, IndexComparator comparator) {
        boolean done = false;
        while (root * 2 <= bottom && !done) {
            int maxChild = root * 2 == bottom ? root * 2 : (comparator.isGreater(numbers[root * 2], numbers[root * 2 + 1]) ? root * 2 : root * 2 + 1);
            if (comparator.isLess(numbers[root], numbers[maxChild])) {
                Utils.swap(numbers, root, maxChild);
                root = maxChild;
                continue;
            }
            done = true;
        }
    }

    public static void heapSort(long[] numbers, IndexComparator comparator) {
        int arraySize = numbers.length;
        int i = arraySize / 2 - 1;
        while (i >= 0) {
            Utils.siftDown(numbers, i, arraySize - 1, comparator);
            --i;
        }
        i = arraySize - 1;
        while (i >= 1) {
            Utils.swap(numbers, 0, i);
            Utils.siftDown(numbers, 0, i - 1, comparator);
            --i;
        }
    }

    public static <T> int binarySearch(T obj, int length, IndexSearcher<T> searcher) {
        int low = 0;
        int high = length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = searcher.compare(mid, obj);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static String getString(String str) {
        if (boundle != null) {
            return boundle.getString(str);
        }
        return str;
    }

    public static void throwIOException(String resource, Object ... arguments) throws IOException {
        MessageFormat form = new MessageFormat(Utils.getString(resource));
        throw new IOException(form.format(arguments));
    }

    public static interface IndexComparator {
        public boolean isLess(long var1, long var3);

        public boolean isGreater(long var1, long var3);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IndexSearcher<T> {
        public int compare(int var1, T var2);
    }
}

