/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockDropReceiver;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingPreferences;
import com.vlsolutions.swing.docking.event.DockDragEvent;
import com.vlsolutions.swing.docking.event.DockDropEvent;
import com.vlsolutions.swing.docking.event.DockEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class SplitContainer
extends JSplitPane
implements DockDropReceiver {
    private static Color[] colors = new Color[]{Color.RED, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.WHITE, Color.YELLOW};
    private static int colorindex = -1;
    private static final boolean DEBUG = false;
    private static final String uiClassID = "DockingSplitPaneUI";
    private boolean isPainted;
    private boolean hasProportionalLocation;
    private double proportionalLocation;

    public SplitContainer() {
        this(0);
    }

    public SplitContainer(int orientation) {
        super(orientation);
        this.setBorder(null);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public String toString() {
        if (this.getOrientation() == 1) {
            return "SplitContainer[HORIZONTAL, " + this.getTopComponent() + " / " + this.getBottomComponent() + ']';
        }
        return "SplitContainer[VERTICAL, " + this.getTopComponent() + " / " + this.getBottomComponent() + ']';
    }

    public void processDockableDrag(DockDragEvent event) {
        this.scanContainer(event, false);
    }

    public void processDockableDrop(DockDropEvent event) {
        this.scanContainer(event, true);
    }

    private void scanContainer(DockEvent event, boolean drop) {
        Point p = event.getMouseEvent().getPoint();
        Rectangle compBounds = this.getLeftComponent().getBounds();
        if (compBounds.contains(p)) {
            this.scanComponent(this.getLeftComponent(), event, drop, p, compBounds);
        } else {
            this.getRightComponent().getBounds(compBounds);
            if (compBounds.contains(p)) {
                this.scanComponent(this.getRightComponent(), event, drop, p, compBounds);
            } else if (drop) {
                ((DockDropEvent)event).rejectDrop();
            } else {
                ((DockDragEvent)event).rejectDrag();
            }
        }
    }

    public void setDividerLocation(double proportionalLocation) {
        if (!this.isPainted) {
            this.hasProportionalLocation = true;
            this.proportionalLocation = proportionalLocation;
        } else if (proportionalLocation < 0.0) {
            proportionalLocation = 0.0;
        } else if (proportionalLocation > 1.0) {
            proportionalLocation = 1.0;
        } else {
            super.setDividerLocation(proportionalLocation);
        }
    }

    public void setDividerLocation(int location) {
        Window w;
        super.setDividerLocation(location);
        if (!DockingPreferences.isLightWeightUsageEnabled() && (w = SwingUtilities.getWindowAncestor(this)) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    w.repaint();
                }
            });
        }
    }

    public void paint(Graphics g) {
        if (!this.isPainted) {
            this.isPainted = true;
            if (this.hasProportionalLocation) {
                this.setDividerLocation(this.proportionalLocation);
                this.doLayout();
            }
        }
        super.paint(g);
    }

    public void resetToPreferredSizes() {
        super.resetToPreferredSizes();
        if (this.getLeftComponent() instanceof SplitContainer) {
            ((SplitContainer)this.getLeftComponent()).resetToPreferredSizes();
        }
        if (this.getRightComponent() instanceof SplitContainer) {
            ((SplitContainer)this.getRightComponent()).resetToPreferredSizes();
        }
    }

    public void split(Component newComp, Component child, DockingConstants.Split position) {
        SplitContainer split = position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_BOTTOM ? new SplitContainer(0) : new SplitContainer(1);
        if (this.getLeftComponent() == child) {
            this.remove(child);
            this.setLeftComponent(split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent(newComp);
                split.setRightComponent(child);
            } else {
                split.setLeftComponent(child);
                split.setRightComponent(newComp);
            }
        } else {
            this.remove(child);
            this.setRightComponent(split);
            if (position == DockingConstants.SPLIT_TOP || position == DockingConstants.SPLIT_LEFT) {
                split.setLeftComponent(newComp);
                split.setRightComponent(child);
            } else {
                split.setLeftComponent(child);
                split.setRightComponent(newComp);
            }
        }
    }

    private void scanComponent(Component comp, DockEvent event, boolean drop, Point p, Rectangle compBounds) {
        int distTop = p.y - compBounds.y;
        int distLeft = p.x - compBounds.x;
        int min = Math.min(distTop, distLeft);
        int distBottom = compBounds.y + compBounds.height - p.y;
        int distRight = compBounds.x + compBounds.width - p.x;
        int min2 = Math.min(distBottom, distRight);
        if ((min = Math.min(min, min2)) == distTop) {
            if (drop) {
                ((DockDropEvent)event).acceptDrop();
                event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_TOP);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x, compBounds.y, compBounds.width, 20.0f);
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (min == distLeft) {
            if (drop) {
                ((DockDropEvent)event).acceptDrop();
                event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_LEFT);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x, compBounds.y, 20.0f, compBounds.height);
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (min == distBottom) {
            if (drop) {
                ((DockDropEvent)event).acceptDrop();
                event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_BOTTOM);
            } else {
                Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x, compBounds.y + compBounds.height - 20, compBounds.width, 20.0f);
                ((DockDragEvent)event).acceptDrag(r2d);
            }
        } else if (drop) {
            ((DockDropEvent)event).acceptDrop();
            event.getDesktop().splitComponent(comp, event.getDragSource().getDockable(), DockingConstants.SPLIT_RIGHT);
        } else {
            Rectangle2D.Float r2d = new Rectangle2D.Float(compBounds.x + compBounds.width - 20, compBounds.y, 20.0f, compBounds.height);
            ((DockDragEvent)event).acceptDrag(r2d);
        }
    }
}

