/*
 * Decompiled with CFR 0.152.
 */
package com.twovi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static List getFileContents(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String str;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((str = br.readLine()) != null) {
                lines.add(str);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lines;
    }

    public static String getFileContentsAsString(File file) {
        StringBuffer result = new StringBuffer();
        try {
            String str;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((str = br.readLine()) != null) {
                result.append(str);
                result.append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static void copyDirRecursive(File src, File dest) throws IOException {
        FileUtils.copyDirRecursive(src, dest, null);
    }

    public static void copyDirRecursive(File src, File dest, FilenameFilter filter) throws IOException {
        dest.mkdir();
        File[] files = src.listFiles(filter);
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            System.out.println("Copy " + f);
            if (f.isDirectory()) {
                FileUtils.copyDirRecursive(f, new File(dest, f.getName()), filter);
            } else {
                FileUtils.copyFile(f, new File(dest, f.getName()));
            }
            ++i;
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        if (!dst.exists()) {
            dst.createNewFile();
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

