/*
 * Decompiled with CFR 0.152.
 */
package com.twovi.tools.js;

import com.twovi.tools.js.Token;
import com.twovi.tools.js.Tokenizer;
import com.twovi.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class WeightWatch {
    public static final String VERSION = "0.1.0";
    private static String private_prefix = null;

    public static void main(String[] args) {
        System.out.println("Consyn JavaScript WeightWatch 0.1.0");
        System.out.println("Latest updates on: http://tools.2vi.nl/");
        System.out.println("");
        System.out.println("Created by 2Vi design & development");
        System.out.println("");
        try {
            WeightWatch.watch(new File(args[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void watch(File inFile) throws IOException {
        String content = FileUtils.getFileContentsAsString(inFile);
        Tokenizer tokenizer = new Tokenizer(content);
        HashMap<String, WeightEntry> tokenMap = new HashMap<String, WeightEntry>();
        while (tokenizer.hasNext()) {
            Token t = tokenizer.next();
            String ts = t.getToken();
            if (tokenMap.get(ts) == null) {
                tokenMap.put(ts, new WeightEntry(ts, 1));
                continue;
            }
            ((WeightEntry)tokenMap.get(ts)).count();
        }
        TreeSet sorted = new TreeSet();
        sorted.addAll(tokenMap.values());
        Iterator itt = sorted.iterator();
        while (itt.hasNext()) {
            WeightEntry w = (WeightEntry)itt.next();
            String ts = w.token;
            int i = w.count;
            System.out.println(String.valueOf(ts.substring(0, Math.min(ts.length(), 30))) + (ts.length() > 30 ? "..." : "") + " : \t " + i + " \t (" + w.getBytes() + " chars)");
        }
        System.out.println("Total size: " + content.length() + "chars");
    }

    static class WeightEntry
    implements Comparable {
        public String token;
        public int count;

        WeightEntry(String t, int c) {
            this.token = t;
            this.count = c;
        }

        public void count() {
            ++this.count;
        }

        public int getBytes() {
            return this.token.length() * this.count;
        }

        public int compareTo(Object o) {
            WeightEntry w = (WeightEntry)o;
            int d = this.getBytes() - w.getBytes();
            if (d == 0) {
                return this.token.compareTo(w.token);
            }
            return d;
        }
    }
}

