/*
 * Decompiled with CFR 0.152.
 */
package com.twovi.tools.js;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Token {
    private String token;
    private String type = "unknown";
    public static final String IDENT = "IDENT";
    public static final String WHITESPACE = "WHITESPACE";
    public static final String COMMENT = "COMMENT";
    public static final String CONDITIONAL_COMMENT = "CONDITIONAL_COMMENT";
    public static final String DOCCOMMENT = "DOCCOMMENT";
    public static final String FLOAT = "FLOAT";
    public static final String INTEGER = "INTEGER";
    public static final String SYMBOL = "SYMBOL";
    public static final String QUOTED = "QUOTED";
    public static final String REGEX = "REGEX";
    public static final String FUNCTION = "FUNCTION";
    public static final String DOT = "DOT";
    public static final String VAR = "VAR";
    public static final String LP = "LP";
    public static final String RP = "RP";
    public static final String RC = "RC";
    public static final String LC = "LC";
    public static final String KEYWORD = "KEYWORD";
    public static final String reComment = "//.*?\n|/\\*.*?\\*/";
    public static final String reIdent = "[_\\$a-zA-Z][_\\$\\w]*\\b";
    public static final String reInt = "[+-]?\\d+";
    public static final String reFloat = "[+-]?\\d+(([.]\\d+)*([eE][+-]?\\d+))?";
    public static final String reSingleQuoted = "'((\\\\.)|([^']))*'";
    public static final String reDoubleQuoted = "\"((\\\\.)|([^\"]))*\"";
    public static final String reRegex = "/((\\\\.)|([^/\n]))*?/[a-zA-Z]*";
    public static final List keywords = Arrays.asList("arguments", "abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with");

    public String getToken() {
        return this.token;
    }

    public void setToken(String string) {
        this.token = string;
        this.type = string != null ? this.getTokenType(string) : "UNDEFINED";
    }

    public String getType() {
        return this.type;
    }

    public Token(String string) {
        this.setToken(string);
    }

    public String getTokenType(String string) {
        if (string.toLowerCase().equals("function")) {
            return FUNCTION;
        }
        if (string.toLowerCase().equals("var")) {
            return VAR;
        }
        if (string.toLowerCase().equals(".")) {
            return DOT;
        }
        if (string.toLowerCase().equals("{")) {
            return LC;
        }
        if (string.toLowerCase().equals("}")) {
            return RC;
        }
        if (string.toLowerCase().equals("(")) {
            return LP;
        }
        if (string.toLowerCase().equals(")")) {
            return RP;
        }
        if (string.startsWith("/*@") && string.endsWith("@*/")) {
            return CONDITIONAL_COMMENT;
        }
        if (string.startsWith("/**") && string.endsWith("*/")) {
            return DOCCOMMENT;
        }
        if (string.startsWith("//") || string.startsWith("/*") && string.endsWith("*/")) {
            return COMMENT;
        }
        if (string.matches(reIdent)) {
            if (keywords.contains(string.toLowerCase())) {
                return KEYWORD;
            }
            return IDENT;
        }
        if (string.matches(reInt)) {
            return INTEGER;
        }
        if (string.matches(reFloat)) {
            return FLOAT;
        }
        if (string.matches(reRegex)) {
            return REGEX;
        }
        if (string.matches("'((\\\\.)|([^']))*'|\"((\\\\.)|([^\"]))*\"")) {
            return QUOTED;
        }
        if (string.matches("\\t|\\s")) {
            return WHITESPACE;
        }
        return SYMBOL;
    }

    public String toString() {
        return "<" + this.getType() + ">" + this.getToken() + "</" + this.getType() + ">";
    }

    public static void writeTokensToFile(List list, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            printWriter.print(token.getToken());
        }
        printWriter.close();
    }
}

