/*
 * Decompiled with CFR 0.152.
 */
package com.twovi.tools.js;

import com.twovi.tools.js.Scope;
import com.twovi.tools.js.Token;
import com.twovi.tools.js.Tokenizer;
import com.twovi.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Obfuscator {
    public static final String VERSION = "0.3.6";
    private static String private_prefix = null;
    private static int state = 0;
    private static String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ$";
    private static String charsSecond = chars + "0123456789";

    public static void main(String[] stringArray) {
        System.out.println("ObfuscateJS Javascript Obfuscator 0.3.6");
        System.out.println("Latest updates on: http://tools.2vi.nl/");
        System.out.println("");
        System.out.println("Created by 2Vi design & development");
        System.out.println("");
        try {
            File file = new File(stringArray[1]);
            Obfuscator.obfuscate(new File(stringArray[0]), file, stringArray.length > 2 ? stringArray[2] : null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(0);
        }
    }

    public static void obfuscate(File file, File file2) throws IOException {
        Obfuscator.obfuscate(file, file2, null);
    }

    public static void obfuscate(File file, File file2, String string) throws IOException {
        String string2 = FileUtils.getFileContentsAsString(file);
        private_prefix = string;
        Tokenizer tokenizer = new Tokenizer(string2);
        List list = Obfuscator.filterWhitespace(tokenizer);
        Map map = Obfuscator.getPublicIdents(list);
        if (private_prefix != null) {
            list = Obfuscator.renamePrivateIdents(list, map, private_prefix);
        }
        map = Obfuscator.getPublicIdents(list);
        list = Obfuscator.renameLocalIdents(list, map);
        Token.writeTokensToFile(list, file2);
    }

    private static List renamePrivateIdents(List list, Map map, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (!token.getType().equals("IDENT") || !token.getToken().startsWith(string)) continue;
            if (hashMap.containsKey(token.getToken())) {
                token.setToken((String)hashMap.get(token.getToken()));
                continue;
            }
            String string2 = Obfuscator.generateIdent(map, false);
            hashMap.put(token.getToken(), string2);
            token.setToken(string2);
        }
        return list;
    }

    private static List renameLocalIdents(List list, Map map) {
        if (list.size() == 0) {
            return list;
        }
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        Stack<Integer> stack = new Stack<Integer>();
        Scope scope = new Scope(null);
        Iterator iterator = list.iterator();
        token = (Token)iterator.next();
        while (token != null) {
            token4 = token3;
            token3 = token2;
            token2 = token;
            token = iterator.hasNext() ? (Token)iterator.next() : null;
            if (token2 == null) continue;
            if (token2.getToken().equals("=")) {
                bl3 = false;
            }
            if (token2.getType() == "LC") {
                ++n;
            }
            if (token2.getType() == "RC") {
                int n2;
                if (stack.size() > 0 && (n2 = ((Integer)stack.peek()).intValue()) == n) {
                    stack.pop();
                    scope = scope.getPrevious();
                }
                --n;
            }
            if (!(token2.getType() != "FUNCTION" || token4 != null && token4.getToken().equals("new"))) {
                bl = true;
                scope = scope.getNext();
                stack.add(new Integer(n + 1));
            }
            if (token2.getType() == "VAR") {
                bl3 = true;
            }
            if (token2.getType() == "LP" && bl) {
                bl2 = true;
                bl = false;
            }
            if (token2.getType() == "RP" && bl2) {
                bl2 = false;
            }
            if (!(token2.getType() != "IDENT" || token3 != null && token3.getType() == "DOT" || token != null && token.getToken().equals(":") && !token3.getToken().equals("?"))) {
                String string = scope.getMapping(token2.getToken());
                if (string != null) {
                    token2.setToken(string);
                } else if ((bl2 || bl3 && stack.size() > 0) && token2.getToken().length() > 2) {
                    String string2 = Obfuscator.generateIdent(map, true);
                    scope.addMapping(token2.getToken(), string2);
                    token2.setToken(string2);
                }
                bl3 = false;
            }
            if (token2.getType() != "KEYWORD") continue;
            bl3 = false;
        }
        return list;
    }

    private static Map getPublicIdents(List list) {
        HashMap<String, Token> hashMap = new HashMap<String, Token>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            if (!token.getType().equals("IDENT")) continue;
            hashMap.put(token.getToken(), token);
        }
        return hashMap;
    }

    private static List filterWhitespace(Tokenizer tokenizer) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        Token token = tokenizer.next();
        Token token2 = null;
        Token token3 = null;
        while (token != null) {
            if (arrayList.size() > 0) {
                token3 = (Token)arrayList.get(arrayList.size() - 1);
            }
            token2 = token;
            token = tokenizer.hasNext() ? tokenizer.next() : null;
            if (token2 == null) continue;
            if (token2.getType().equals("WHITESPACE") || token2.getType().equals("COMMENT") || token2.getType().equals("DOCCOMMENT")) {
                if (token == null || token3 == null) continue;
                String string = token.getType();
                String string2 = token3.getType();
                if (!string.equals("IDENT") && !string.equals("FUNCTION") && !string.equals("VAR") && !string.equals("KEYWORD") && !string.equals("INTEGER") && !string.equals("FLOAT") && !string.equals("REGEX") && !string.equals("QUOTED")) continue;
                if (string2.equals("IDENT") || string2.equals("FUNCTION") || string2.equals("VAR") || string2.equals("KEYWORD") || string2.equals("INTEGER") || string2.equals("FLOAT") || string2.equals("REGEX") || string2.equals("QUOTED")) {
                    arrayList.add(new Token(" "));
                    continue;
                }
                if (token3.getType() != "RC" && !token3.getToken().equals("]")) continue;
                arrayList.add(new Token("\n"));
                continue;
            }
            arrayList.add(token2);
        }
        return arrayList;
    }

    public static String generateIdent(Map map, boolean bl) {
        String string = null;
        while (map.containsKey(string = Obfuscator.generateIdent(bl)) || Token.keywords.contains(string)) {
        }
        return string;
    }

    public static String generateIdent(boolean bl) {
        int n = state;
        StringBuffer stringBuffer = new StringBuffer(private_prefix == null || bl ? "" : private_prefix);
        char c = chars.charAt(n % chars.length());
        stringBuffer.append(c);
        n /= chars.length();
        do {
            c = charsSecond.charAt(n % charsSecond.length());
            stringBuffer.append(c);
        } while ((n /= charsSecond.length()) > 1);
        ++state;
        return new String(stringBuffer);
    }
}

