/*
 * Decompiled with CFR 0.152.
 */
package com.twovi.tools.consyn;

import com.twovi.tools.js.Obfuscator;
import com.twovi.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class BuildUtils {
    public static final String S = File.separator;
    public static final FilenameFilter filenameFilter = new FilenameFilter(){

        public boolean accept(File dir, String file) {
            return !file.equals(".svn") && !file.equals("CVS");
        }
    };

    private static void writeExampleIndex(File indexFile, File dir) {
        try {
            indexFile.createNewFile();
            FileWriter out = new FileWriter(indexFile);
            out.write("<examples>\n");
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                File exFileDir;
                File f = files[i];
                if (f.isDirectory() && f.getName().charAt(0) != '.' && (exFileDir = new File(f, "examples")).exists()) {
                    out.write("  <module name=\"");
                    out.write(f.getName());
                    out.write("\">\n");
                    File[] exFiles = exFileDir.listFiles();
                    int j = 0;
                    while (j < exFiles.length) {
                        File exFile = exFiles[j];
                        if (exFile.isFile() && exFile.getName().toLowerCase().endsWith(".html")) {
                            String exFileName = exFile.getName();
                            out.write("    <example file=\"");
                            out.write(String.valueOf(f.getName()) + "/examples/" + exFileName);
                            out.write("\"  name=\"");
                            int k = exFileName.lastIndexOf(46);
                            String name = String.valueOf(exFileName.substring(0, 1).toUpperCase()) + exFileName.substring(1, k);
                            name = name.replace('_', ' ');
                            out.write(name);
                            out.write("\" />\n");
                        }
                        ++j;
                    }
                    out.write("  </module>\n");
                }
                ++i;
            }
            out.write("</examples>");
            ((Writer)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void buildModule(String moduleDir, String moduleName, String releaseModulesDir, String releaseDocDir, String headerFile, boolean debug) {
        System.out.println("build module: " + moduleDir);
        try {
            String includeDir = String.valueOf(moduleDir) + S + "include";
            String localeDir = String.valueOf(moduleDir) + S + "locale";
            String resourceDir = String.valueOf(moduleDir) + S + "resources";
            File infoFile = new File(String.valueOf(moduleDir) + S + "module.info");
            File destFile = new File(String.valueOf(releaseModulesDir) + S + moduleName + ".js");
            destFile.createNewFile();
            List info = FileUtils.getFileContents(infoFile);
            FileWriter out = new FileWriter(destFile);
            BuildUtils.writeFileContents(new File(headerFile), out);
            Iterator itt = info.iterator();
            while (itt.hasNext()) {
                String s = (String)itt.next();
                String[] parts = s.split(" ");
                if (parts.length < 2 || !parts[0].equals("#include")) continue;
                out.write("\n\n\n// //////////// Include " + parts[1] + " ////////////\n\n");
                BuildUtils.writeFileContents(new File(includeDir, parts[1]), out);
            }
            ((Writer)out).close();
            if (!debug) {
                Obfuscator.main(new String[]{destFile.getAbsoluteFile().toString(), destFile.getAbsoluteFile().toString(), "_"});
            }
            FileUtils.copyDirRecursive(new File(localeDir), new File(releaseModulesDir), filenameFilter);
            FileUtils.copyDirRecursive(new File(resourceDir), new File(releaseModulesDir), filenameFilter);
            File moduleDocDir = new File(String.valueOf(releaseDocDir) + S + moduleName);
            FileUtils.copyDirRecursive(new File(String.valueOf(moduleDir) + S + "doc"), moduleDocDir, filenameFilter);
            BuildUtils.writeExampleIndex(new File(String.valueOf(releaseDocDir) + S + "examples.xml"), new File(releaseDocDir));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeFileContents(File file, Writer out) {
        try {
            String str;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((str = br.readLine()) != null) {
                out.write(str);
                out.write("\n");
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: BuildUtils {srcRootDir} {destDir} {docDir} {headerFile} {debugflag}");
            System.exit(0);
        }
        String S = File.separator;
        String srcRootDir = args[0];
        String moduleDestDir = args[1];
        String moduleDocDir = args[2];
        String headerFile = args[3];
        boolean debug = false;
        if (args.length > 4) {
            debug = args[4].toLowerCase().equals("debug");
        }
        File srcRoot = new File(srcRootDir);
        String[] modules = srcRoot.list();
        int i = 0;
        while (i < modules.length) {
            File moduleDir = new File(String.valueOf(srcRoot.getPath()) + S + modules[i]);
            if (moduleDir.isDirectory() && modules[i].length() > 0 && Character.isLetter(modules[i].charAt(0))) {
                BuildUtils.buildModule(moduleDir.getAbsolutePath(), modules[i], moduleDestDir, moduleDocDir, headerFile, debug);
            }
            ++i;
        }
    }
}

