<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

/*
==========================================================
	ABSOLUTE FILES AND PATH FOR SYSTEM
==========================================================
*/

	// Absolute path
	$path_name = basename(getcwd());
	if( $path_name == 'ajax' )
		$DIR_TO_BLOG = '../';
	else
		$DIR_TO_BLOG = './';

	// Paths
	define('PATH_PLUGINS',				$DIR_TO_BLOG . 'plugins/');
	define('PATH_LANG',					$DIR_TO_BLOG . 'lang/');
	define('PATH_TEMPLATES',			$DIR_TO_BLOG . 'templates/');
	define('PATH_PUBLIC',				$DIR_TO_BLOG . 'content/public/');
	define('PATH_PRIVATE',				$DIR_TO_BLOG . 'content/private/');
	define('PATH_TMP',					$DIR_TO_BLOG . 'content/tmp/');
	define('PATH_ADMIN',					$DIR_TO_BLOG . 'admin/');
	define('PATH_KERNEL',				PATH_ADMIN . 'kernel/');

	define('PATH_POSTS',					PATH_PUBLIC . 'posts/');
	define('PATH_COMMENTS',				PATH_PUBLIC . 'comments/');
	define('PATH_RSS',					PATH_PUBLIC . 'rss/');
	define('PATH_PROFILES_PICTURES',	PATH_PUBLIC . 'profiles/');
	define('PATH_UPLOAD',				PATH_PUBLIC . 'upload/');
	define('PATH_UPLOAD_PICTURES',	PATH_PUBLIC . PATH_UPLOAD . 'pictures/');
	define('PATH_UPLOAD_VIDEOS',		PATH_PUBLIC . PATH_UPLOAD . 'videos/');
	define('PATH_UPLOAD_TEXT',			PATH_PUBLIC . PATH_UPLOAD . 'text/');
	define('PATH_UPLOAD_OTHERS',		PATH_PUBLIC . PATH_UPLOAD . 'others/');

	// XML files
	define('FILE_XML_CATEGORIES',		PATH_PRIVATE . 'categories.xml');
	define('FILE_XML_COMMENTS',		PATH_PRIVATE . 'comments.xml');
	define('FILE_XML_POST',				PATH_PRIVATE . 'post.xml');
	define('FILE_XML_CONFIG',			PATH_PRIVATE . 'config.xml');
	define('FILE_XML_LINKS',			PATH_PRIVATE . 'links.xml');
	define('FILE_XML_PROFILES',		PATH_PRIVATE . 'profiles.xml');
	define('FILE_XML_SYSLOG',			PATH_PRIVATE . 'syslog.xml');
	define('FILE_XML_TAGS',				PATH_PRIVATE . 'tags.xml');

	// :P
	define('FILE_SHADOW',				PATH_PRIVATE . 'shadow.php');
	define('FILE_KEYS', 					PATH_PRIVATE . 'keys.php');

/*
==========================================================
	CLASS
==========================================================
*/
	require( PATH_KERNEL	. 'class.nbxml.php' );
	require( PATH_KERNEL	. 'class.login.php' );

	require( PATH_KERNEL	. 'class.categories_dbxml.php' );
	require( PATH_KERNEL	. 'class.comments_dbxml.php' );
	require( PATH_KERNEL	. 'class.config_dbxml.php' );
	require( PATH_KERNEL	. 'class.tags_dbxml.php' );
	require( PATH_KERNEL	. 'class.links_dbxml.php' );
	require( PATH_KERNEL	. 'class.post_dbxml.php' );
	require( PATH_KERNEL	. 'class.profiles_dbxml.php' );
	require( PATH_KERNEL . 'class.email.php' );

/*
==========================================================
	OBJECTS
==========================================================
*/
	$nb_categories	= new CATEGORIES_DBXML( FILE_XML_CATEGORIES );
	$nb_comments	= new COMMENTS_DBXML( FILE_XML_COMMENTS );
	$nb_blog			= new CONFIG_DBXML( FILE_XML_CONFIG );
	$nb_post			= new POST_DBXML( FILE_XML_POST );
	$nb_links		= new LINKS_DBXML( FILE_XML_LINKS );
	$nb_profiles	= new PROFILES_DBXML( FILE_XML_PROFILES );
	$nb_tags			= new TAGS_DBXML( FILE_XML_TAGS );
	$nb_functions	= new NBFUNCTIONS();
	$nb_mail			= new EMAIL();

/*
==========================================================
	ABSOLUTE FILES AND PATH FOR HTML
==========================================================
*/
	define('BOOLEAN_DEBUG',						true);
	define('BOOLEAN_REWRITEURL',				($nb_blog->get_rewriteurl() == 1));

	define('HTML_PATH_BASE',					$nb_blog->get_path());

	define('PHP_PATH_TEMPLATE',				PATH_TEMPLATES . $nb_blog->get_template());
	define('HTML_PATH_TEMPLATE',				HTML_PATH_BASE . 'templates/' . $nb_blog->get_template());

	define('HTML_PATH_AJAX',					HTML_PATH_BASE . 'ajax/');

	define('HTML_PATH_PROFILES_PICTURE',	HTML_PATH_BASE . PATH_PROFILES_PICTURES);
	
	// Javascript files
	define('HTML_FILE_JS_JQUERY',				HTML_PATH_BASE . 'admin/js/jquery/jquery.js');
	define('HTML_FILE_JS_FUNCTIONS',			HTML_PATH_BASE . 'admin/js/nb/functions.js');

	// RSS
	define('HTML_FILE_XML_RSS',				HTML_PATH_BASE . 'content/public/rss/rss.xml');

/*
==========================================================
	GLOBALS VARIABLES
==========================================================
*/
	define('SYSTEM_NAME', 'Nibbleblog');
	define('SYSTEM_VERSION', '3.0.2');
	define('SYSTEM_DATE', '19/12/10');

	// Variables de error
	$_FLAG['success'] = false;
	$_FLAG['error'] = false;
	$_FLAG['msj'] = '';

	// Variables de formularios
	$_FORM = array();

	// Variables GET and POST
	$_URL = array();

	// Number of page
	$nb_functions->valid_int( $_GET['page'] ) ? $_URL['page'] = $_GET['page'] : $_URL['page'] = 0;

	// ID Post
	$nb_functions->valid_int( $_GET['idpost'] ) ? $_URL['idpost'] = $_GET['idpost'] : $_URL['idpost'] = 0;

	// Category name
	$_URL['cat'] = $_GET['cat'];

	// Category name
	$_URL['tag'] = $_GET['tag'];

	// View
	$_URL['view'] = $_GET['view'];

/*
==========================================================
	FIX MAGIC QUOTES (for PHP<5.3)
==========================================================
*/
	if( $_SERVER['REQUEST_METHOD'] == 'POST' )
	{
		// Magic quotes ON ?
		if( get_magic_quotes_gpc() != 0 )
			$_POST = $nb_functions->clean_magic_quotes($_POST);
	}

/*
==========================================================
	LANGUAGE
==========================================================
*/
	if( !@include( PATH_LANG . $nb_blog->get_language() . '.php' ) )
		require( PATH_LANG . 'english.php' );

/*
==========================================================
	DEBUG
==========================================================
*/
	if( !BOOLEAN_DEBUG )
		error_reporting(0);

?>
