<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

/*
==========================================================
	CHECKS!
==========================================================
*/

if( file_exists('content/private') || file_exists('content/public') )
	exit('Blog already installed');

/*
==========================================================
	VARIABLES
==========================================================
*/

define('SYSTEM_NAME', 'Nibbleblog');
define('SYSTEM_VERSION', '3.0.2');
define('SYSTEM_DATE', '19/12/10');

$status = true;
$flag_error = false;
$flag_installation = false;

// OBJ NBInstall
require( 'admin/kernel/class.nbinstall.php' );
$nbinstall = new NBINSTALL();

/*
==========================================================
	FUNCTIONS
==========================================================
*/

function random_text($length)
{
	 $characteres = "1234567890abcdefghijklmnopqrstuvwxyz";
	 for($i=0; $i<$length; $i++)
		$text .= $characteres{rand(0,35)};
	 return $text;
}

function unixstamp_to_date($gmt_user, $time_unix)
{
	$zone = 3600 * $gmt_user;
	$date = array();
	$date['s'] = date('s', $time_unix + $zone);
	$date['i'] = date('i', $time_unix + $zone);
	$date['h'] = date('h', $time_unix + $zone);
	$date['H'] = date('H', $time_unix + $zone);
	$date['d'] = date('d', $time_unix + $zone);
	$date['N'] = date('N', $time_unix + $zone);
	$date['n'] = date('n', $time_unix + $zone);
	$date['m'] = date('m', $time_unix + $zone);
	$date['Y'] = date('Y', $time_unix + $zone);
	$date['y'] = date('y', $time_unix + $zone);
	$date['a'] = date('a', $time_unix + $zone);	
	return( $date );
}

function unixstamp()
{
	return( time() - date('Z') );
}

/*
==========================================================
	MAIN
==========================================================
*/

// SESSION
session_start();

// LANG
if( !@include( 'lang/'. $_GET['lang'] . '.php' ) )
	require( 'lang/english.php' );

// Try to give permissions to the directory content
@chmod('content',0777);

// Installation
if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{	
	// Directories
	$flag_error = !file_exists('content');
	
	if( !@mkdir('content/private',0777, true) ) { $flag_error = true;};
	if( !@mkdir('content/public',0777, true) ) { $flag_error = true;};
	if( !@mkdir('content/tmp',0777, true) ) { $flag_error = true;};
	if( !@mkdir('content/public/upload',0777, true) ) { $flag_error = true;};
	if( !@mkdir('content/public/rss',0777,true) ) { $flag_error = true;};
	if( !@mkdir('content/public/profiles',0777,true) ) { $flag_error = true;};
	if( !@mkdir('content/public/posts',0777,true) ) { $flag_error = true; };
	if( !@mkdir('content/public/comments',0777,true) ) { $flag_error = true;};

	if( !$flag_error )
	{
		// Files
		require('admin/kernel/class.nbxml.php');
		
		// Config.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<config>';
		$xml .= '</config>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$obj->ADD_Element('name', $_POST['name']);
		$obj->ADD_Element('description', $_POST['description']);
		$obj->ADD_Element('language', $_POST['lang']);
		$obj->ADD_Element('timezone', '0');
		$obj->ADD_Element('template', 'default');
		$obj->ADD_Element('footer', 'Look behind you, a Three-Headed Monkey!');
		$obj->ADD_Element('about', '');
		$obj->ADD_Element('url', $_POST['url']);
		$obj->ADD_Element('path', $_POST['path']);
		$obj->ADD_Element('rewriteurl', '0');
		$obj->ADD_Element('mail_notification', '0');
		$obj->ADD_Element('items_rss', '5');
		$obj->ADD_Element('items_page', '5');
		$node = $obj->ADD_Element('plugins', '');
		$node->ADD_Element('plugin', 'about');
		$node->ADD_Element('plugin', 'categories');
		$node->ADD_Element('plugin', 'links');
		$node->ADD_Element('plugin', 'tags');
		$obj->asXml( 'content/private/config.xml' );

		// categories.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<categories autoinc="3">';
		$xml .= '</categories>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$node = $obj->ADD_Element('category', '');
		$node->addAttribute('id',0);
		$node->addAttribute('name', 'Uncategorized');
		$node->ADD_Element('description', 'Uncategorized');
		$node = $obj->ADD_Element('category', '');
		$node->addAttribute('id',1);
		$node->addAttribute('name', 'Music');
		$node->ADD_Element('description', 'Music');
		$node = $obj->ADD_Element('category', '');
		$node->addAttribute('id',2);
		$node->addAttribute('name', 'Videos');
		$node->ADD_Element('description', 'Videos');	
		$obj->asXml( 'content/private/categories.xml' );

		// comments.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<comments autoinc="0">';
		$xml .= '</comments>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$node = $obj->ADD_Element('spam', '');
		$obj->asXml( 'content/private/comments.xml' );

		// post.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<post autoinc="1">';
		$xml .= '</post>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$node = $obj->ADD_Element('sticky', '');
		$obj->asXml( 'content/private/post.xml' );

		// rss.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<rss version="2.0">';
		$xml .= '</rss>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$node = $obj->ADD_Element('channel', '');
		$obj->asXml( 'content/public/rss/rss.xml' );

		// links.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<links autoinc="2">';
		$xml .= '</links>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$node = $obj->ADD_Element('link', '');
		$node->addAttribute('id',0);
		$node->ADD_Element('name', 'Nibbleblog');
		$node->ADD_Element('url', 'http://www.nibbleblog.com');
		$node = $obj->ADD_Element('link', '');
		$node->addAttribute('id',1);
		$node->ADD_Element('name', 'Nibbleblog support');
		$node->ADD_Element('url', 'http://forum.nibbleblog.com');
		$obj->asXml( 'content/private/links.xml' );

		// profiles.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<profiles>';
		$xml .= '</profiles>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$node = $obj->ADD_Element('profile', '');
		$node->addAttribute('id', '0');
		$node->ADD_Element('last_name', 'Mr.');
		$node->ADD_Element('first_name', 'Nibble');
		$node->ADD_Element('email', $_POST['email']);
		$node->ADD_Element('msn', '');
		$node->ADD_Element('aim', '');
		$node->ADD_Element('yahooim', '');
		$node->ADD_Element('gtalk', '');
		$node->ADD_Element('twitter', '');
		$node->ADD_Element('facebook', '');
		$node->ADD_Element('myspace', '');
		$obj->asXml( 'content/private/profiles.xml' );

		// syslog.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<syslog>';
		$xml .= '</syslog>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$obj->ADD_Element('login', '');
		$obj->ADD_Element('block', '');
		$obj->asXml( 'content/private/syslog.xml' );

		// tags.xml
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<tags autoinc="0">';
		$xml .= '</tags>';
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$obj->ADD_Element('linked', '');
		$obj->ADD_Element('list', '');
		$obj->asXml( 'content/private/tags.xml' );

		// Welcome post	
		$xml  = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
		$xml .= '<post>';
		$xml .= '</post>';
		$time_unix = unixstamp();	
		$time = unixstamp_to_date(0, $time_unix);
		$obj = new NBXML($xml, 0, FALSE, '', FALSE);
		$obj->ADD_Element('type', 'simple');
		$obj->ADD_Element('title', $_LANG['WELCOME_TO_NIBBLEBLOG']);
		$obj->ADD_Element('content', $_LANG['WELCOME_POST']);
		$obj->ADD_Element('pub_date', $time_unix);
		$obj->ADD_Element('mod_date', '0');
		$obj->ADD_Element('allow_comments', '1');
		$obj->ADD_Element('visits', '0');
		$obj->asXml( 'content/public/posts/0.0.0.NULL.'.$time['Y'].'.'.$time['m'].'.'.$time['d'].'.'.$time['H'].'.'.$time['i'].'.'.$time['s'].'.xml' );
		
		// shadow.php
		$text = '<?php $_USER[0]["uid"] = "0"; $_USER[0]["user"] = "'.$_POST['username'].'"; $_USER[0]["password"] = "'.md5($_POST['password']).'"; ?>';
		$file = fopen('content/private/shadow.php', 'w');
		fputs($file, $text);
		fclose($file);
		
		// keys.php
		$text = '<?php $_KEYS["post"] = "'.random_text(12).'"; $_KEYS["comment"] = "'.random_text(12).'"; $_KEYS["session"] = "'.random_text(12).'"; $_KEYS["other"] = "'.random_text(12).'"; ?>';
		$file = fopen('content/private/keys.php', 'w');
		fputs($file, $text);
		fclose($file);
	}
	
	$flag_installation = true;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Nibbleblog Installer</title>
<script type="text/javascript" src="admin/js/jquery/jquery.js"></script>
<style type="text/css"> 
<!--

body {
	margin: 0;
	padding: 0;
	font-family: Verdana, Geneva, sans-serif;
	font-size: small;
	color: #333333;
	text-align: left;
	background: #f1f1f1;
}

#head {
	background-color: #444444;
	border-bottom: 1px solid #9D9D9D;
	color: #9c9c9c;
	margin-bottom: 30px;
}

#head_container {
	width: 900px;
	margin: 0px auto;
	padding: 10px;
	background: url('admin/themes/default/img/logo.png') no-repeat left;
	height: 25px;
}

#container { 
	width: 900px;
	margin: 0px auto;
}

#content {
	float:left;
	width: 670px;
	background: #fff;
	padding: 20px;
	border: 1px solid #DDDDDD;
}

#welcome_container {
	font-size: 13px;
}


#status_container {
	margin: 30px auto;
	width: 600px;
	display: none;
}

.status_box {
	border: 1px solid #ccc;
	margin: 5px 0;
	padding: 5px;
}

span.status_title {
	float: left;
	width: 500px;
}

span.status_check {
	clear: both;
}

span.status_open {
	cursor:pointer;
}

#form_container {
	display:none;
}

.title {
	font-size:14px;
	font-style: italic;
	border-bottom: 3px solid #ccc;
	margin: 20px 20px 0px 0;
}

input[type="text"] {
	border: 1px solid #DDDDDD;
	padding: 5px;
	margin: 4px 0;
	width: 400px;
}

.form_title {
	font-weight: bold;
	margin-top: 10px;
}

.border_round_2px {
	-moz-border-radius: 2px;
	-webkit-border-radius: 2px;
	border-radius: 2px;
}

.button_default {
	border: 1px solid #ccc;
	background: #fff;
	padding: 5px 10px;
	font-size: 11px;
	font-weight: bold;
	color: #707070;
}

#expert_mode {
	display: none;
}

.banner_error {
	margin: 10px 0;
	color: #C82222;
	font-size: 13px;
}

.banner_success {
	margin: 10px 0;
	color: #3D8717;
	font-size: 13px;
}

a.banner {
	color: #3D8717;
}

a.lang {
	color: #3D8717;
	margin: 6px;
}

li {
	margin: 6px 0;
}

-->
</style>

</head>
<body>

	<div id="head">
		<div id="head_container">
		</div>
	</div>
	
	<div id="container">

<?php if( !$flag_installation ) { ?>

		<div id="welcome_container">
			<div style="font-size:18px;"><?php echo $_LANG['WELCOME_TO_NIBBLEBLOG'] . ' v'. SYSTEM_VERSION ?></div>
			<div style="margin: 5px 0;"> <?php echo $_LANG['CHOOSE_YOUR_LANGUAGE'] ?>:
			<?php
				foreach( glob('lang/*') as $file )
				{
					echo '<a class="lang" href="install.php?lang='.basename($file, '.php').'">'.ucfirst(basename($file, '.php')).'</a>';
				}
			?>
			</div>
		</div>


		<div class="title"><?php echo $_LANG['STATUS'] ?> (<span class="status_open" id="js_button_status">+</span>)</div>
		<div id="status_container">
			<div class="status_box">
				<span class="status_title"><?php echo $_LANG['PHP_VERSION_GREATER'] ?> 5.2</span>
				<?php if($nbinstall->verify_phpversion()) echo '<span class="status_check" style="color: #4B9D39;">'.$_LANG['PASS'].'</span>'; else { echo '<span class="status_check" style="color: #FF1717;">'.$_LANG['FAIL'].'</span>'; $status = false; } ?>
			</div>
			<div class="status_box">
				<span class="status_title"><?php echo $_LANG['MODULE'] ?> SimpleXML</span>
				<?php if($nbinstall->verify_php_module('SimpleXML')) echo '<span class="status_check" style="color: #4B9D39;">'.$_LANG['PASS'].'</span>'; else { echo '<span class="status_check" style="color: #FF1717;">'.$_LANG['FAIL'].'</span>'; $status = false; } ?>
			</div>
			<div class="status_box">
				<span class="status_title"><?php echo $_LANG['MODULE'] ?> GD</span>
				<?php if($nbinstall->verify_php_module('gd')) echo '<span class="status_check" style="color: #4B9D39;">'.$_LANG['PASS'].'</span>'; else { echo '<span class="status_check" style="color: #FF1717;">'.$_LANG['FAIL'].'</span>'; $status = false; } ?>
			</div>
			<div class="status_box">
				<span class="status_title"><?php echo $_LANG['WRITING_TEST'] ?></span>
				<?php if($nbinstall->verify_write('content/tmp')) echo '<span class="status_check" style="color: #4B9D39;">'.$_LANG['PASS'].'</span>'; else { echo '<span class="status_check" style="color: #FF1717;">'.$_LANG['FAIL'].'</span>'; $status = false; } ?>
			</div>
			<div class="status_box">
				<span class="status_title"><?php echo $_LANG['CONTENT_DIRECTORY_WRITABLE'] ?></span>
				<?php if($nbinstall->verify_perms('content')) echo '<span class="status_check" style="color: #4B9D39;">'.$_LANG['PASS'].'</span>'; else { echo '<span class="status_check" style="color: #FF1717;">'.$_LANG['FAIL'].'</span>'; $status = false; } ?>
			</div>
		</div>


		<div id="form_container">
			<form method="post" >
				<input type="hidden" name="lang" value="<?php if( isset($_GET['lang']) ) echo $_GET['lang']; else echo 'english'; ?>"/>
				<div class="title"><?php echo $_LANG['CONFIGURATION'] ?></div>
				<div class="form_default">
					<div>
						<div class="form_title"><?php echo $_LANG['BLOG_NAME'] ?></div>
						<input type="text" name="name" />
					</div>
					<div>
						<div class="form_title"><?php echo $_LANG['BLOG_DESCRIPTION'] ?></div>
						<input type="text" name="description" />
					</div>
					<div>
						<div class="form_title"><?php echo $_LANG['ADMINISTRATOR'].' '.$_LANG['USERNAME'] ?></div>
						<input type="text" name="username" />
					</div>
					<div>
						<div class="form_title"><?php echo $_LANG['ADMINISTRATOR'].' '.$_LANG['PASSWORD'] ?></div>
						<input type="text" name="password" />
					</div>
					<div>
						<div class="form_title"><?php echo $_LANG['ADMINISTRATOR'].' '.$_LANG['EMAIL'] ?></div>
						<input type="text" name="email" />
					</div>
					<div id="expert_mode">
						<div>
							<div class="form_title"><?php echo $_LANG['BLOG_ADDRESS'] ?></div>
							<input type="text" name="url" value="<?php echo 'http://'.getenv('HTTP_HOST') ?>" />
						</div>
						<div>
							<div class="form_title"><?php echo $_LANG['BLOG_BASE_PATH'] ?></div>
							<input type="text" name="path" value="<?php if( dirname(getenv('REQUEST_URI')) == '/' ) { echo '/'; } else { echo dirname(getenv('REQUEST_URI')).'/'; } ?>"/>
						</div>
					</div>
					<div style="margin: 20px 0 50px 0">
						<input type="button" value="<?php echo $_LANG['INSTALL_NOW'] ?>" id="js_button_install" class="button_default border_round_2px" />
						<input type="button" value="<?php echo $_LANG['EXPERT_MODE'] ?>" id="js_button_expert" status="0" class="button_default border_round_2px" />
					</div>
				</div>
			</form>
		</div>

<?php }else { ?>

		<div class="title">Installation</div>
		<?php if( $flag_error ) { ?>
			<div class="banner_error">
				<?php echo $_LANG['INSTALLATION_FAILED'] ?>
				<ul>
					<li><?php echo $_LANG['PLEASE_TRY_AGAIN'] ?></li>
					<li><?php echo $_LANG['IF_THE_PROBLEM_PERSIST'] ?> <a class="banner" href="http://forum.nibbleblog.com">http://forum.nibbleblog.com</a></li>
				</ul>
			</div>
		<?php }else { ?>
			<div class="banner_success">
				<?php echo $_LANG['INSTALLATION_COMPLETE'] ?>
				<ul>
					<li><?php echo $_LANG['FOR_SECURITY_REASONS_DELETE_THE_FILE'].' install.php' ?></li>
					<li><?php echo $_LANG['BLOG_ADDRESS'] ?>: <a class="banner" href="<?php echo 'http://'.getenv('HTTP_HOST').dirname( getenv('REQUEST_URI') ); ?>"><?php echo 'http://'.getenv('HTTP_HOST').dirname( getenv('REQUEST_URI') ); ?></a></li>
					<li><?php echo $_LANG['MANAGE_YOUR_BLOG'] ?>: <a class="banner" href="<?php echo 'http://'.getenv('HTTP_HOST').dirname( getenv('REQUEST_URI') ).'/admin'; ?>"><?php echo 'http://'.getenv('HTTP_HOST').dirname( getenv('REQUEST_URI') ).'/admin'; ?></a></li>
				</ul>
			</div>
		<?php } ?>

<?php } ?>

	</div>

<script type='text/javascript'>

$(document).ready(function(){

	<?php if($status) echo '$("#form_container").show()'; else echo '$("#status_container").show()'; ?>

	$("#js_button_status").click(
		function()
		{
			$("#status_container").slideToggle();
		}
	);

	$("#js_button_expert").click(
		function()
		{
			if( $(this).attr("status") == 0 )
			{
				$("#expert_mode").slideDown();
				$(this).attr("status","1");
				$(this).attr("value", "<?php echo $_LANG['SIMPLE_MODE'] ?>");
			}
			else
			{
				$("#expert_mode").slideUp();
				$(this).attr("status","0");
				$(this).attr("value", "<?php echo $_LANG['EXPERT_MODE'] ?>");
			}
		}
	);

	$('#js_button_install').click(
		function()
		{
			$('input:text').css("border-color", "#CCCCCC");

			var emptyinputs = $('input:text').filter(function() { return ($.trim( this.value ) == "") });
			emptyinputs.each(function() { $(this).css("border-color", "#FFCB00"); });

			if( emptyinputs.length == 0 )
			{
				$("form").attr("action","");
				$("form").submit();
			}
		}
	);

});

</script>

</body>
</html>
