<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
   
class TAGS_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error
	
/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function TAGS_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";

			$this->file_xml = $file;

			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}

		public function get_autoinc()
		{
			return( (int) $this->obj_xml['autoinc'] );
		}

		private function set_autoinc($value = 0)
		{
			$this->obj_xml['autoinc'] = $value + $this->get_autoinc();
		}

		private function search_idtags($idpost)
		{
			$tmp_array = array();
			$tmp_node = $this->obj_xml->xpath('/tags/linked//id[@idpost="'.$idpost.'"]');

			foreach($tmp_node as $node)
				array_push($tmp_array, (int)$node->attributes()->idtag);

			return($tmp_array);
		}

		private function search_idposts($idtag)
		{
			$tmp_array = array();
			$tmp = $this->obj_xml->xpath('/tags/linked//id[@idtag='.$idtag.']');
			foreach($tmp as $element)
				array_push($tmp_array, (int)$element['idpost']);
			
			return($tmp_array);
		}

		// Retorna el ID del tag
		// Si no existe devuelve -1
		private function get_idtag($tag)
		{
			$tmp_node = $this->obj_xml->xpath('/tags/list/tag[@word="'.$tag.'"]');
			
			if($tmp_node != array() )
				return((int)$tmp_node[0]->attributes()->id);
			else
				return (-1);				
		}

		// retorna TRUE si existe el link
		// retorna FALSE si no existe el link
		private function exist_linked($idpost, $idtag)
		{
			$tmp_node = $this->obj_xml->xpath('/tags/linked/id[@idpost="'.$idpost.'" and @idtag="'.$idtag.'"]');
			
			return( $tmp_node[0] != array() );
		}

		// $tags : lista de tags separados por una coma
		// retorna un array con los tags
		private function recondition($tags)
		{	
			$tags = $this->strip_spaces($tags);
			$tags = strip_tags($tags);
			$tags = $this->strip_quotes($tags);
			
			$explode = explode(',', $tags);

			$tmp_array = array();
			foreach( $explode as $tag )
			{
				if(!empty($tag))
					array_push($tmp_array, $tag);
			}
			return( $tmp_array );
		}		

		private function check_and_add($idpost, $tag)
		{
			if( ($idtag = $this->get_idtag($tag)) == -1 )
			{
				$idtag = $this->get_autoinc();
				
				$new_node = $this->obj_xml->list->ADD_Element('tag','');
				$new_node->addAttribute('id', $idtag);
				$new_node->addAttribute('word', $tag);
				
				$this->set_autoinc(1);
			}
			
			if( !$this->exist_linked($idpost, $idtag) )
			{
				$new_node = $this->obj_xml->linked->ADD_Element('id','');
				$new_node->addAttribute('idpost', $idpost);
				$new_node->addAttribute('idtag', $idtag);
			}
		}

		public function add($idpost, $tags)
		{
			$tmp_array = $this->recondition($tags);
			foreach( $tmp_array as $tag )
				$this->check_and_add($idpost, $tag);
		}

		public function remove_all($idpost)
		{
			$tmp_node = $this->obj_xml->xpath('/tags/linked/id[@idpost="'.$idpost.'"]');
			foreach( $tmp_node as $node )
			{
				$dom = dom_import_simplexml($node);
				$dom->parentNode->removeChild($dom);
			}
		}

		public function get_all_array()
		{
			$tmp_array = array();
			$tags = $this->obj_xml->xpath('/tags/list//tag');
			foreach($tags as $tag)
				array_push( $tmp_array, (string) utf8_decode($tag->attributes()->word) );
			
			return($tmp_array);
		}

		public function get_all()
		{
			return( implode(', ', $this->get_all_array()) );
		}

		public function get_all_array_by_post($idpost)
		{
			$tmp_array = array();
			$idtags = $this->search_idtags($idpost);
			foreach( $idtags as $id )
			{
				$row = $this->obj_xml->xpath('/tags/list//tag[@id='.$id.']');
				array_push( $tmp_array, (string) utf8_decode($row[0]->attributes()->word) );
			}

			return($tmp_array);
		}

		public function get_all_by_post($idpost)
		{
			return( implode(', ', $this->get_all_array_by_post($idpost) ) );
		}
		
} // END Class

?>
