<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/
   
class PROFILES_DBXML extends NBFUNCTIONS {

/*
======================================================================================
	VARIABLES
======================================================================================
*/
		public $file_xml; 			// Contains the link to the blog_config.xml file
		public $obj_xml; 				// Contains the object of the blog_config.xml file
		public $flag_error;			// Error Flag
		public $flag_i18n;			// Menssage Error

/*
======================================================================================
	CONSTRUCTORS
======================================================================================
*/
		function PROFILES_DBXML($file)
		{			
			$this->flag_error = false;
			$this->flag_i18n = "";

			$this->file_xml = $file;

			if (file_exists($this->file_xml))
			{
				$this->obj_xml = new NBXML($this->file_xml, 0, TRUE, '', FALSE);
			}
			else
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_OPENED';
			}
		}

/*
======================================================================================
	METHODS
======================================================================================
*/
		public function flag_error()
		{
			return($this->flag_error);
		}

		public function flag_i18n()
		{
			return($this->flag_i18n);
		}

		public function savetofile()
		{
			if( !($this->obj_xml->asXML($this->file_xml)) )
			{
				$this->flag_error = true;
				$this->flag_i18n = 'FILE_COULDNT_BE_SAVED';
			}
		}

		public function set($ARGS)
		{
			$tmp_node = $this->obj_xml->profile[0];

			$tmp_node->last_name		= utf8_encode($this->html2text($ARGS['last_name']));
			$tmp_node->first_name	= utf8_encode($this->html2text($ARGS['first_name']));
			$tmp_node->email			= utf8_encode($this->html2text($ARGS['email']));
			
			$tmp_node->msn				= utf8_encode($this->html2text($ARGS['msn']));
			$tmp_node->aim				= utf8_encode($this->html2text($ARGS['aim']));
			$tmp_node->yahooim		= utf8_encode($this->html2text($ARGS['yahooim']));
			$tmp_node->gtalk			= utf8_encode($this->html2text($ARGS['gtalk']));

			$tmp_node->twitter		= utf8_encode($this->html2text($ARGS['twitter']));
			$tmp_node->facebook		= utf8_encode($this->html2text($ARGS['facebook']));
			$tmp_node->myspace		= utf8_encode($this->html2text($ARGS['myspace']));
		}
		
		public function get_picture($id, $size = 75)
		{			
			return( file_exists(PATH_PROFILES_PICTURES . $id.'.'.$size.'x'.$size.'.jpg') );
		}
		
		public function get_last_name($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->last_name) );
		}

		public function get_first_name($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->first_name) );
		}

		public function get_email($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->email) );
		}

		public function get_msn($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->msn) );
		}
		
		public function get_aim($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->aim) );
		}

		public function get_yahooim($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->yahooim) );
		}
		
		public function get_gtalk($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->gtalk) );
		}
		
		public function get_twitter($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->twitter) );
		}

		public function get_facebook($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->facebook) );
		}
		
		public function get_myspace($id)
		{
			return( (string) utf8_decode($this->obj_xml->profile[0]->myspace) );
		}

} // END Class
  
?>
