<?php

/* 
 * Nibbleblog -
 * http://www.nibbleblog.com
 * Author Diego Ignacio Gabriel Najar Carrascal

 * All NibbleBlog code is released under the GNU General Public License.
 * See COPYRIGHT.txt and LICENSE.txt.
*/

class NBFUNCTIONS
{

/*
======================================================================================
	ENCRYPT
======================================================================================
*/
	// return string
	public function encrypt($string, $key)
	{
		$string = base64_encode( mcrypt_encrypt( MCRYPT_RIJNDAEL_256, md5($key), $string, MCRYPT_MODE_CBC, md5($key) ) );
		return( $string );
	}
	
	// return string
	public function desencrypt($string, $key)
	{
		$string = rtrim( mcrypt_decrypt( MCRYPT_RIJNDAEL_256, md5($key), base64_decode($string), MCRYPT_MODE_CBC, md5($key) ), "\0" );
		return( $string );
	}

/*
======================================================================================
	NETWORK
======================================================================================
*/
	// return string
	public function get_user_ip()
	{
		if (getenv('HTTP_X_FORWARDED_FOR'))
			$realip = getenv('HTTP_X_FORWARDED_FOR');
		elseif (getenv('HTTP_CLIENT_IP'))
			$realip = getenv('HTTP_CLIENT_IP');
		else
			$realip = getenv('REMOTE_ADDR');

		return($realip);
	}

	public function get_user_agent()
	{
		return( getenv('HTTP_USER_AGENT') );
	}

/*
======================================================================================
	RANDOMS
======================================================================================
*/

function random_text($length)
{
	 $characteres = "1234567890abcdefghijklmnopqrstuvwxyz";
	 for($i=0; $i<$length; $i++)
	 {
		$text .= $characteres{rand(0,35)};
	 }
	 return $text;
}

function random_number($min, $max)
{
	 return( rand($min, $max) );
}

/*
======================================================================================
	VALIDATION
======================================================================================
*/
	// Clean text for URL
	public function clean_url($text)
	{
		$text = str_replace(array("!", "*", "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]"),"",$text);
		$text = str_replace(" ","_",$text);
		
		return($text);
	}

	// Convert html to plain text
	public function html2text($text)
	{
		return(htmlspecialchars($text, ENT_QUOTES, 'utf-8'));
	}

	// Convert plain text to html
	public function text2html($html)
	{
		return(html_entity_decode($html, ENT_QUOTES, 'utf-8'));
	}

	// Clean magic quotes
	public function clean_magic_quotes($ARGS)
	{
		$tmp_array = array();
		foreach($ARGS as $key => $arg)
		{
			$tmp_array[$key] = stripslashes($arg);
		}
		
		return($tmp_array);
	}

	// RETURN
	// TRUE - si contiene el substring
	// FALSE - caso contrario
	public function is_substring($string, $substring)
	{
		return( strpos($string, $substring) !== false );
	}

	// Strip spaces
	public function strip_spaces($string)
	{
		return( str_replace(' ','',$string) );
	}

	// Strip quotes ' and "
	public function strip_quotes($text)
	{
		$text = str_replace('\'', '', $text);
		$text = str_replace('"', '', $text);
		return( $text );
	}

	// RETURN
	// TRUE - is not empty
	// FALSE - is empty
	public function not_empty($string)
	{
		$string = $this->strip_spaces($string);
		return( !empty($string) );
	}

	public function valid_mail($mail)
	{
		return ( filter_var($mail, FILTER_VALIDATE_EMAIL) );
	}

	public function valid_int($int)
	{
		if($int === 0)
			return( true );
		elseif (filter_var($int, FILTER_VALIDATE_INT) === false )
			return( false );
		else
			return( true );
	}
	
/*
======================================================================================
	FILES
======================================================================================
*/

// Devuelve un arreglo con el listado de archivos
// $path con una barra al final, ej: /home/
// $ext : xml
// $file_expression : *.0.*.*.*.*.*.*.*.*
// $flag_dir : si quiero listar directorios
// $sort_asc_numeric : ordeno ascedente numerico
// $sort_desc_numeric : ordeno descendente numerico
function ls($path, $file_expression = NULL, $ext, $flag_dir = false, $sort_asc_numeric = false, $sort_desc_numeric = false)
{
	if($flag_dir)
	{
		$files = glob($path . $file_expression, GLOB_ONLYDIR);
	}
	else
	{
		$files = glob($path . $file_expression . '.' . $ext);
	}

	foreach($files as $key=>$file)
	{
		$files[$key] = basename($file);
	}
	
	// Sort
	if($sort_asc_numeric)
	{
		sort($files, SORT_NUMERIC);
	}
	elseif($sort_desc_numeric)
	{
		rsort($files, SORT_NUMERIC);
	}

	return $files;
}

/*
======================================================================================
	PLUGINS
======================================================================================
*/

function plugin_get_info($plugin, $lang)
{
	// Language for plugin
	if( !@include( PATH_PLUGINS . $plugin . '/lang/' . $lang . '.php' ) )
		require( PATH_PLUGINS . $plugin . '/lang/english.php' );
			
	include(PATH_PLUGINS.$plugin.'/'.$plugin.'.php');

	$tmp_array = array();
	$tmp_array['name'] = constant( 'PLUGIN_'.strtoupper($plugin).'_NAME' );
	$tmp_array['description'] = constant( 'PLUGIN_'.strtoupper($plugin).'_DESCRIPTION' );
	$tmp_array['version'] = constant( 'PLUGIN_'.strtoupper($plugin).'_VERSION' );
	$tmp_array['release_date'] = constant( 'PLUGIN_'.strtoupper($plugin).'_RELEASE_DATE' );
	$tmp_array['author'] = constant( 'PLUGIN_'.strtoupper($plugin).'_AUTHOR' );
	$tmp_array['author_mail'] = constant( 'PLUGIN_'.strtoupper($plugin).'_AUTHOR_MAIL' );
	$tmp_array['author_web'] = constant( 'PLUGIN_'.strtoupper($plugin).'_AUTHOR_WEB' );
	$tmp_array['license'] = constant( 'PLUGIN_'.strtoupper($plugin).'_LICENSE' );
	return $tmp_array;
}

/*
======================================================================================
	RSS
======================================================================================
*/

function generate_rss($dbxml_config, $dbxml_post, $dbxml_rss)
{
	$pubdate = $this->unixstamp_to_date($dbxml_config->get_timezone(), $this->unixstamp());
	$dbxml_rss->create_body($dbxml_config->get_name(), $dbxml_config->get_url(), $dbxml_config->get_description(), $pubdate['r']);
	
	$posts = $dbxml_post->get_list_by_page(0, $dbxml_config->get_items_rss());
	foreach($posts as $post)
	{	
		$pubdate = $this->unixstamp_to_date($dbxml_config->get_timezone(), $post['pub_date']);
		$dbxml_rss->add_item($post['title'], $dbxml_config->get_url() . '/post.php?idpost=' . $post['idpost'], $post['content_part1'], $pubdate['r']);
	}

	$dbxml_rss->savetofile();
}

/*
======================================================================================
	AJAX
======================================================================================
*/

public function ajax_header($tmp)
{
	$xml = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>';
	$xml .= '<ajax>';
	$xml .= $tmp;
	$xml .= '</ajax>';
	return( $xml );
}

/*
======================================================================================
	TEXT
======================================================================================
*/

public function cut_text($text, $maxlength)
{
	return( substr($text,0,strrpos(substr($text,0,$maxlength)," ")) );
}

/*
======================================================================================
	DATE
======================================================================================
*/

	// Convierte unixstamp a date
	// Devuelve un arreglo y en cada posicion devuelve un dato de la fecha
	// Para ver los datos que devuelve mirar la tabla de la funcion date de php
	// http://php.net/manual/en/function.date.php
	//
	// Parametros
	// $gmt_user -> Zona horaria en la que se encuentra el usuario
	// $time_unix -> Fecha en formato Unix
	public function unixstamp_to_date($gmt_user, $time_unix)
	{
		$zone = 3600 * $gmt_user;
	
		$date = array();
	
		$date['s'] = date('s', $time_unix + $zone);
		$date['i'] = date('i', $time_unix + $zone);
		$date['h'] = date('h', $time_unix + $zone);
		$date['H'] = date('H', $time_unix + $zone);
		$date['d'] = date('d', $time_unix + $zone);
		$date['N'] = date('N', $time_unix + $zone);
		$date['n'] = date('n', $time_unix + $zone);
		$date['m'] = date('m', $time_unix + $zone);
		$date['Y'] = date('Y', $time_unix + $zone);
		$date['y'] = date('y', $time_unix + $zone);
		$date['a'] = date('a', $time_unix + $zone);
		$date['r'] = date('r', $time_unix + $zone);
		
		return( $date );
	}

	// Devuelve la fecha en formato Unixstamp y esta corrida en GMT = 0
	public function unixstamp()
	{
		return( time() - date('Z') );
	}

	public function time_ago($tm, $rcs = 0)
	{
		$cur_tm = time() - date('Z');
		$dif = $cur_tm-$tm;
		$pds = array('SECOND/S','MINUTE/S','HOUR/S','DAY/S','WEEK/S','MONTH/S','YEAR/S','DECADE/S');
		$lngh = array(1,60,3600,86400,604800,2630880,31570560,315705600);
		for($v = sizeof($lngh)-1; ($v >= 0)&&(($no = $dif/$lngh[$v])<=1); $v--); if($v < 0) $v = 0; $_tm = $cur_tm-($dif%$lngh[$v]);
		$no = floor($no);
		$x['number'] = $no;
		$x['i18n']= $pds[$v];
		return($x);
	}
}


class LOGIN extends NBFUNCTIONS
{
	function LOGIN()
	{
		session_start();
	}

	public function set_token()
	{
		// expire 1hour
		setcookie('token', $this->random_text(10), time()+3600, '/');
	}

	public function get_token()
	{
		return( $_COOKIE['token'] );
	}

	public function valid_token($token)
	{
		return( (strcmp($token, $this->get_token()) == 0) && isset($_COOKIE['token']) );
	}

	private function get_key()
	{
		return( md5( $this->get_user_agent() . $this->get_user_ip() ) );
	}

	public function verify_login($username, $password)
	{
		require( FILE_SHADOW );

		if( $username === $_USER[0]['user'] )
		{
			if( md5( $password ) === $_USER[0]['password'] )
			{
				$_SESSION['nb_iduser']	= 0;
				$_SESSION['nb_date']		= $this->unixstamp();
				$_SESSION['nb_user']		= $username;
				$_SESSION['nb_key']		= $this->get_key();

				return( true );
			}
		}
		
		return( false );
	}

	public function get_iduser()
	{
		return( $_SESSION['nb_iduser'] );
	}

	public function is_login()
	{
		if( isset( $_SESSION['nb_key'] ) && isset( $_SESSION['nb_user'] ) && isset( $_SESSION['nb_date'] ) )
		{
			if( !(strcmp($_SESSION['nb_key'], $this->get_key() ) != 0) )
				return( true );
		}
		
		return( false );
	}
	
	public function logout()
	{
		$_SESSION = array();
		unset($_SESSION['nb_date']);
		unset($_SESSION['nb_user']);
		unset($_SESSION['nb_key']);
		session_destroy();
	}
}

$login = new LOGIN();

?>
