<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
	/*
	=============================
		FORM VARIABLES
	=============================
	*/	
	$_FORM['name']				= (string) trim( $_POST['name'] );
	$_FORM['description']	= (string) trim( $_POST['description'] );
	$_FORM['language']		= (string) $_POST['language'];
	$_FORM['footer']			= (string) trim( $_POST['footer'] );
	$_FORM['about']			= (string) $_POST['about'];
	$_FORM['template']		= (string) $_POST['template'];
	$_FORM['path']				= (string) $_POST['path'];
	$_FORM['url']				= (string) $_POST['url'];
	$_FORM['timezone']		= (int) $_POST['timezone'];
	$_FORM['items_page']		= (int) $_POST['items_page'];
	$_FORM['items_rss']		= (int) $_POST['items_rss'];
	
	$_FORM['rewriteurl'] 			= ($_POST['rewriteurl'] == true) ? 1:0;
	$_FORM['mail_notification']	= ($_POST['mail_notification'] == true) ? 1:0;

	/*
	=============================
		EXECUTE
	=============================
	*/
	if( $nbfunctions->not_empty($_FORM['name']) && $nbfunctions->not_empty($_FORM['description']) && $nbfunctions->not_empty($_FORM['url']) )
	{
		$dbxml_config->set($_FORM);
		
		// Commit :D
		if( !$dbxml_config->flag_error() )
		{
			$dbxml_config->savetofile();
			
			if( !$dbxml_config->flag_error() )
			{
				$_FLAG['msj'] = $_LANG['THE_CHANGES_SAVED_SUCCESS'];
				$_FLAG['success'] = true;
			}
		}
	}
	
	// Check for errors
	if( $dbxml_config->flag_error() )
	{
		$_FLAG['msj'] = $_LANG[ $dbxml_config->flag_i18n() ];
		$_FLAG['error'] = true;
	}
}

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error']);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['SETTINGS'].'</div>';

	echo '<form method="post">';
	
	echo '
			<input type="hidden" id="exe" name="exe" />
			<input type="hidden" name="token" value="'.$login->get_token().'" />
	';

	// GENERAL SETTINGS
	echo '
			<fieldset>
				<legend>'.$_LANG['GENERAL_SETTINGS'].'</legend>

				<div class="container_form_top_options">
					<input type="submit" class="button_tooltip border_round_2px" value="'.$_LANG['SAVE'].'" /> <input type="button" class="button_tooltip border_round_2px js_button_back" value="'.$_LANG['BACK_TO_DASHBOARD'].'" />
				</div>
						
				<div class="container_form_section">
					<label for="js_name">'.$_LANG['BLOG_NAME'].'</label>
					<input type="text" name="name" id="js_name" value="'.$dbxml_config->get_name().'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['BLOGS_NAME'].'.</div>
				</div>
						
				<div class="container_form_section">
					<label for="js_description">'.$_LANG['BLOG_DESCRIPTION'].'</label>
					<input type="text" name="description" id="js_description" value="'.$dbxml_config->get_description().'" class="textbox_big"/>
					<div class="container_form_help">'.$_LANG['SHORT_DESCRIPTION_OF_THE_BLOG'].'.</div>
				</div>

				<div class="container_form_section">
					<label for="js_about">'.$_LANG['ABOUT_YOUR_BLOG'].'</label>
					<textarea name="about" id="js_about" class="big_medium">'.$dbxml_config->get_about().'</textarea>
					<div class="container_form_help">'.$_LANG['DESCRIPTION_OF_THE_BLOG_OR_USER_INFORMATION'].'.</div>
				</div>
						
				<div class="container_form_section">
					<label for="js_footer">'.$_LANG['FOOTER_TEXT'].'</label>
					<input type="text" name="footer" id="js_footer" value="'.$dbxml_config->get_footer().'" class="textbox_big"/>
					<div class="container_form_help">'.$_LANG['FOOT_PAGE_YOU_CAN_TYPE_THE_COPYRIGHT_INFORMATION'].'.</div>
				</div>
						
			</fieldset>
	';


	// TECHNICAL SETTINGS
	echo '
			<fieldset>
				<legend>'.$_LANG['TECHNICAL_SETTINGS'].'</legend>
				
				<div class="container_form_top_options">
					<input type="submit" class="button_tooltip border_round_2px" value="'.$_LANG['SAVE'].'" /> <input type="button" class="button_tooltip border_round_2px js_button_back" value="'.$_LANG['BACK_TO_DASHBOARD'].'" />
				</div>
						
				<div class="container_form_section">
					<label for="js_language">'.$_LANG['LANGUAGE'].'</label>
					<select name="language" id="js_language" class="textbox_xsmall">
	';
					$files = $nbfunctions->ls(PATH_LANG, '*', 'php', false, false, false);
			
					foreach($files as $file)
					{
						$file = basename($file, '.php');
						$dbxml_config->get_language()==$file? $selected_flag ='selected="selected"' : $selected_flag ='';
						echo '<option value="'.$file.'" '.$selected_flag.'>'.ucwords($file).'</option>';
					}
	echo '
					</select>
					<div class="container_form_help">'.$_LANG['CHANGE_BLOGS_LANGUAGE_TO_ADAPT_TO_YOUR_VISITORS'].'.</div>
				</div>

				<div class="container_form_section">
					<label for="js_timezone">'.$_LANG['TIMEZONE'].'</label>
					<select name="timezone" id="js_timezone" class="textbox_xsmall">
	';
					for($i=-12; $i<1; $i++)
					{
						$dbxml_config->get_timezone()==$i? $selected_flag ='selected="selected"' : $selected_flag ='';
						echo '<option value="'.$i.'" '.$selected_flag.'>UTC '.$i.'</option>';
					}
				
					for($i=1; $i<13; $i++)
					{
						$dbxml_config->get_timezone()==$i? $selected_flag ='selected="selected"' : $selected_flag ='';
						echo '<option value="'.$i.'" '.$selected_flag.'>UTC +'.$i.'</option>';
					}					
	echo '
					</select>
					<div class="container_form_help">'.$_LANG['SELECT_A_TIME_ZONE_FOR_A_CORRECT_DATE_VISUALIZATION'].'.</div>
				</div>

				<div class="container_form_section">
					<label for="js_url">'.$_LANG['BLOG_ADDRESS'].' ('.$_LANG['URL'].')</label>
					<input type="text" name="url" id="js_url" value="'.$dbxml_config->get_url().'" class="textbox_big"/>
					<div class="container_form_help">'.$_LANG['ABSOLUT_URL_ADDRESS_OF_YOUR_BLOG'].' ('.$_LANG['IF_YOU_DONT_KNOW_WHAT_YOU_ARE_DOING_LEAVE_THIS_FIELD'].').</div>
				</div>

				<div class="container_form_section">
					<label for="js_path">'.$_LANG['BLOG_BASE_PATH'].'</label>
					<input type="text" name="path" id="js_path" value="'.$dbxml_config->get_path().'" class="textbox_big"/>
					<div class="container_form_help">'.$_LANG['ABSOLUT_ADDRESS_THAT_CONTAINS_THE_BLOGS_FILE_SYSTEM'].' ('.$_LANG['IF_YOU_DONT_KNOW_WHAT_YOU_ARE_DOING_LEAVE_THIS_FIELD'].').</div>
				</div>
						
				<div class="container_form_section">
					<label for="js_items_page">'.$_LANG['POSTS_PER_PAGE'].'</label>
					<select name="items_page" id="js_items_page" class="textbox_xsmall">
	';
					for($i=3; $i<16; $i++)
					{
						$dbxml_config->get_items_page()==$i? $selected_flag ='selected="selected"' : $selected_flag ='';
						echo '<option value="'.$i.'" '.$selected_flag.'>'.$i.'</option>';
					}
	echo '
					</select>
					<div class="container_form_help">'.$_LANG['AMOUNT_OF_POSTS_THAT_YOU_WISH_TO_SEE_PER_PAGE'].'.</div>
				</div>
			
				<div class="container_form_section">
					<label for="js_items_rss">'.$_LANG['RSS_ITEMS'].'</label>
					<select name="items_rss" id="js_items_rss" class="textbox_xsmall">
	';
					for($i=3; $i<12; $i++)
					{
						$dbxml_config->get_items_rss()==$i? $selected_flag ='selected="selected"' : $selected_flag ='';
						echo '<option value="'.$i.'" '.$selected_flag.'>'.$i.'</option>';
					}
	echo '
					</select>
					<div class="container_form_help">'.$_LANG['AMOUNT_OF_POSTS_THAT_YOU_WISH_TO_SEE_ON_RSS'].'.</div>
				</div>

			</fieldset>
	';


	// PERMALINK
	echo '
			<fieldset>
				<legend>'.$_LANG['PERMALINK'].'</legend>
				
				<div class="container_form_top_options">
					<input type="submit" class="button_tooltip border_round_2px" value="'.$_LANG['SAVE'].'" /> <input type="button" class="button_tooltip border_round_2px js_button_back" value="'.$_LANG['BACK_TO_DASHBOARD'].'" />
				</div>
					
				<div class="container_form_section">
					<div class="container_form_title_float">'.$_LANG['ENABLE_FRIENDLY_URLS'].'</div>
	';
					$dbxml_config->get_rewriteurl()==1? $checked_flag ='checked' : $checked_flag ='';
					echo '<input type="checkbox" name="rewriteurl" id="js_rewriteurl" value="true" '.$checked_flag.' />';
	echo '
				</div>

				<div class="container_form_section">
					<div class="container_form_help">'.$_LANG['COPY_THIS_CONTENT_ON_THE_FILE'].' ".htaccess"</div>
					<textarea class="big_small">Options +FollowSymlinks
Options -Indexes
RewriteEngine on
RewriteBase '.$dbxml_config->get_path().'
RewriteRule ^post/([0-9]+)/([^/]+).html$ post.php?idpost=$1 [L]
RewriteRule ^category/([^/]+)/$ index.php?page=0&view=category&cat=$1 [L]
RewriteRule ^archives/([0-9]+)/([0-9]+)/$ index.php?page=0&view=archives&y=$1&m=$2 [L]
RewriteRule ^tag/([^/]+)/$ index.php?page=0&view=tag&tag=$1 [L]</textarea>
					<div class="container_form_help">'.$_LANG['THE_FILE_MUST_BE_ON_THE_ROOT_OF_YOUR_DOMAIN'].' ('.$_LANG['IF_YOU_DONT_KNOW_WHAT_YOU_ARE_DOING_LEAVE_THIS_FIELD'].').</div>
				</div>

			</fieldset>
	';
	
	
	// NOTIFICATIONS
	echo '
			<fieldset>
				<legend>'.$_LANG['NOTIFICATIONS'].'</legend>
				
				<div class="container_form_top_options">
					<input type="button" class="button_tooltip border_round_2px js_button_test" value="'.$_LANG['TEST'].'" /> <input type="submit" class="button_tooltip border_round_2px" value="'.$_LANG['SAVE'].'" /> <input type="button" class="button_tooltip border_round_2px js_button_back" value="'.$_LANG['BACK_TO_DASHBOARD'].'" />
				</div>

				<div class="container_form_section">
					<div class="container_form_title_float">'.$_LANG['EMAIL_NOTIFICATION_COMMENTS'].'</div>
	';
					$dbxml_config->get_mail_notification()==1? $checked_flag ='checked' : $checked_flag ='' ;
					echo '<input type="checkbox" name="mail_notification" id="js_mail_notification" value="true" '.$checked_flag.' />';
	echo '
					<div class="container_form_help">'.$_LANG['SELECT_THIS_OPTION_IF_YOU_WISH_TO_RECEIVE_AN_EMAIL'].'.</div>
				</div>
				
			</fieldset>
	';
	

	// APPEARANCE
	echo '
			<fieldset>
				<legend>'.$_LANG['APPEARANCE'].'</legend>
					
				<div class="container_form_top_options">
					<input type="submit" class="button_tooltip border_round_2px" value="'.$_LANG['SAVE'].'" /> <input type="button" class="button_tooltip border_round_2px js_button_back" value="'.$_LANG['BACK_TO_DASHBOARD'].'" />
				</div>
						
				<div class="container_form_section">
					<div class="settings_theme_screenshot"><img id="js_screenshot" src="'.PATH_TEMPLATES.$dbxml_config->get_template().'/screenshot.png" alt="screenshot" /></div>
				
					<label for="js_template">'.$_LANG['TEMPLATE'].'</label>
					<select name="template" id="js_template" class="textbox_xsmall">
	';								
					$files = $nbfunctions->ls(PATH_TEMPLATES, '*', '', true, false, false);

					foreach($files as $file)
					{
						$dbxml_config->get_template()==$file? $selected_flag ='selected="selected"' : $selected_flag ='';
						echo '<option value="'.$file.'" '.$selected_flag.'>'.ucwords($file).'</option>';
					}
	echo '
					</select>
					<div class="container_form_help">'.$_LANG['CHANGE_YOUR_BLOGS_STYLE_AND_COLORS'].'.</div>
				</div>
				
			</fieldset>
	';


	// BUTTONS
	echo '
			<div class="container_form_buttons">
				<input type="submit" value="'.$_LANG['SAVE'].'"				class="border_round_3px button_default" />
				<input type="button" value="'.$_LANG['CANCEL'].'"			class="border_round_3px button_cancel js_button_back" />
			</div>
	';

	echo '</form>';

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">

?>

<script type='text/javascript'>

/*
=======================================================
	JAVASCRIPT : VARS
=======================================================
*/

var token = "<?php echo $login->get_token() ?>";

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/
			
$(document).ready(function() {

	$("form").submit(
		function()
		{
			var emptyinputs = $("#js_url, #js_path").filter(function() { return ($.trim( this.value ) == "") });
			emptyinputs.each(function() { $(this).css("border-color", "#FFCB00"); $(this).focus(); });
			
			if( emptyinputs.length == 0 )
			{
				return true;
			}
			
			return false;
		}
	);

	// Event - Click - Button admin panel
	$(".js_button_back").click(
		function()
		{
			window.location = "./index.php";
		}
	);

	// Event - Click - Button admin panel
	$(".js_button_test").click(
		function()
		{
			var subject = "<?php echo $_LANG['TESTING_MAIL_SERVER']; ?>";
			
			$.post("ajax/email_send.php", {token:token, subject: subject, message: subject},
			function(xml)
			{
				if( $(xml).find("success").text() == "1" )
				{
					alert("<?php echo $_LANG['THE_EMAIL_HAS_BEEN_SENT_SUCCESSFULLY']; ?>");
				}
				else
				{
					alert("<?php echo $_LANG['EMAIL_COULD_NOT_BE_SENT']; ?>");
				}
			});
		}
	);

	// Event - Change - Select themes
	$('#js_template').change(
		function()
		{
			$("#js_screenshot").attr("src", "<?php echo PATH_TEMPLATES ?>" + $(this).val() + "/screenshot.png");
			return false;
		}
	);
	
});

</script>
