<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
	/*
	=============================
		FORM VARIABLES
	=============================
	*/	
	$_FORM['iduser']		= (int) 0;
	$_FORM['last_name']	= (string) trim( $_POST['last_name'] );
	$_FORM['first_name']	= (string) trim( $_POST['first_name'] );
	$_FORM['email']		= (string) trim( $_POST['email'] );
	$_FORM['msn']			= (string) $_POST['msn'];
	$_FORM['aim']			= (string) $_POST['aim'];
	$_FORM['yahooim']		= (string) $_POST['yahooim'];
	$_FORM['gtalk']		= (string) $_POST['gtalk'];
	$_FORM['twitter']		= (string) $_POST['twitter'];
	$_FORM['facebook']	= (string) $_POST['facebook'];
	$_FORM['myspace']		= (string) $_POST['myspace'];
	
	/*
	=============================
		EXECUTE
	=============================
	*/
	$dbxml_profiles->set($_FORM);
	
	if( !$dbxml_profiles->flag_error() )
	{
		$dbxml_profiles->savetofile();
		
		if( !$dbxml_profiles->flag_error() )
		{
			$_FLAG['msj'] = $_LANG['THE_CHANGES_SAVED_SUCCESS'];
			$_FLAG['success'] = true;
		}
	}
	
	// Check for errors
	if( $dbxml_profiles->flag_error() )
	{
		$_FLAG['msj'] = $_LANG[ $dbxml_profiles->flag_i18n() ];
		$_FLAG['error'] = true;
	}
}

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error']);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['CONTACT_INFO'].'</div>';

	echo '<form method="post">';
	
	echo '
			<input type="hidden" id="exe" name="exe" />
			<input type="hidden" name="token" value="'.$login->get_token().'" />
	';


	// LAST NAME & FIRST NAME
	echo '			
			<fieldset>
				<legend>'.$_LANG['LAST_NAME'].' & '.$_LANG['FIRST_NAME'].'</legend>
				
				<div class="container_form_top_options">
					<span class="button_tooltip border_round_2px js_button_savenow" >'.$_LANG['SAVE'].'</span> <span class="button_tooltip border_round_2px js_button_adminpanel">'.$_LANG['BACK_TO_DASHBOARD'].'</span>
				</div>

				<div class="container_form_section">
					<label for="js_last_name">'.$_LANG['LAST_NAME'].'</label>
					<input type="text" name="last_name" id="js_last_name" value="'.$dbxml_profiles->get_last_name(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['ADMINISTRATORS_SURNAMES'].'.</div>
				</div>

				<div class="container_form_section">
					<label for="js_first_name">'.$_LANG['FIRST_NAME'].'</label>
					<input type="text" name="first_name" id="js_first_name" value="'.$dbxml_profiles->get_first_name(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['ADMINISTRATORS_NAMES'].'.</div>
				</div>

				<div class="container_form_section">
					<label for="js_email">'.$_LANG['EMAIL'].'</label>
					<input type="text" name="email" id="js_email" value="'.$dbxml_profiles->get_email(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['YOUR_EMAIL'].', '.$_LANG['DONT_LEAVE_THIS_EMPTY'].'.</div>
				</div>

			</fieldset>
	';


	// IM
	echo '
			<fieldset>
				<legend>'.$_LANG['IM'].'</legend>
				
				<div class="container_form_top_options">
					<span class="button_tooltip border_round_2px js_button_savenow" >'.$_LANG['SAVE'].'</span> <span class="button_tooltip border_round_2px js_button_adminpanel">'.$_LANG['BACK_TO_DASHBOARD'].'</span>
				</div>
							
				<div class="container_form_section">
					<label for="js_first_name">MSN</label>
					<input type="text" name="msn" id="js_msn" value="'.$dbxml_profiles->get_msn(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['INSTANT_MESSAGING'].' Live Mensangger.</div>
				</div>

				<div class="container_form_section">
					<label for="js_aim">AIM</label>
					<input type="text" name="aim" id="js_aim" value="'.$dbxml_profiles->get_aim(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['INSTANT_MESSAGING'].' AIM.</div>
				</div>

				<div class="container_form_section">
					<label for="js_yahooim">YAHOO IM</label>
					<input type="text" name="yahooim" id="js_yahooim" value="'.$dbxml_profiles->get_yahooim(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['INSTANT_MESSAGING'].' YahooIM.</div>
				</div>
				
				<div class="container_form_section">
					<label for="js_gtalk">Google Talk</label>
					<input type="text" name="gtalk" id="js_gtalk" value="'.$dbxml_profiles->get_gtalk(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['INSTANT_MESSAGING'].' Google Talk.</div>
				</div>
																
			</fieldset>
	';


	// SOCIAL NETWORKS
	echo '
			<fieldset>
				<legend>'.$_LANG['SOCIAL_NETWORKS'].'</legend>
				
				<div class="container_form_top_options">
					<span class="button_tooltip border_round_2px js_button_savenow" >'.$_LANG['SAVE'].'</span> <span class="button_tooltip border_round_2px js_button_adminpanel">'.$_LANG['BACK_TO_DASHBOARD'].'</span>
				</div>
				
				<div class="container_form_section">
					<label for="js_twitter">Twitter</label>
					<input type="text" name="twitter" id="js_twitter" value="'.$dbxml_profiles->get_twitter(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['URL_ADDRESS_OF_YOUR_PROFILE_ON'].' Twitter.</div>
				</div>
			
				<div class="container_form_section">
					<label for="js_facebook">Facebook</label>
					<input type="text" name="facebook" id="js_facebook" value="'.$dbxml_profiles->get_facebook(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['URL_ADDRESS_OF_YOUR_PROFILE_ON'].' Facebook.</div>
				</div>

				<div class="container_form_section">
					<label for="js_myspace">MySpace</label>
					<input type="text" name="myspace" id="js_myspace" value="'.$dbxml_profiles->get_myspace(0).'" class="textbox_big" />
					<div class="container_form_help">'.$_LANG['URL_ADDRESS_OF_YOUR_PROFILE_ON'].' Myspace.</div>
				</div>

			</fieldset>
	';
	
	// BUTTONS
	echo '
			<div class="container_form_buttons">
				<input type="button" value="'.$_LANG['SAVE'].'"				class="border_round_3px button_default"	id="js_button_save" />
				<input type="button" value="'.$_LANG['CANCEL'].'"			class="border_round_3px button_cancel"		id="js_button_cancel" />
			</div>
	';

	echo '</form>';

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">

?>


<script type='text/javascript'>

/*
=======================================================
	JAVASCRIPT : FUNCTIONS
=======================================================
*/
function submit_form()
{		
	$("#exe").attr("value","save");
	$("form").attr("action","");
	$("form").submit();
	
	return false;
}

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/
			
$(document).ready(function() {

	// Event - Click - Button save
	$("#js_button_save, .js_button_savenow").click(
		function()
		{		
			submit_form();
		}
	);
	
	// Event - Click - Button admin panel
	$(".js_button_adminpanel, #js_button_cancel").click(
		function()
		{
			window.location = "./index.php";
		}
	);
		
});

</script>
