<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
	if( $_URL['exe'] != 'save' )
		exit();
		
	unset($_POST['exe']);
	unset($_POST['token']);
	
	// Regeneramos la lista de plugins
	$dbxml_config->plugins_bigban();
	
	// Levantamos los datos enviados por POST
	foreach($_POST as $plugin)
	{
		$dbxml_config->plugins_add($plugin);
	}

	// Commit :D
	if( !$dbxml_config->flag_error() )
	{
		$dbxml_config->savetofile();
		
		if( !$dbxml_config->flag_error() )
		{
			$_FLAG['msj'] = $_LANG['THE_CHANGES_SAVED_SUCCESS'];
			$_FLAG['success'] = true;
		}
	}
	
	// Check for errors
	if( $dbxml_config->flag_error() )
	{
		$_FLAG['msj'] = $_LANG[ $dbxml_config->flag_i18n() ];
		$_FLAG['error'] = true;
	}
}

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error']);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['MANAGE_PLUGINS'].'</div>';

	echo '<form method="post" id="js_form">';
	
	echo '
			<input type="hidden" id="exe" name="exe" />
			<input type="hidden" name="token" value="'.$login->get_token().'" />
	';

	// Lista de plugins
	$plugin_list = $nbfunctions->ls(PATH_PLUGINS, '*', '', true, false, false);
	
	// Lista de plugins habilitados
	$plugins_enabled = $dbxml_config->plugins_get_all();

	// Lista de plugins deshabilitados
	$plugins_disabled = array_diff($plugin_list, $plugins_enabled);


	// ENABLED PLUGINS
	$html->div_tip($_LANG['ENABLED_PLUGINS'].' ('.$_LANG['DRAG_AND_DROP'].')', '#e4f5fd', '1px solid #afdbee', '#6d8894');

	echo '<div id="plugins_enabled_container">';
		foreach( $plugins_enabled as $plugin )
		{
			$plugin_info = $nbfunctions->plugin_get_info($plugin, $dbxml_config->get_language());
			
			echo '
				<div class="plugins_box_container" id="'.$plugin.'">
					<div class="plugins_box_name">'.$plugin_info['name'].'</div>
					<div class="plugins_box_description">'.$plugin_info['description'].'</div>
					<div class="plugins_box_info">'.$_LANG['VERSION'].': '.$plugin_info['version'].' | '.$_LANG['AUTHOR'].': '.$plugin_info['author'].' | '.$_LANG['LICENSE'].': '.$plugin_info['license'].'</div>
				</div>
			';
		}
	echo '</div>';


	// DISABLED PLUGINS
	$html->div_tip($_LANG['DISABLED_PLUGINS'].' ('.$_LANG['DRAG_AND_DROP'].')');

	echo '<div id="plugins_disabled_container">';
		foreach( $plugins_disabled as $plugin )
		{
			$plugin_info = $nbfunctions->plugin_get_info($plugin, $dbxml_config->get_language());
			
			echo '
				<div class="plugins_box_container" id="'.$plugin.'">
					<div class="plugins_box_name">'.$plugin_info['name'].'</div>
					<div class="plugins_box_description">'.$plugin_info['description'].'</div>
					<div class="plugins_box_info">'.$_LANG['VERSION'].': '.$plugin_info['version'].' | '.$_LANG['AUTHOR'].': '.$plugin_info['author'].' | '.$_LANG['LICENSE'].': '.$plugin_info['license'].'</div>
				</div>
			';
		}
	echo '</div>';


	// BUTTONS
	echo '
			<div class="container_form_buttons">
				<input type="button" value="'.$_LANG['SAVE'].'"				class="border_round_3px button_default"	id="js_button_save" />
				<input type="button" value="'.$_LANG['CANCEL'].'"			class="border_round_3px button_cancel"		id="js_button_cancel" />
			</div>
	';

	echo '</form>';

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">
?>

<script type="text/javascript" src="<?php echo FILE_JS_JQUERYUI ?>"></script>
<script type='text/javascript'>

/*
=======================================================
	JAVASCRIPT : Plugin for UI jQuery
=======================================================
*/
	// Plugin para manejar los divs con el mouse
	// utiliza la clase CSS plugin_box_position para ver donde cae
	$(function() {
		$("#plugins_enabled_container").sortable({
			placeholder: 'plugins_box_container_draged',
			connectWith: 'div'
		});

		$("#plugins_disabled_container").sortable({
			placeholder: 'plugins_box_container_draged',
			connectWith: 'div'
		});
		
		$("#plugins_enabled_container").disableSelection();
		$("#plugins_disabled_container").disableSelection();
		
	});

/*
=======================================================
	JAVASCRIPT : FUNCTIONS
=======================================================
*/

// Save categories
function submit_form()
{
	var tmp_array = $("#plugins_enabled_container").sortable("toArray");

	$.each( $(tmp_array), function(index, value)
	{
		$("#js_form").append("<input type='hidden' name='"+value+"' value='"+value+"' >");
	});

	$("#exe").attr("value","save");
	$("form").attr("action","");
	$("form").submit();
	
	return false;
}

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/

$(document).ready(function(){

	// Event - Click - Button save
	$("#js_button_save").click(
		function()
		{
			submit_form();
		}
	);
	
	// Event - Click - Button cancel
	$("#js_button_cancel").click(
		function()
		{
			window.location = "./index.php";
		}
	);

});
</script>
