<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

if( $_SERVER['REQUEST_METHOD'] == 'POST' )
{
	if( $_URL['exe'] === 'save' )
	{
		foreach( $_POST as $post_element)
		{		
			$data = explode(',', $post_element);
			
			if( $data[1] === 'static' )
			{
				// Name not empty
				if($nbfunctions->not_empty($data[2]))
					$dbxml_links->set($data[0], $data[2], $data[3]);
			}
			elseif( $data[1] === 'dynamic' )
			{
				// Name not empty
				if($nbfunctions->not_empty($data[2]))
					$dbxml_links->add($data[2], $data[3]);
			}
		}
	}
	elseif( $_URL['exe'] === 'delete' )
	{
		$dbxml_links->delete( $_GET['idcat'] );
	}
	
	// Commit :D
	if( !$dbxml_links->flag_error() )
	{
		$dbxml_links->savetofile();
		
		if( !$dbxml_links->flag_error() )
		{
			$_FLAG['msj'] = $_LANG['THE_CHANGES_SAVED_SUCCESS'];
			$_FLAG['success'] = true;
		}
	}
	
	// Check for errors
	if( $dbxml_links->flag_error() )
	{
		$_FLAG['msj'] = $_LANG[ $dbxml_links->flag_i18n() ];
		$_FLAG['error'] = true;
	}
}

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error']);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['MANAGE_LINKS'].'</div>';

	echo '<form method="post">';
	
	echo '
			<input type="hidden" id="exe" name="exe" />
			<input type="hidden" name="token" value="'.$login->get_token().'" />
	';

	echo '<div id="js_container">';
	
	$links = $dbxml_links->get_all();
	foreach($links as $link)
	{
		echo '
			<div class="link_box" info_id="'.$link['id'].'">
			
				<input type="hidden" id="data_'.$link['id'].'" name="data_'.$link['id'].'" />
				<input type="hidden" id="type_'.$link['id'].'" value="static" />

				<div class="container_form_box_float">
					<div class="container_title_fields">'.$_LANG['NAME'].'</div>
					<input type="text" class="textbox_xsmall" id="name_'.$link['id'].'" value="'.$link['name'].'"/>
				</div>
		
				<div class="container_form_box_float">
					<div class="container_title_fields">'.$_LANG['URL'].'</div>
					<input type="text" class="textbox_medium" id="url_'.$link['id'].'" value="'.$link['url'].'"/>
				</div>
		
				<div class="container_form_box_float" style="padding-top: 6px;">
					<input type="button" class="border_round_3px button_default button_delete" info_id="'.$link['id'].'" info_step="0" value="'.$_LANG['DELETE'].'"/>
				</div>
		
				<br class="clearfloat" />
			</div>
		';
	}

	echo '</div>'; // END <div id="js_container">
	
	// BUTTONS
	echo '
			<div class="container_form_buttons">
				<input type="button" value="'.$_LANG['SAVE'].'"				class="border_round_3px button_default"	id="js_button_save" />
				<input type="button" value="'.$_LANG['ADD'].'"				class="border_round_3px button_default"	id="js_button_add" />
				<input type="button" value="'.$_LANG['CANCEL'].'"			class="border_round_3px button_cancel"		id="js_button_cancel" />
			</div>
	';

	echo '</form>';

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">

?>

<script type='text/javascript'>

/*
=======================================================
	JAVASCRIPT : VARS
=======================================================
*/

var tmp_id = <?php echo $dbxml_links->get_autoinc(); ?>;

/*
=======================================================
	JAVASCRIPT : FUNCTIONS
=======================================================
*/

// Save links
function submit_form()
{
	$.each( $(".link_box"), function(index, value)
	{
		var id = $(this).attr("info_id");
		var type = $("#type_"+id).val();
		var name = $("#name_"+id).val();
		var url = $("#url_"+id).val();
		
		$("#data_"+id).attr("value",id+","+type+","+name+","+url);
	}); 

	$("#exe").attr("value","save");
	$("form").attr("action","");
	$("form").submit();
	
	return false;
}

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/
			
$(document).ready(function(){

	// Event - Click - Button save
	$("#js_button_save").click(
		function()
		{
			submit_form();
		}
	);

	// Event - Click - Button cancel
	$("#js_button_cancel").click(
		function()
		{
			window.location = "./index.php";
		}
	);

	// Event - Click - Button add new link
	$("#js_button_add").click(
		function()
		{
			var template = '';
			template += '<div class="link_box" info_id="'+tmp_id+'" >';
			template += '	<input type="hidden" id="data_'+tmp_id+'" name="data_'+tmp_id+'">';
			template += '	<input type="hidden" id="type_'+tmp_id+'" value="dynamic">';
			template += '	<div class="container_form_box_float">';
			template += '		<div class="container_title_fields"><?php echo $_LANG['NAME'] ?></div>';
			template += '		<input type="text" class="textbox_xsmall" id="name_'+tmp_id+'" >';
			template += '	</div>';
			template += '	<div class="container_form_box_float">';
			template += '		<div class="container_title_fields"><?php echo $_LANG['URL'] ?></div>';
			template += '		<input type="text" class="textbox_medium" id="url_'+tmp_id+'" value="http://">';
			template += '	</div>';
			template += '	<div class="container_form_box_float" style="padding-top: 6px;">';
			template += '		<input type="button" class="border_round_3px button_default button_delete" info_id="'+tmp_id+'" value="<?php echo $_LANG['DELETE'] ?>">';
			template += '	</div>';
			template += '	<br class="clearfloat">';
			template += '</div>';
			
			$("#js_container").append(template);
			
			tmp_id+=1;
		}
	);

	// Event - Click - Button delete
	$(".button_delete").live("click",
		function()
		{
			var button = $(this);
			var id = button.attr("info_id");
			var type = $("#type_"+id).val();
			var step = button.attr("info_step");

			if(type=="dynamic")
			{
				$(".link_box[info_id=\""+id+"\"]").fadeOut('slow', function() { $(this).remove(); });

				tmp_id-=1;
			}
			else
			{
				if( step == "1" )
				{
					$("#exe").attr("value","delete");
					$("form").attr("action","?pag=list&idcat="+id);
					$("form").submit();
				}
				else
				{
					button.fadeOut(500, function() {
						 button.attr("value","<?php echo $_LANG['SURE'] ?>");
						 button.attr("info_step","1");
						 button.css("background","#E32B2B");
						 button.css("color","#FFFFFF");
						 button.css("border-color", "#AD2727");
					}).fadeIn(500);
				}
			}
		}
	);
});

</script>
