<?php

/*
=======================================================
	PHP
=======================================================
*/

require_once('security.php');

/*
=======================================================
	HTML
=======================================================
*/

	echo '<div id="main">';

	$html->banner_success_error($_FLAG['msj'], $_FLAG['success'], $_FLAG['error']);

	echo '<div class="container_box_default">';
	
	echo '<div class="container_title_default">'.$_LANG['MANAGE_COMMENTS'].'</div>';

	echo '<table>';
		echo '<thead>';
			echo '<tr>';
				echo '<th>'.$_LANG['COMMENT'].'</th>';
				echo '<th>'.$_LANG['POSTED_IN'].'</th>';
				echo '<th>'.$_LANG['AUTHOR'].'</th>';
			echo '</tr>';
		echo '</thead>';

		echo '<tbody>';

		$comments = $dbxml_comments->get_list_by_page($_URL['page'], COMMENTPPAGE);	
		foreach( $comments as $key=>$comment )
		{
			$post = $dbxml_post->get($comment['idpost']);
			
			$key % 2 == 0 ? $attr = ' bgcolor' : $attr = '';
			
			echo '<tr class="border'.$attr.'">';
				
				echo '<td>
							<div class="table_bold">'.$nbfunctions->cut_text( htmlspecialchars( $comment['content'] ), 35).'</div>
							<div class="table_tools">
								<a href="#" class="clist js_delete" idcomment="'.$comment['idcomment'].'" status="0">'.$_LANG['DELETE'].'</a>
								<a href="#" class="clist js_spam" ip="'.$comment['author_ip'].'" idcomment="'.$comment['idcomment'].'" status="0">'.$_LANG['BLOCK_IP_AND_DELETE'].' ('.$comment['author_ip'].')</a>
							</div>
						</td>
				';
				
				echo '<td><a href="../post.php?idpost='.$post['idpost'].'#comments">'.$post['title'].'</a></td>';
				echo '<td class="author">
							<div>'.$_LANG['AUTHOR'].': '.$comment['author_name'].'</div>
							<div>'.$_LANG['EMAIL'].': '.$comment['author_email'].'</div>
							<div>'.$_LANG['WEBSITE'].': '.$comment['author_website'].'</div>
						</td>
				';

			echo '</tr>';
			
			ob_flush();
		}

		echo '</tbody>';
	echo '</table>';

	if($dbxml_comments->get_count() > COMMENTPPAGE )
	{
		echo '<div class="container_backnext">';
		
			$next_page = $_URL['page'] + 1;
			$back_page = $_URL['page'] - 1;
			
			if($_URL['page'] > 0)
				echo '<div class="back"><a class="backnext" href="comment.php?view=list&amp;page='.$back_page.'">← '.$_LANG['BACK'].'</a></div>';
			
			if( $_URL['page'] < (ceil($dbxml_comments->get_count() / COMMENTPPAGE) -1) )
				echo '<div class="next"><a class="backnext" href="comment.php?view=list&amp;page='.$next_page.'">'.$_LANG['NEXT'].' →</a></div>';
				
		echo '</div>';
	}

	echo '</div>'; // END <div class="container_box_default">
	
	echo '</div>'; // END <div id="main">

?>

<script type='text/javascript'>

/*
=======================================================
	JAVASCRIPT : VARS
=======================================================
*/

var token = "<?php echo $login->get_token() ?>";

/*
=======================================================
	JAVASCRIPT : EVENTS
=======================================================
*/

$(document).ready(function(){

	$(".js_spam").click(
		function()
		{
			var cobj = $(this);
			var status = cobj.attr("status");
			var ip = cobj.attr("ip");
			var idcomment = cobj.attr("idcomment");
			
			if( status == "1")
			{
				$.post("ajax/spam_add.php", {token:token, ip: ip});
				
				$.post("ajax/comment_delete.php", {token:token, id: idcomment},
				function(xml)
				{
					if( $(xml).find("success").text() == "1" )
					{
						cobj.parent().parent().parent().fadeOut();
					}
				});
			}
			else
			{
				cobj.attr("status", "1");
				cobj.css("color", "#DA1818");
				cobj.html("<?php echo $_LANG['ARE_YOU_SURE'] ?>");				
			}
		}
	);

	$(".js_delete").click(
		function()
		{
			var cobj = $(this);
			var status = cobj.attr("status");
			var idcomment = cobj.attr("idcomment");
			
			if( status == "1")
			{			
				$.post("ajax/comment_delete.php", {token:token, id: idcomment},
				function(xml)
				{
					if( $(xml).find("success").text() == "1" )
					{
						cobj.parent().parent().parent().fadeOut();
					}
				});
			}
			else
			{
				cobj.attr("status", "1");
				cobj.css("color", "#DA1818");
				cobj.html("<?php echo $_LANG['ARE_YOU_SURE'] ?>");				
			}
		}
	);

});

</script>
