/**
 * @syntax String literals take the forms: Or, using the String global object directly:
 * @returns {String}
 */
function String() {
}
/**
 * @syntax sub()
 * @returns {String}
 */
String.prototype.sub = function() {};

/**
 * @syntax italics()
 * @returns {String}
 */
String.prototype.italics = function() {};

/**
 * @syntax link(hrefAttribute)
 * @param {String} hrefAttribute
 * @returns {String}
 */
String.prototype.link = function(hrefAttribute) {};

/**
 * @syntax fontcolor(color)
 * @param {String} color
 * @returns {String}
 */
String.prototype.fontcolor = function(color) {};

/**
 * @syntax indexOf(searchString,position)
 * @param {String} searchString
 * @param {Number} position
 * @returns {Number}
 */
String.prototype.indexOf = function(searchString, position) {};

/**
 * @syntax sup()
 * @returns {String}
 */
String.prototype.sup = function() {};

/**
 * @syntax fixed()
 * @returns {String}
 */
String.prototype.fixed = function() {};

/**
 * @syntax anchor(nameAttribute)
 * @param {String} nameAttribute
 * @returns {String}
 */
String.prototype.anchor = function(nameAttribute) {};

/**
 * @syntax toUpperCase()
 * @returns {String}
 */
String.prototype.toUpperCase = function() {};

/**
 * @syntax bold()
 * @returns {String}
 */
String.prototype.bold = function() {};

/**
 * @syntax strike()
 * @returns {String}
 */
String.prototype.strike = function() {};

/**
 * @syntax search(regexp)
 * @param {RegExp} regexp
 * @returns {Number}
 */
String.prototype.search = function(regexp) {};

/**
 * @syntax substring(start,end)
 * @param {Number} start
 * @param {Number} end
 * @returns {String}
 */
String.prototype.substring = function(start, end) {};

/**
 * @syntax length
 * @returns {Number}
 */
String.prototype.length = new Number();

/**
 * @syntax valueOf()
 * @returns {String}
 */
String.prototype.valueOf = function() {};

/**
 * @syntax toLocaleUpperCase()
 * @returns {String}
 */
String.prototype.toLocaleUpperCase = function() {};

/**
 * @syntax trim()
 * @returns {String}
 */
String.prototype.trim = function() {};

/**
 * @syntax charAt(pos)
 * @param {Number} pos
 * @returns {String}
 */
String.prototype.charAt = function(pos) {};

/**
 * @syntax substr(start,length)
 * @param {Number} start
 * @param {Number} length
 * @returns {String}
 */
String.prototype.substr = function(start, length) {};

/**
 * @syntax constructor
 * @returns {Function}
 */
String.prototype.constructor = new Function();

/**
 * @syntax fromCharCode([char0[,char1[,...]]])
 * @param {Number} 
 * @returns {String}
 * @static
 */
String.fromCharCode = function() {};

/**
 * @syntax localeCompare(that)
 * @returns {Number}
 */
String.prototype.localeCompare = function(that) {};

/**
 * @syntax lastIndexOf(searchString,position)
 * @param {String} searchString
 * @param {Number} position
 * @returns {Number}
 */
String.prototype.lastIndexOf = function(searchString, position) {};

/**
 * @syntax toLocaleLowerCase()
 * @returns {String}
 */
String.prototype.toLocaleLowerCase = function() {};

/**
 * @syntax concat([string1[,string2[,...]]])
 * @param {String} 
 * @returns {String}
 */
String.prototype.concat = function() {};

/**
 * @syntax replace(searchValue,replaceValue)
 * @param {RegExp} searchValue
 * @param {String} replaceValue
 * @returns {String}
 */
String.prototype.replace = function(searchValue, replaceValue) {};

/**
 * @syntax blink()
 * @returns {String}
 */
String.prototype.blink = function() {};

/**
 * @syntax charCodeAt(pos)
 * @param {Number} pos
 * @returns {Number}
 */
String.prototype.charCodeAt = function(pos) {};

/**
 * @syntax toLowerCase()
 * @returns {String}
 */
String.prototype.toLowerCase = function() {};

/**
 * @syntax toString()
 * @returns {String}
 */
String.prototype.toString = function() {};

/**
 * @syntax split(separator,limit)
 * @param {String} separator
 * @param {Number} limit
 * @returns {Array}
 */
String.prototype.split = function(separator, limit) {};

/**
 * @syntax slice(start,end)
 * @param {Number} start
 * @param {Number} end
 * @returns {String}
 */
String.prototype.slice = function(start, end) {};

/**
 * @syntax match(regexp)
 * @returns {Array}
 */
String.prototype.match = function(regexp) {};

/**
 * @syntax big()
 * @returns {String}
 */
String.prototype.big = function() {};

/**
 * @syntax small()
 * @returns {String}
 */
String.prototype.small = function() {};

/**
 * @syntax fontsize(size)
 * @param {Number} size
 * @returns {Number}
 */
String.prototype.fontsize = function(size) {};

/**
 * @syntax prototype
 * @returns {Object}
 * @static
 */
String.prototype;

