/**
 * The Node interface is the primary datatype for the entire Document Object Model. It represents a single node in the document tree. While all objects implementing the Node interface expose methods for dealing with children, not all objects implementing the Node interface may have children. For example, Text nodes may not have children, and adding children to such nodes results in a DOMException being raised.The attributes nodeName, nodeValue and attributes are included as a mechanism to get at node information without casting down to the specific derived interface. In cases where there is no obvious mapping of these attributes for a specific nodeType (e.g., nodeValue for an Element or attributes for a Comment), this returns null. Note that the specialized interfaces may contain additional and more convenient mechanisms to get and set the relevant information.
 */
var Node = {
}
/**
 * Returns whether this node (if it is an element) has any attributes.
 * @syntax node.hasAttributes()
 * @returns {boolean} Returns true if this node has any attributes, false otherwise.
 */
Node.prototype.hasAttributes = function() {};

/**
 * The node is a DocumentFragment.
 * @syntax Node.DOCUMENT_FRAGMENT_NODE
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_FRAGMENT_NODE = new Number();

/**
 * The name of this node, depending on its type; see the table above.
 * @syntax node.nodeName
 * @returns {String} 
 */
Node.prototype.nodeName = new String();

/**
 * This method returns a specialized object which implements the specialized APIs of the specified feature and version, as specified in DOM Features. The specialized object may also be obtained by using binding-specific casting methods but is not necessarily expected to, as discussed in Mixed DOM Implementations. This method also allow the implementation to provide specialized objects which do not support the Node interface.
 * @syntax node.getFeature(feature, version)
 * @param {String} feature The name of the feature requested. Note that any plus sign "+" prepended to the name of the feature will be ignored since it is not significant in the context of this method.
 * @param {String} version This is the version number of the feature to test.
 * @returns {DOMObject} Returns an object which implements the specialized APIs of the specified feature and version, if any, or null if there is no object which implements interfaces associated with that feature. If the DOMObject returned by this method implements the Node interface, it must delegate to the primary core Node and not return results inconsistent with the primary core Node such as attributes, childNodes, etc.
 */
Node.prototype.getFeature = function(feature,  version) {};

/**
 * Look up the prefix associated to the given namespace URI, starting from this node. The default namespace declarations are ignored by this method
 * @syntax node.lookupPrefix(namespaceURI)
 * @param {String} namespaceURI The namespace URI to look for.
 * @returns {String} Returns an associated namespace prefix if found or null if none is found. If more than one prefix are associated to the namespace prefix, the returned namespace prefix is implementation dependent.
 */
Node.prototype.lookupPrefix = function(namespaceURI) {};

/**
 * The node is a Document.
 * @syntax Node.DOCUMENT_NODE
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_NODE = new Number();

/**
 * The node immediately following this node. If there is no such node, this returns null.
 * @syntax node.nextSibling
 * @returns {Node} 
 */
Node.prototype.nextSibling = new Node();

/**
 * The node contains the reference node. A node which contains is always preceding, too.
 * @syntax Node.DOCUMENT_POSITION_CONTAINS
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_POSITION_CONTAINS = new Number();

/**
 * The node is a Text node.
 * @syntax Node.TEXT_NODE
 * @returns {Number} 
 * @static
 */
Node.TEXT_NODE = new Number();

/**
 * Tests whether the DOM implementation implements a specific feature and that feature is supported by this node, as specified in DOM Features.
 * @syntax node.isSupported(feature, version)
 * @param {String} feature The name of the feature to test.
 * @param {String} version This is the version number of the feature to test.
 * @returns {boolean} Returns true if the specified feature is supported on this node, false otherwise.
 */
Node.prototype.isSupported = function(feature,  version) {};

/**
 * Returns the local part of the qualified name of this node. For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and nodes created with a DOM Level 1 method, such as Document.createElement(), this is always null.
 * @syntax node.localName
 * @returns {String} 
 */
Node.prototype.localName = new String();

/**
 * The node is a Notation.
 * @syntax Node.NOTATION_NODE
 * @returns {Number} 
 * @static
 */
Node.NOTATION_NODE = new Number();

/**
 * The node is a Comment.
 * @syntax Node.COMMENT_NODE
 * @returns {Number} 
 * @static
 */
Node.COMMENT_NODE = new Number();

/**
 * The determination of preceding versus following is implementation-specific.
 * @syntax Node.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = new Number();

/**
 * Removes the child node indicated by oldChild from the list of children, and returns it
 * @syntax node.removeChild(oldChild)
 * @param {Node} oldChild The node being removed.
 * @returns {Node} The node removed.
 */
Node.prototype.removeChild = function(oldChild) {};

/**
 * The node is an Attr.
 * @syntax Node.ATTRIBUTE_NODE
 * @returns {Number} 
 * @static
 */
Node.ATTRIBUTE_NODE = new Number();

/**
 * Look up the namespace URI associated to the given prefix, starting from this node. See Namespace URI Lookup for details on the algorithm used by this method
 * @syntax node.lookupNamespaceURI(prefix)
 * @param {String} prefix The prefix to look for. If this parameter is null, the method will return the default namespace URI if any.
 * @returns {String} Returns the associated namespace URI or null if none is found.
 */
Node.prototype.lookupNamespaceURI = function(prefix) {};

/**
 * The namespace prefix of this node, or null if it is unspecified. When it is defined to be null, setting it has no effect, including if the node is read-only. Note that setting this attribute, when permitted, changes the nodeName attribute, which holds the qualified name, as well as the tagName and name attributes of the Element and Attr interfaces, when applicable. Setting the prefix to null makes it unspecified, setting it to an empty string is implementation dependent. Note also that changing the prefix of an attribute that is known to have a default value, does not make a new attribute with the default value and the original prefix appear, since the namespaceURI and localName do not change. For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and nodes created with a DOM Level 1 method, such as createElement from the Document interface, this is always null. Exceptions on setting DOMException INVALID_CHARACTER_ERR: Raised if the specified prefix contains an illegal character according to the XML version in use specified in the Document.xmlVersion attribute. NO_MODIFICATION_ALLOWED_ERR: Raised if this node is readonly. NAMESPACE_ERR: Raised if the specified prefix is malformed per the Namespaces in XML specification, if the namespaceURI of this node is null, if the specified prefix is "xml" and the namespaceURI of this node is different from "http://www.w3.org/XML/1998/namespace", if this node is an attribute and the specified prefix is "xmlns" and the namespaceURI of this node is different from "http://www.w3.org/2000/xmlns/", or if this node is an attribute and the qualifiedName of this node is "xmlns" [XML Namespaces].
 * @syntax node.prefix
 * @returns {String} 
 */
Node.prototype.prefix = new String();

/**
 * The value of this node, depending on its type; see the table above. When it is defined to be null, setting it has no effect, including if the node is read-only. Exceptions on setting DOMException NO_MODIFICATION_ALLOWED_ERR: Raised when the node is readonly and if it is not defined to be null. Exceptions on retrieval DOMException DOMSTRING_SIZE_ERR: Raised when it would return more characters than fit in a DOMString variable on the implementation platform.
 * @syntax node.nodeValue
 * @returns {String} 
 */
Node.prototype.nodeValue = new String();

/**
 * This attribute returns the text content of this node and its descendants. When it is defined to be null, setting it has no effect. On setting, any possible children this node may have are removed and, if it the new string is not empty or null, replaced by a single Text node containing the string this attribute is set to. On getting, no serialization is performed, the returned string does not contain any markup. No whitespace normalization is performed and the returned string does not contain the white spaces in element content (see the attribute Text.isElementContentWhitespace). Similarly, on setting, no parsing is performed either, the input string is taken as pure textual content. The string returned is made of the text content of this node depending on its type, as defined below: Node type Content ELEMENT_NODE, ATTRIBUTE_NODE, ENTITY_NODE, ENTITY_REFERENCE_NODE, DOCUMENT_FRAGMENT_NODE concatenation of the textContent attribute value of every child node, excluding COMMENT_NODE and PROCESSING_INSTRUCTION_NODE nodes. This is the empty string if the node has no children. TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODE, PROCESSING_INSTRUCTION_NODE nodeValue DOCUMENT_NODE, DOCUMENT_TYPE_NODE, NOTATION_NODE null Exceptions on setting DOMException NO_MODIFICATION_ALLOWED_ERR: Raised when the node is readonly. Exceptions on retrieval DOMException DOMSTRING_SIZE_ERR: Raised when it would return more characters than fit in a DOMString variable on the implementation platform.
 * @syntax node.textContent
 * @returns {String} 
 */
Node.prototype.textContent = new String();

/**
 * The node is a DocumentType.
 * @syntax Node.DOCUMENT_TYPE_NODE
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_TYPE_NODE = new Number();

/**
 * The first child of this node. If there is no such node, this returns null.
 * @syntax node.firstChild
 * @returns {Node} 
 */
Node.prototype.firstChild = new Node();

/**
 * A NodeList that contains all children of this node. If there are no children, this is a NodeList containing no nodes.
 * @syntax node.childNodes
 * @returns {NodeList} 
 */
Node.prototype.childNodes = new NodeList();

/**
 * The node is an Element.
 * @syntax Node.ELEMENT_NODE
 * @returns {Number} 
 * @static
 */
Node.ELEMENT_NODE = new Number();

/**
 * Replaces the child node oldChild with newChild in the list of children, and returns the oldChild node. If newChild is a DocumentFragment object, oldChild is replaced by all of the DocumentFragment children, which are inserted in the same order. If the newChild is already in the tree, it is first removed. Note: Replacing a node with itself is implementation dependent.
 * @syntax node.replaceChild(newChild, oldChild)
 * @param {Node} newChild The new node to put in the child list.
 * @param {Node} oldChild The node being replaced in the list.
 * @returns {Node} The node replaced.
 */
Node.prototype.replaceChild = function(newChild,  oldChild) {};

/**
 * The absolute base URI of this node or null if the implementation wasn't able to obtain an absolute URI. This value is computed as described in Base URIs. However, when the Document supports the feature "HTML" [DOM Level 2 HTML], the base URI is computed using first the value of the href attribute of the HTML BASE element if any, and the value of the documentURI attribute from the Document interface otherwise.
 * @syntax node.baseURI
 * @returns {String} 
 */
Node.prototype.baseURI = new String();

/**
 * The node follows the reference node.
 * @syntax Node.DOCUMENT_POSITION_FOLLOWING
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_POSITION_FOLLOWING = new Number();

/**
 * The Document object associated with this node. This is also the Document object used to create new nodes. When this node is a Document or a DocumentType which is not used with any Document yet, this is null.
 * @syntax node.ownerDocument
 * @returns {Document} 
 */
Node.prototype.ownerDocument = new Document();

/**
 * The last child of this node. If there is no such node, this returns null.
 * @syntax node.lastChild
 * @returns {Node} 
 */
Node.prototype.lastChild = new Node();

/**
 * Puts all Text nodes in the full depth of the sub-tree underneath this Node, including attribute nodes, into a "normal" form where only structure (e.g., elements, comments, processing instructions, CDATA sections, and entity references) separates Text nodes, i.e., there are neither adjacent Text nodes nor empty Text nodes. This can be used to ensure that the DOM view of a document is the same as if it were saved and re-loaded, and is useful when operations (such as XPointer [ XPointer] lookups) that depend on a particular document tree structure are to be used. If the parameter " normalize-characters" of the DOMConfiguration object attached to the Node.ownerDocument is true, this method will also fully normalize the characters of the Text nodes. Note: In cases where the document contains CDATASections, the normalize operation alone may not be sufficient, since XPointers do not differentiate between Text nodes and CDATASection nodes.
 * @syntax node.normalize()
 * @returns {undefined} 
 */
Node.prototype.normalize = function() {};

/**
 * Associate an object to a key on this node. The object can later be retrieved from this node by calling getUserData with the same key
 * @syntax node.setUserData(key, data, handler)
 * @param {String} key The key to associate the object to.
 * @param {DOMUserData} data The object to associate to the given key, or null to remove any existing association to that key.
 * @param {UserDataHandler} handler The handler to associate to that key, or null.
 * @returns {DOMUserData} Returns the DOMUserData previously associated to the given key on this node, or null if there was none.
 */
Node.prototype.setUserData = function(key,  data,  handler) {};

/**
 * The node immediately preceding this node. If there is no such node, this returns null.
 * @syntax node.previousSibling
 * @returns {Node} 
 */
Node.prototype.previousSibling = new Node();

/**
 * The parent of this node. All nodes, except Attr, Document, DocumentFragment, Entity, and Notation may have a parent. However, if a node has just been created and not yet added to the tree, or if it has been removed from the tree, this is null.
 * @syntax node.parentNode
 * @returns {Node} 
 */
Node.prototype.parentNode = new Node();

/**
 * Returns whether this node has any children.
 * @syntax node.hasChildNodes()
 * @returns {boolean} Returns true if this node has any children, false otherwise.
 */
Node.prototype.hasChildNodes = function() {};

/**
 * A code representing the type of the underlying object, as defined above.
 * @syntax node.nodeType
 * @returns {Number} 
 */
Node.prototype.nodeType = new Number();

/**
 * The second node precedes the reference node.
 * @syntax Node.DOCUMENT_POSITION_PRECEDING
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_POSITION_PRECEDING = new Number();

/**
 * Returns a duplicate of this node, i.e., serves as a generic copy constructor for nodes. The duplicate node has no parent (parentNode is null) and no user data. User data associated to the imported node is not carried over. However, if any UserDataHandlers has been specified along with the associated data these handlers will be called with the appropriate parameters before this method returns. Cloning an Element copies all attributes and their values, including those generated by the XML processor to represent defaulted attributes, but this method does not copy any children it contains unless it is a deep clone. This includes text contained in an the Element since the text is contained in a child Text node. Cloning an Attr directly, as opposed to be cloned as part of an Element cloning operation, returns a specified attribute (specified is true). Cloning an Attr always clones its children, since they represent its value, no matter whether this is a deep clone or not. Cloning an EntityReference automatically constructs its subtree if a corresponding Entity is available, no matter whether this is a deep clone or not. Cloning any other type of node simply returns a copy of this node. Note that cloning an immutable subtree results in a mutable copy, but the children of an EntityReference clone are readonly. In addition, clones of unspecified Attr nodes are specified. And, cloning Document, DocumentType, Entity, and Notation nodes is implementation dependent
 * @syntax node.cloneNode(deep)
 * @param {boolean} deep If true, recursively clone the subtree under the specified node; if false, clone only the node itself (and its attributes, if it is an Element).
 * @returns {Node} The duplicate node.
 */
Node.prototype.cloneNode = function(deep) {};

/**
 * This method checks if the specified namespaceURI is the default namespace or not.
 * @syntax node.isDefaultNamespace(namespaceURI)
 * @param {String} namespaceURI The namespace URI to look for.
 * @returns {boolean} Returns true if the specified namespaceURI is the default namespace, false otherwise.
 */
Node.prototype.isDefaultNamespace = function(namespaceURI) {};

/**
 * The node is an Entity.
 * @syntax Node.ENTITY_NODE
 * @returns {Number} 
 * @static
 */
Node.ENTITY_NODE = new Number();

/**
 * The two nodes are disconnected. Order between disconnected nodes is always implementation-specific.
 * @syntax Node.DOCUMENT_POSITION_DISCONNECTED
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_POSITION_DISCONNECTED = new Number();

/**
 * The node is a CDATASection.
 * @syntax Node.CDATA_SECTION_NODE
 * @returns {Number} 
 * @static
 */
Node.CDATA_SECTION_NODE = new Number();

/**
 * Inserts the node newChild before the existing child node refChild. If refChild is null, insert newChild at the end of the list of children. If newChild is a DocumentFragment object, all of its children are inserted, in the same order, before refChild. If the newChild is already in the tree, it is first removed. Note: Inserting a node before itself is implementation dependent.
 * @syntax node.insertBefore(newChild, refChild)
 * @param {Node} newChild The node to insert.
 * @param {Node} refChild The reference node, i.e., the node before which the new node must be inserted.
 * @returns {Node} The node being inserted.
 */
Node.prototype.insertBefore = function(newChild,  refChild) {};

/**
 * The node is a ProcessingInstruction.
 * @syntax Node.PROCESSING_INSTRUCTION_NODE
 * @returns {Number} 
 * @static
 */
Node.PROCESSING_INSTRUCTION_NODE = new Number();

/**
 * Adds the node newChild to the end of the list of children of this node. If the newChild is already in the tree, it is first removed
 * @syntax node.appendChild(newChild)
 * @param {Node} newChild The node to add. If it is a DocumentFragment object, the entire contents of the document fragment are moved into the child list of this node
 * @returns {Node} The node added.
 */
Node.prototype.appendChild = function(newChild) {};

/**
 * Returns whether this node is the same node as the given one. This method provides a way to determine whether two Node references returned by the implementation reference the same object. When two Node references are references to the same object, even if through a proxy, the references may be used completely interchangeably, such that all attributes have the same values and calling the same DOM method on either reference always has exactly the same effect
 * @syntax node.isSameNode(other)
 * @param {Node} other The node to test against.
 * @returns {boolean} Returns true if the nodes are the same, false otherwise.
 */
Node.prototype.isSameNode = function(other) {};

/**
 * Compares the reference node, i.e. the node on which this method is being called, with a node, i.e. the one passed as a parameter, with regard to their position in the document and according to the document order.
 * @syntax node.compareDocumentPosition(other)
 * @param {Node} other The node to compare against the reference node.
 * @returns {Number} Returns how the node is positioned relatively to the reference node.
 */
Node.prototype.compareDocumentPosition = function(other) {};

/**
 * The node is an EntityReference.
 * @syntax Node.ENTITY_REFERENCE_NODE
 * @returns {Number} 
 * @static
 */
Node.ENTITY_REFERENCE_NODE = new Number();

/**
 * Retrieves the object associated to a key on a this node. The object must first have been set to this node by calling setUserData with the same key
 * @syntax node.getUserData(key)
 * @param {String} key The key the object is associated to.
 * @returns {DOMUserData} Returns the DOMUserData associated to the given key on this node, or null if there was none.
 */
Node.prototype.getUserData = function(key) {};

/**
 * The namespace URI of this node, or null if it is unspecified (see XML Namespaces). This is not a computed value that is the result of a namespace lookup based on an examination of the namespace declarations in scope. It is merely the namespace URI given at creation time. For nodes of any type other than ELEMENT_NODE and ATTRIBUTE_NODE and nodes created with a DOM Level 1 method, such as Document.createElement(), this is always null. Note: Per the Namespaces in XML Specification [XML Namespaces] an attribute does not inherit its namespace from the element it is attached to. If an attribute is not explicitly given a namespace, it simply has no namespace.
 * @syntax node.namespaceURI
 * @returns {String} 
 */
Node.prototype.namespaceURI = new String();

/**
 * A NamedNodeMap containing the attributes of this node (if it is an Element) or null otherwise.
 * @syntax node.attributes
 * @returns {NamedNodeMap} 
 */
Node.prototype.attributes = new NamedNodeMap();

/**
 * Tests whether two nodes are equal. This method tests for equality of nodes, not sameness (i.e., whether the two nodes are references to the same object) which can be tested with Node.isSameNode(). All nodes that are the same will also be equal, though the reverse may not be true. Two nodes are equal if and only if the following conditions are satisfied: The two nodes are of the same type. The following string attributes are equal: nodeName, localName, namespaceURI, prefix, nodeValue. This is: they are both null, or they have the same length and are character for character identical. The attributes NamedNodeMaps are equal. This is: they are both null, or they have the same length and for each node that exists in one map there is a node that exists in the other map and is equal, although not necessarily at the same index. The childNodes NodeLists are equal. This is: they are both null, or they have the same length and contain equal nodes at the same index. Note that normalization can affect equality; to avoid this, nodes should be normalized before being compared. For two DocumentType nodes to be equal, the following conditions must also be satisfied: The following string attributes are equal: publicId, systemId, internalSubset. The entities NamedNodeMaps are equal. The notations NamedNodeMaps are equal. On the other hand, the following do not affect equality: the ownerDocument, baseURI, and parentNode attributes, the specified attribute for Attr nodes, the schemaTypeInfo attribute for Attr and Element nodes, the Text.isElementContentWhitespace attribute for Text nodes, as well as any user data or event listeners registered on the nodes. Note: As a general rule, anything not mentioned in the description above is not significant in consideration of equality checking. Note that future versions of this specification may take into account more attributes and implementations conform to this specification are expected to be updated accordingly.
 * @syntax node.isEqualNode(arg)
 * @param {Node} arg The node to compare equality with.
 * @returns {boolean} Returns true if the nodes are equal, false otherwise.
 */
Node.prototype.isEqualNode = function(arg) {};

/**
 * The node is contained by the reference node. A node which is contained is always following, too.
 * @syntax Node.DOCUMENT_POSITION_CONTAINED_BY
 * @returns {Number} 
 * @static
 */
Node.DOCUMENT_POSITION_CONTAINED_BY = new Number();

/**
 * Represents the Node prototype object.
 * @syntax Node.prototype
 * @static
 */
Node.prototype;

