/**
 * Multi-line text field. See the TEXTAREA element definition in HTML 4.01.
 */
var HTMLTextAreaElement = {
}
/**
 * A single character access key to give access to the form control. See the accesskey attribute definition in HTML 4.01.
 * @syntax hTMLTextAreaElement.accessKey
 * @returns {String} 
 */
HTMLTextAreaElement.prototype.accessKey = new String();

/**
 * Width of control (in characters). See the cols attribute definition in HTML 4.01.
 * @syntax hTMLTextAreaElement.cols
 * @returns {Number} 
 */
HTMLTextAreaElement.prototype.cols = new Number();

/**
 * Returns the FORM element containing this control. Returns null if this control is not within the context of a form.
 * @syntax hTMLTextAreaElement.form
 * @returns {HTMLFormElement} 
 */
HTMLTextAreaElement.prototype.form = new HTMLFormElement();

/**
 * Select the contents of the TEXTAREA.
 * @syntax hTMLTextAreaElement.select()
 * @returns {undefined} 
 */
HTMLTextAreaElement.prototype.select = function() {};

/**
 * Index that represents the element's position in the tabbing order. See the tabindex attribute definition in HTML 4.01.
 * @syntax hTMLTextAreaElement.tabIndex
 * @returns {Number} 
 */
HTMLTextAreaElement.prototype.tabIndex = new Number();

/**
 * Removes keyboard focus from this element.
 * @syntax hTMLTextAreaElement.blur()
 * @returns {undefined} 
 */
HTMLTextAreaElement.prototype.blur = function() {};

/**
 * The type of this form control. This the string "textarea".
 * @syntax hTMLTextAreaElement.type
 * @returns {String} 
 */
HTMLTextAreaElement.prototype.type = new String();

/**
 * Number of text rows. See the rows attribute definition in HTML 4.01.
 * @syntax hTMLTextAreaElement.rows
 * @returns {Number} 
 */
HTMLTextAreaElement.prototype.rows = new Number();

/**
 * This control is read-only. See the readonly attribute definition in HTML 4.01.
 * @syntax hTMLTextAreaElement.readOnly
 * @returns {boolean} 
 */
HTMLTextAreaElement.prototype.readOnly = new boolean();

/**
 * Form control or object name when submitted with a form. See the name attribute definition in HTML 4.01.
 * @syntax hTMLTextAreaElement.name
 * @returns {String} 
 */
HTMLTextAreaElement.prototype.name = new String();

/**
 * Represents the current contents of the corresponding form control, in an interactive user agent. Changing this attribute changes the contents of the form control, but does not change the contents of the element. If the entirety of the data can not fit into a single DOMString, the implementation may truncate the data.
 * @syntax hTMLTextAreaElement.value
 * @returns {String} 
 */
HTMLTextAreaElement.prototype.value = new String();

/**
 * Gives keyboard focus to this element.
 * @syntax hTMLTextAreaElement.focus()
 * @returns {undefined} 
 */
HTMLTextAreaElement.prototype.focus = function() {};

/**
 * Represents the contents of the element. The value of this attribute does not change if the contents of the corresponding form control, in an interactive user agent, changes.
 * @syntax hTMLTextAreaElement.defaultValue
 * @returns {String} 
 */
HTMLTextAreaElement.prototype.defaultValue = new String();

/**
 * The control is unavailable in this context. See the disabled attribute definition in HTML 4.01.
 * @syntax hTMLTextAreaElement.disabled
 * @returns {boolean} 
 */
HTMLTextAreaElement.prototype.disabled = new boolean();

/**
 * Represents the HTMLTextAreaElement prototype object.
 * @syntax HTMLTextAreaElement.prototype
 * @static
 */
HTMLTextAreaElement.prototype;

