/**
 * Generic embedded object.Note: In principle, all properties on the object element are read-write but in some environments some properties may be read-only once the underlying object is instantiated. See the OBJECT element definition in [HTML 4.01].
 */
var HTMLObjectElement = {
}
/**
 * Returns the FORM element containing this control. Returns null if this control is not within the context of a form.
 * @syntax hTMLObjectElement.form
 * @returns {HTMLFormElement} 
 */
HTMLObjectElement.prototype.form = new HTMLFormElement();

/**
 * Horizontal space, in pixels, to the left and right of this image, applet, or object. See the hspace attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLObjectElement.hspace
 * @returns {Number} 
 */
HTMLObjectElement.prototype.hspace = new Number();

/**
 * Override width. See the width attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.width
 * @returns {String} 
 */
HTMLObjectElement.prototype.width = new String();

/**
 * Index that represents the element's position in the tabbing order. See the tabindex attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.tabIndex
 * @returns {Number} 
 */
HTMLObjectElement.prototype.tabIndex = new Number();

/**
 * Aligns this object (vertically or horizontally) with respect to its surrounding text. See the align attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLObjectElement.align
 * @returns {String} 
 */
HTMLObjectElement.prototype.align = new String();

/**
 * A URI [IETF RFC 2396] specifying the location of the object's data. See the data attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.data
 * @returns {String} 
 */
HTMLObjectElement.prototype.data = new String();

/**
 * Applet class file. See the code attribute for HTMLAppletElement.
 * @syntax hTMLObjectElement.code
 * @returns {String} 
 */
HTMLObjectElement.prototype.code = new String();

/**
 * Content type for data downloaded via classid attribute. See the codetype attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.codeType
 * @returns {String} 
 */
HTMLObjectElement.prototype.codeType = new String();

/**
 * Use client-side image map. See the usemap attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.useMap
 * @returns {String} 
 */
HTMLObjectElement.prototype.useMap = new String();

/**
 * Content type for data downloaded via data attribute. See the type attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.type
 * @returns {String} 
 */
HTMLObjectElement.prototype.type = new String();

/**
 * Declare (for future reference), but do not instantiate, this object. See the declare attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.declare
 * @returns {boolean} 
 */
HTMLObjectElement.prototype.declare = new boolean();

/**
 * Base URI [IETF RFC 2396] for classid, data, and archive attributes. See the codebase attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.codeBase
 * @returns {String} 
 */
HTMLObjectElement.prototype.codeBase = new String();

/**
 * Override height. See the height attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.height
 * @returns {String} 
 */
HTMLObjectElement.prototype.height = new String();

/**
 * Message to render while loading the object. See the standby attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.standby
 * @returns {String} 
 */
HTMLObjectElement.prototype.standby = new String();

/**
 * Form control or object name when submitted with a form. See the name attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.name
 * @returns {String} 
 */
HTMLObjectElement.prototype.name = new String();

/**
 * Space-separated list of archives. See the archive attribute definition in HTML 4.01.
 * @syntax hTMLObjectElement.archive
 * @returns {String} 
 */
HTMLObjectElement.prototype.archive = new String();

/**
 * Width of border around the object. See the border attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLObjectElement.border
 * @returns {String} 
 */
HTMLObjectElement.prototype.border = new String();

/**
 * Vertical space, in pixels, above and below this image, applet, or object. See the vspace attribute definition in HTML 4.01. This attribute is deprecated in HTML 4.01.
 * @syntax hTMLObjectElement.vspace
 * @returns {Number} 
 */
HTMLObjectElement.prototype.vspace = new Number();

/**
 * The document this object contains, if there is any and it is available, or null otherwise.
 * @syntax hTMLObjectElement.contentDocument
 * @returns {Document} 
 */
HTMLObjectElement.prototype.contentDocument = new Document();

/**
 * Represents the HTMLObjectElement prototype object.
 * @syntax HTMLObjectElement.prototype
 * @static
 */
HTMLObjectElement.prototype;

