/**
 * The Document interface represents the entire HTML or XML document. Conceptually, it is the root of the document tree, and provides the primary access to the document's data.Since elements, text nodes, comments, processing instructions, etc. cannot exist outside the context of a Document, the Document interface also contains the factory methods needed to create these objects. The Node objects created have a ownerDocument attribute which associates them with the Document within whose context they were created.
 */
var Document = new Node();
/**
 * Imports a node from another document to this document, without altering or removing the source node from the original document; this method creates a new copy of the source node. The returned node has no parent; ( parentNode is null). For all nodes, importing a node creates a node object owned by the importing document, with attribute values identical to the source node's nodeName and nodeType, plus the attributes related to namespaces ( prefix, localName, and namespaceURI). As in the cloneNode operation, the source node is not altered. User data associated to the imported node is not carried over. However, if any UserDataHandlers has been specified along with the associated data these handlers will be called with the appropriate parameters before this method returns. Additional information is copied as appropriate to the nodeType, attempting to mirror the behavior expected if a fragment of XML or HTML source was copied from one document to another, recognizing that the two documents may have different DTDs in the XML case. The following list describes the specifics for each type of node. ATTRIBUTE_NODE The ownerElement attribute is set to null and the specified flag is set to true on the generated Attr. The descendants of the source Attr are recursively imported and the resulting nodes reassembled to form the corresponding subtree. Note that the deep parameter has no effect on Attr nodes; they always carry their children with them when imported. DOCUMENT_FRAGMENT_NODE If the deep option was set to true, the descendants of the source DocumentFragment are recursively imported and the resulting nodes reassembled under the imported DocumentFragment to form the corresponding subtree. Otherwise, this simply generates an empty DocumentFragment. DOCUMENT_NODE Document nodes cannot be imported. DOCUMENT_TYPE_NODE DocumentType nodes cannot be imported. ELEMENT_NODE Specified attribute nodes of the source element are imported, and the generated Attr nodes are attached to the generated Element. Default attributes are not copied, though if the document being imported into defines default attributes for this element name, those are assigned. If the importNode deep parameter was set to true, the descendants of the source element are recursively imported and the resulting nodes reassembled to form the corresponding subtree. ENTITY_NODE Entity nodes can be imported, however in the current release of the DOM the DocumentType is readonly. Ability to add these imported nodes to a DocumentType will be considered for addition to a future release of the DOM. On import, the publicId, systemId, and notationName attributes are copied. If a deep import is requested, the descendants of the the source Entity are recursively imported and the resulting nodes reassembled to form the corresponding subtree. ENTITY_REFERENCE_NODE Only the EntityReference itself is copied, even if a deep import is requested, since the source and destination documents might have defined the entity differently. If the document being imported into provides a definition for this entity name, its value is assigned. NOTATION_NODE Notation nodes can be imported, however in the current release of the DOM the DocumentType is readonly. Ability to add these imported nodes to a DocumentType will be considered for addition to a future release of the DOM. On import, the publicId and systemId attributes are copied. Note that the deep parameter has no effect on this type of nodes since they cannot have any children. PROCESSING_INSTRUCTION_NODE The imported node copies its target and data values from those of the source node. Note that the deep parameter has no effect on this type of nodes since they cannot have any children. TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODE These three types of nodes inheriting from CharacterData copy their data and length attributes from those of the source node. Note that the deep parameter has no effect on these types of nodes since they cannot have any children.
 * @syntax document.importNode(importedNode, deep)
 * @param {Node} importedNode The node to import.
 * @param {boolean} deep If true, recursively import the subtree under the specified node; if false, import only the node itself, as explained above. This has no effect on nodes that cannot have any children, and on Attr, and EntityReference nodes.
 * @returns {Node} The imported node that belongs to this Document.
 */
Document.prototype.importNode = function(importedNode,  deep) {};

/**
 * Create a new NodeIterator over the subtree rooted at the specified node.
 * @syntax documentTraversal.createNodeIterator(root, whatToShow, filter, entityReferenceExpansion)
 * @param {Node} root The node which will be iterated together with its children. The iterator is initially positioned just before this node. The whatToShow flags and the filter, if any, are not considered when setting this position. The root must not be null.
 * @param {Number} whatToShow This flag specifies which node types may appear in the logical view of the tree presented by the iterator. See the description of NodeFilter for the set of possible SHOW_ values. These flags can be combined using OR.
 * @param {NodeFilter} filter The NodeFilter to be used with this TreeWalker, or null to indicate no filter.
 * @param {boolean} entityReferenceExpansion The value of this flag determines whether entity reference nodes are expanded.
 * @returns {NodeIterator} The newly created NodeIterator.
 */
Document.prototype.createNodeIterator = function(root,  whatToShow,  filter,  entityReferenceExpansion) {};

/**
 * Attempts to adopt a node from another document to this document. If supported, it changes the ownerDocument of the source node, its children, as well as the attached attribute nodes if there are any. If the source node has a parent it is first removed from the child list of its parent. This effectively allows moving a subtree from one document to another (unlike importNode() which create a copy of the source node instead of moving it). When it fails, applications should use Document.importNode() instead. Note that if the adopted node is already part of this document (i.e. the source and target document are the same), this method still has the effect of removing the source node from the child list of its parent, if any. The following list describes the specifics for each type of node. ATTRIBUTE_NODE The ownerElement attribute is set to null and the specified flag is set to true on the adopted Attr. The descendants of the source Attr are recursively adopted. DOCUMENT_FRAGMENT_NODE The descendants of the source node are recursively adopted. DOCUMENT_NODE Document nodes cannot be adopted. DOCUMENT_TYPE_NODE DocumentType nodes cannot be adopted. ELEMENT_NODE Specified attribute nodes of the source element are adopted. Default attributes are discarded, though if the document being adopted into defines default attributes for this element name, those are assigned. The descendants of the source element are recursively adopted. ENTITY_NODE Entity nodes cannot be adopted. ENTITY_REFERENCE_NODE Only the EntityReference node itself is adopted, the descendants are discarded, since the source and destination documents might have defined the entity differently. If the document being imported into provides a definition for this entity name, its value is assigned. NOTATION_NODE Notation nodes cannot be adopted. PROCESSING_INSTRUCTION_NODE, TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODE These nodes can all be adopted. No specifics. Note: Since it does not create new nodes unlike the Document.importNode() method, this method does not raise an INVALID_CHARACTER_ERR exception, and applications should use the Document.normalizeDocument() method to check if an imported name is not an XML name according to the XML version in use.
 * @syntax document.adoptNode(source)
 * @param {Node} source The node to move into this document.
 * @returns {Node} The adopted node, or null if this operation fails, such as when the source node comes from a different implementation.
 */
Document.prototype.adoptNode = function(source) {};

/**
 * Rename an existing node of type ELEMENT_NODE or ATTRIBUTE_NODE. When possible this simply changes the name of the given node, otherwise this creates a new node with the specified name and replaces the existing node with the new node as described below. If simply changing the name of the given node is not possible, the following operations are performed: a new node is created, any registered event listener is registered on the new node, any user data attached to the old node is removed from that node, the old node is removed from its parent if it has one, the children are moved to the new node, if the renamed node is an Element its attributes are moved to the new node, the new node is inserted at the position the old node used to have in its parent's child nodes list if it has one, the user data that was attached to the old node is attached to the new node. When the node being renamed is an Element only the specified attributes are moved, default attributes originated from the DTD are updated according to the new element name. In addition, the implementation may update default attributes from other schemas. Applications should use Document.normalizeDocument() to guarantee these attributes are up-to-date. When the node being renamed is an Attr that is attached to an Element, the node is first removed from the Element attributes map. Then, once renamed, either by modifying the existing node or creating a new one as described above, it is put back. In addition, a user data event NODE_RENAMED is fired, when the implementation supports the feature "MutationNameEvents", each mutation operation involved in this method fires the appropriate event, and in the end the event {http://www.w3.org/2001/xml-events, DOMElementNameChanged} or {http://www.w3.org/2001/xml-events, DOMAttributeNameChanged} is fired.
 * @syntax document.renameNode(n, namespaceURI, qualifiedName)
 * @param {Node} n The node to rename.
 * @param {String} namespaceURI The new namespace URI.
 * @param {String} qualifiedName The new qualified name.
 * @returns {Node} The renamed node. This is either the specified node or the new node that was created to replace the specified node.
 */
Document.prototype.renameNode = function(n,  namespaceURI,  qualifiedName) {};

/**
 * Creates a Text node given the specified string
 * @syntax document.createTextNode(data)
 * @param {String} data The data for the node.
 * @returns {Text} The new Text object.
 */
Document.prototype.createTextNode = function(data) {};

/**
 * Creates an element of the given qualified name and namespace URI. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax document.createElementNS(namespaceURI, qualifiedName)
 * @param {String} namespaceURI The namespace URI of the element to create.
 * @param {String} qualifiedName The qualified name of the element type to instantiate.
 * @returns {Element} A new Element object with the following attributes: Attribute Value Node.nodeName qualifiedName Node.namespaceURI namespaceURI Node.prefix prefix, extracted from qualifiedName, or null if there is no prefix Node.localName local name, extracted from qualifiedName Element.tagName qualifiedName
 */
Document.prototype.createElementNS = function(namespaceURI,  qualifiedName) {};

/**
 * Creates an empty DocumentFragment object.
 * @syntax document.createDocumentFragment()
 * @returns {DocumentFragment} A new DocumentFragment.
 */
Document.prototype.createDocumentFragment = function() {};

/**
 * Creates an attribute of the given qualified name and namespace URI. Per [XML Namespaces], applications must use the value null as the namespaceURI parameter for methods if they wish to have no namespace
 * @syntax document.createAttributeNS(namespaceURI, qualifiedName)
 * @param {String} namespaceURI The namespace URI of the attribute to create.
 * @param {String} qualifiedName The qualified name of the attribute to instantiate.
 * @returns {Attr} A new Attr object with the following attributes: Attribute Value Node.nodeName qualifiedName Node.namespaceURI namespaceURI Node.prefix prefix, extracted from qualifiedName, or null if there is no prefix Node.localName local name, extracted from qualifiedName Attr.name qualifiedName Node.nodeValue the empty string
 */
Document.prototype.createAttributeNS = function(namespaceURI,  qualifiedName) {};

/**
 * Returns a NodeList of all the Elements in document order with a given tag name and are contained in the document
 * @syntax document.getElementsByTagName(tagname)
 * @param {String} tagname The name of the tag to match on. The special value "*" matches all tags. For XML, the tagname parameter is case-sensitive, otherwise it depends on the case-sensitivity of the markup language in use.
 * @returns {NodeList} A new NodeList object containing all the matched Elements.
 */
Document.prototype.getElementsByTagName = function(tagname) {};

/**
 * Creates an Attr of the given name. Note that the Attr instance can then be set on an Element using the setAttributeNode method. To create an attribute with a qualified name and namespace URI, use the createAttributeNS method.
 * @syntax document.createAttribute(name)
 * @param {String} name The name of the attribute.
 * @returns {Attr} A new Attr object with the nodeName attribute set to name, and localName, prefix, and namespaceURI set to null. The value of the attribute is the empty string.
 */
Document.prototype.createAttribute = function(name) {};

/**
 * This method acts as if the document was going through a save and load cycle, putting the document in a "normal" form. As a consequence, this method updates the replacement tree of EntityReference nodes and normalizes Text nodes, as defined in the method Node.normalize(). Otherwise, the actual result depends on the features being set on the Document.domConfig object and governing what operations actually take place. Noticeably this method could also make the document namespace well-formed according to the algorithm described in Namespace Normalization, check the character normalization, remove the CDATASection nodes, etc. See DOMConfiguration for details.
 * @syntax document.normalizeDocument()
 * @returns {undefined} 
 */
Document.prototype.normalizeDocument = function() {};

/**
 * The configuration used when Document.normalizeDocument() is invoked.
 * @syntax document.domConfig
 * @returns {DOMConfiguration} 
 */
Document.prototype.domConfig = new DOMConfiguration();

/**
 * An attribute specifying, as part of the XML declaration, whether this document is standalone. This is false when unspecified. Note: No verification is done on the value when setting this attribute. Applications should use Document.normalizeDocument() with the "validate" parameter to verify if the value matches the validity constraint for standalone document declaration as defined in [XML 1.0]. Exceptions on setting DOMException NOT_SUPPORTED_ERR: Raised if this document does not support the "XML" feature.
 * @syntax document.xmlStandalone
 * @returns {boolean} 
 */
Document.prototype.xmlStandalone = new boolean();

/**
 * An attribute specifying, as part of the XML declaration, the encoding of this document. This is null when unspecified or when it is not known, such as when the Document was created in memory.
 * @syntax document.xmlEncoding
 * @returns {String} 
 */
Document.prototype.xmlEncoding = new String();

/**
 * An attribute specifying whether error checking is enforced or not. When set to false, the implementation is free to not test every possible error case normally defined on DOM operations, and not raise any DOMException on DOM operations or report errors while using Document.normalizeDocument(). In case of error, the behavior is undefined. This attribute is true by default.
 * @syntax document.strictErrorChecking
 * @returns {boolean} 
 */
Document.prototype.strictErrorChecking = new boolean();

/**
 * This is a convenience attribute that allows direct access to the child node that is the document element of the document.
 * @syntax document.documentElement
 * @returns {Element} 
 */
Document.prototype.documentElement = new Element();

/**
 * Returns the Element that has an ID attribute with the given value. If no such element exists, this returns null. If more than one element has an ID attribute with that value, what is returned is undefined. The DOM implementation is expected to use the attribute Attr.isId to determine if an attribute is of type ID. Note: Attributes with the name "ID" or "id" are not of type ID unless so defined.
 * @syntax document.getElementById(elementId)
 * @param {String} elementId The unique id value for an element.
 * @returns {Element} The matching element or null if there is none.
 */
Document.prototype.getElementById = function(elementId) {};

/**
 * Creates an EntityReference object. In addition, if the referenced entity is known, the child list of the EntityReference node is made the same as that of the corresponding Entity node. Note: If any descendant of the Entity node has an unbound namespace prefix, the corresponding descendant of the created EntityReference node is also unbound; (its namespaceURI is null). The DOM Level 2 and 3 do not support any mechanism to resolve namespace prefixes in this case.
 * @syntax document.createEntityReference(name)
 * @param {String} name The name of the entity to reference. Unlike Document.createElementNS or Document.createAttributeNS, no namespace well-formed checking is done on the entity name. Applications should invoke Document.normalizeDocument() with the parameter "namespaces" set to true in order to ensure that the entity name is namespace well-formed.
 * @returns {EntityReference} The new EntityReference object.
 */
Document.prototype.createEntityReference = function(name) {};

/**
 * Returns a NodeList of all the Elements with a given local name and namespace URI in document order.
 * @syntax document.getElementsByTagNameNS(namespaceURI, localName)
 * @param {String} namespaceURI The namespace URI of the elements to match on. The special value "*" matches all namespaces.
 * @param {String} localName The local name of the elements to match on. The special value "*" matches all local names.
 * @returns {NodeList} A new NodeList object containing all the matched Elements.
 */
Document.prototype.getElementsByTagNameNS = function(namespaceURI,  localName) {};

/**
 * An attribute specifying the encoding used for this document at the time of the parsing. This is null when it is not known, such as when the Document was created in memory.
 * @syntax document.inputEncoding
 * @returns {String} 
 */
Document.prototype.inputEncoding = new String();

/**
 * An attribute specifying, as part of the XML declaration, the version number of this document. If there is no declaration and if this document supports the "XML" feature, the value is "1.0". If this document does not support the "XML" feature, the value is always null. Changing this attribute will affect methods that check for invalid characters in XML names. Application should invoke Document.normalizeDocument() in order to check for invalid characters in the Nodes that are already part of this Document. DOM applications may use the DOMImplementation.hasFeature(feature, version) method with parameter values "XMLVersion" and "1.0" (respectively) to determine if an implementation supports [XML 1.0]. DOM applications may use the same method with parameter values "XMLVersion" and "1.1" (respectively) to determine if an implementation supports [XML 1.1]. In both cases, in order to support XML, an implementation must also support the "XML" feature defined in this specification. Document objects supporting a version of the "XMLVersion" feature must not raise a NOT_SUPPORTED_ERR exception for the same version number when using Document.xmlVersion. Exceptions on setting DOMException NOT_SUPPORTED_ERR: Raised if the version is set to a value that is not supported by this Document or if this document does not support the "XML" feature.
 * @syntax document.xmlVersion
 * @returns {String} 
 */
Document.prototype.xmlVersion = new String();

/**
 * Creates a Comment node given the specified string
 * @syntax document.createComment(data)
 * @param {String} data The data for the node.
 * @returns {Comment} The new Comment object.
 */
Document.prototype.createComment = function(data) {};

/**
 * The location of the document or null if undefined or if the Document was created using DOMImplementation.createDocument. No lexical checking is performed when setting this attribute; this could result in a null value returned when using Node.baseURI. Beware that when the Document supports the feature "HTML" [DOM Level 2 HTML], the href attribute of the HTML BASE element takes precedence over this attribute when computing Node.baseURI.
 * @syntax document.documentURI
 * @returns {String} 
 */
Document.prototype.documentURI = new String();

/**
 * The DOMImplementation object that handles this document. A DOM application may use objects from multiple implementations.
 * @syntax document.implementation
 * @returns {DOMImplementation} 
 */
Document.prototype.implementation = new DOMImplementation();

/**
 * Create a new TreeWalker over the subtree rooted at the specified node.
 * @syntax documentTraversal.createTreeWalker(root, whatToShow, filter, entityReferenceExpansion)
 * @param {Node} root The node which will serve as the root for the TreeWalker. The whatToShow flags and the NodeFilter are not considered when setting this value; any node type will be accepted as the root. The currentNode of the TreeWalker is initialized to this node, whether or not it is visible. The root functions as a stopping point for traversal methods that look upward in the document structure, such as parentNode and nextNode. The root must not be null.
 * @param {Number} whatToShow This flag specifies which node types may appear in the logical view of the tree presented by the tree-walker. See the description of NodeFilter for the set of possible SHOW_ values. These flags can be combined using OR.
 * @param {NodeFilter} filter The NodeFilter to be used with this TreeWalker, or null to indicate no filter.
 * @param {boolean} entityReferenceExpansion If this flag is false, the contents of EntityReference nodes are not presented in the logical view.
 * @returns {TreeWalker} The newly created TreeWalker.
 */
Document.prototype.createTreeWalker = function(root,  whatToShow,  filter,  entityReferenceExpansion) {};

/**
 * The Document Type Declaration (see DocumentType) associated with this document. For XML documents without a document type declaration this returns null. For HTML documents, a DocumentType object may be returned, independently of the presence or absence of document type declaration in the HTML document. This provides direct access to the DocumentType node, child node of this Document. This node can be set at document creation time and later changed through the use of child nodes manipulation methods, such as Node.insertBefore, or Node.replaceChild. Note, however, that while some implementations may instantiate different types of Document objects supporting additional features than the "Core", such as "HTML" [DOM Level 2 HTML], based on the DocumentType specified at creation time, changing it afterwards is very unlikely to result in a change of the features supported.
 * @syntax document.doctype
 * @returns {DocumentType} 
 */
Document.prototype.doctype = new DocumentType();

/**
 * Creates a CDATASection node whose value is the specified string
 * @syntax document.createCDATASection(data)
 * @param {String} data The data for the CDATASection contents.
 * @returns {CDATASection} The new CDATASection object.
 */
Document.prototype.createCDATASection = function(data) {};

/**
 * Creates a ProcessingInstruction node given the specified name and data strings
 * @syntax document.createProcessingInstruction(target, data)
 * @param {String} target The target part of the processing instruction. Unlike Document.createElementNS or Document.createAttributeNS, no namespace well-formed checking is done on the target name. Applications should invoke Document.normalizeDocument() with the parameter "namespaces" set to true in order to ensure that the target name is namespace well-formed.
 * @param {String} data The data for the node.
 * @returns {ProcessingInstruction} The new ProcessingInstruction object.
 */
Document.prototype.createProcessingInstruction = function(target,  data) {};

/**
 * Creates an element of the type specified. Note that the instance returned implements the Element interface, so attributes can be specified directly on the returned object. In addition, if there are known attributes with default values, Attr nodes representing them are automatically created and attached to the element. To create an element with a qualified name and namespace URI, use the createElementNS method.
 * @syntax document.createElement(tagName)
 * @param {String} tagName The name of the element type to instantiate. For XML, this is case-sensitive, otherwise it depends on the case-sensitivity of the markup language in use. In that case, the name is mapped to the canonical form of that markup by the DOM implementation.
 * @returns {Element} A new Element object with the nodeName attribute set to tagName, and localName, prefix, and namespaceURI set to null.
 */
Document.prototype.createElement = function(tagName) {};

/**
 * Represents the Document prototype object.
 * @syntax Document.prototype
 * @static
 */
Document.prototype;

