/**
 * DOM operations only raise exceptions in "exceptional" circumstances, i.e., when an operation is impossible to perform (either for logical reasons, because data is lost, or because the implementation has become unstable). In general, DOM methods return specific error values in ordinary processing situations, such as out-of-bound errors when using NodeList.Implementations should raise other exceptions under other circumstances. For example, implementations should raise an implementation-dependent exception if a null argument is passed when null was not expected.Some languages and object systems do not support the concept of exceptions. For such systems, error conditions may be indicated using native error reporting mechanisms. For some bindings, for example, methods may return error codes similar to those listed in the corresponding method descriptions.
 */
var DOMException = {
}
/**
 * If the implementation does not support the requested type of object or operation.
 * @syntax DOMException.NOT_SUPPORTED_ERR
 * @returns {Number} 
 * @static
 */
DOMException.NOT_SUPPORTED_ERR = new Number();

/**
 * If an invalid or illegal character is specified, such as in an XML name.
 * @syntax DOMException.INVALID_CHARACTER_ERR
 * @returns {Number} 
 * @static
 */
DOMException.INVALID_CHARACTER_ERR = new Number();

/**
 * If an attempt is made to create or change an object in a way which is incorrect with regard to namespaces.
 * @syntax DOMException.NAMESPACE_ERR
 * @returns {Number} 
 * @static
 */
DOMException.NAMESPACE_ERR = new Number();

/**
 * If an attempt is made to modify the type of the underlying object.
 * @syntax DOMException.INVALID_MODIFICATION_ERR
 * @returns {Number} 
 * @static
 */
DOMException.INVALID_MODIFICATION_ERR = new Number();

/**
 * If a parameter or an operation is not supported by the underlying object.
 * @syntax DOMException.INVALID_ACCESS_ERR
 * @returns {Number} 
 * @static
 */
DOMException.INVALID_ACCESS_ERR = new Number();

/**
 * If an attempt is made to use an object that is not, or is no longer, usable.
 * @syntax DOMException.INVALID_STATE_ERR
 * @returns {Number} 
 * @static
 */
DOMException.INVALID_STATE_ERR = new Number();

/**
 * If an attempt is made to add an attribute that is already in use elsewhere.
 * @syntax DOMException.INUSE_ATTRIBUTE_ERR
 * @returns {Number} 
 * @static
 */
DOMException.INUSE_ATTRIBUTE_ERR = new Number();

/**
 * If an invalid or illegal string is specified.
 * @syntax DOMException.SYNTAX_ERR
 * @returns {Number} 
 * @static
 */
DOMException.SYNTAX_ERR = new Number();

/**
 * If the type of an object is incompatible with the expected type of the parameter associated to the object.
 * @syntax DOMException.TYPE_MISMATCH_ERR
 * @returns {Number} 
 * @static
 */
DOMException.TYPE_MISMATCH_ERR = new Number();

/**
 * If an attempt is made to reference a Node in a context where it does not exist.
 * @syntax DOMException.NOT_FOUND_ERR
 * @returns {Number} 
 * @static
 */
DOMException.NOT_FOUND_ERR = new Number();

/**
 * If any Node is inserted somewhere it doesn't belong.
 * @syntax DOMException.HIERARCHY_REQUEST_ERR
 * @returns {Number} 
 * @static
 */
DOMException.HIERARCHY_REQUEST_ERR = new Number();

/**
 * If a Node is used in a different document than the one that created it (that doesn't support it).
 * @syntax DOMException.WRONG_DOCUMENT_ERR
 * @returns {Number} 
 * @static
 */
DOMException.WRONG_DOCUMENT_ERR = new Number();

/**
 * If an attempt is made to modify an object where modifications are not allowed.
 * @syntax DOMException.NO_MODIFICATION_ALLOWED_ERR
 * @returns {Number} 
 * @static
 */
DOMException.NO_MODIFICATION_ALLOWED_ERR = new Number();

/**
 * If index or size is negative, or greater than the allowed value.
 * @syntax DOMException.INDEX_SIZE_ERR
 * @returns {Number} 
 * @static
 */
DOMException.INDEX_SIZE_ERR = new Number();

/**
 * If data is specified for a Node which does not support data.
 * @syntax DOMException.NO_DATA_ALLOWED_ERR
 * @returns {Number} 
 * @static
 */
DOMException.NO_DATA_ALLOWED_ERR = new Number();

/**
 * If the specified range of text does not fit into a DOMString.
 * @syntax DOMException.DOMSTRING_SIZE_ERR
 * @returns {Number} 
 * @static
 */
DOMException.DOMSTRING_SIZE_ERR = new Number();

/**
 * If a call to a method such as insertBefore or removeChild would make the Node invalid with respect to "partial validity", this exception would be raised and the operation would not be done. This code is used in [DOM Level 3 Validation]. Refer to this specification for further information.
 * @syntax DOMException.VALIDATION_ERR
 * @returns {Number} 
 * @static
 */
DOMException.VALIDATION_ERR = new Number();

/**
 * Represents the DOMException prototype object.
 * @syntax DOMException.prototype
 * @static
 */
DOMException.prototype;

