/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import java.util.Comparator;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.openide.filesystems.FileObject;

public class JsParserError
implements Error.Badging {
    public static final Comparator<JsParserError> POSITION_COMPARATOR = new Comparator<JsParserError>(){

        @Override
        public int compare(JsParserError o1, JsParserError o2) {
            if (o1.startPosition < o2.startPosition) {
                return -1;
            }
            if (o1.startPosition > o2.startPosition) {
                return 1;
            }
            return 0;
        }
    };
    private final String displayName;
    private final FileObject file;
    private final int startPosition;
    private final int endPosition;
    private final boolean wholeLine;
    private final Severity severity;
    private final Object[] parameters;

    public JsParserError(String displayName, FileObject file, int startPosition, int endPosition, Severity severity, Object[] parameters, boolean wholeLine) {
        this.displayName = displayName;
        this.file = file;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.severity = severity;
        this.parameters = parameters != null ? (Object[])parameters.clone() : new Object[]{};
        this.wholeLine = wholeLine;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return null;
    }

    public String getKey() {
        return "[" + this.startPosition + "," + this.endPosition + "]-" + this.displayName;
    }

    public FileObject getFile() {
        return this.file;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public boolean isLineError() {
        return this.wholeLine;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public boolean showExplorerBadge() {
        return true;
    }
}

