/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.ParserException;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.parser.JsParserError;
import org.netbeans.modules.parsing.api.Snapshot;

public class JsErrorManager
extends ErrorManager {
    private static final Logger LOGGER = Logger.getLogger(JsErrorManager.class.getName());
    private final Snapshot snapshot;
    private final Language<JsTokenId> language;
    private List<ParserError> parserErrors;
    private List<JsParserError> convertedErrors;

    public JsErrorManager(Snapshot snapshot, Language<JsTokenId> language) {
        this.snapshot = snapshot;
        this.language = language;
    }

    public Error getMissingCurlyError() {
        if (this.parserErrors == null) {
            return null;
        }
        for (ParserError error : this.parserErrors) {
            if (error.message == null || !error.message.contains("Expected }") && !error.message.contains("but found }")) continue;
            return this.convert(error);
        }
        return null;
    }

    public Error getMissingSemicolonError() {
        if (this.parserErrors == null) {
            return null;
        }
        for (ParserError error : this.parserErrors) {
            if (error.message == null || !error.message.contains("Expected ;")) continue;
            return this.convert(error);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.parserErrors == null;
    }

    public void error(ParserException e) {
        this.addParserError(new ParserError(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e.getToken()));
    }

    public void error(String message) {
        LOGGER.log(Level.FINE, "Error {0}", message);
        this.addParserError(new ParserError(message));
    }

    public void warning(ParserException e) {
        LOGGER.log(Level.FINE, null, (Throwable)e);
    }

    public void warning(String message) {
        LOGGER.log(Level.FINE, "Warning {0}", message);
    }

    public List<? extends Error> getErrors() {
        if (this.convertedErrors == null) {
            if (this.parserErrors == null) {
                this.convertedErrors = Collections.emptyList();
            } else {
                ArrayList<JsParserError> errors = new ArrayList<JsParserError>(this.parserErrors.size());
                for (ParserError error : this.parserErrors) {
                    errors.add(this.convert(error));
                }
                Collections.sort(errors, JsParserError.POSITION_COMPARATOR);
                this.convertedErrors = errors;
            }
        }
        return Collections.unmodifiableList(this.convertedErrors);
    }

    JsErrorManager fillErrors(JsErrorManager original) {
        assert (this.snapshot == original.snapshot) : this.snapshot + ":" + original.snapshot;
        assert (this.language == original.language) : this.language + ":" + original.language;
        this.parserErrors = original.parserErrors != null ? new ArrayList<ParserError>(original.parserErrors) : null;
        this.convertedErrors = null;
        return this;
    }

    private void addParserError(ParserError error) {
        this.convertedErrors = null;
        if (this.parserErrors == null) {
            this.parserErrors = new ArrayList<ParserError>();
        }
        this.parserErrors.add(error);
    }

    private JsParserError convert(ParserError error) {
        String message = error.message;
        int offset = -1;
        if (error.token > 0L) {
            offset = Token.descPosition((long)error.token);
            if (Token.descType((long)error.token) == TokenType.EOF && this.snapshot.getOriginalOffset(offset) == -1) {
                int realOffset = -1;
                TokenSequence<? extends JsTokenId> ts = LexUtilities.getPositionedSequence(this.snapshot, offset, this.language);
                while (ts.movePrevious()) {
                    if (this.snapshot.getOriginalOffset(ts.offset()) <= 0) continue;
                    realOffset = ts.offset() + ts.token().length() - 1;
                    break;
                }
                if (realOffset > 0) {
                    offset = realOffset;
                }
            }
        } else if (error.line == -1 && error.column == -1) {
            int index;
            String[] parts = error.message.split(":");
            if (parts.length > 4 && (index = (message = parts[4]).indexOf(10)) > 0) {
                message = message.substring(0, index);
            }
            if (parts.length > 3) {
                try {
                    offset = Integer.parseInt(parts[3]);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        return new JsParserError(message, this.snapshot != null ? this.snapshot.getSource().getFileObject() : null, offset, offset, Severity.ERROR, null, true);
    }

    private static class ParserError {
        protected final String message;
        protected final int line;
        protected final int column;
        protected final long token;

        public ParserError(String message, int line, int column, long token) {
            this.message = message;
            this.line = line;
            this.column = column;
            this.token = token;
        }

        public ParserError(String message, long token) {
            this(message, -1, -1, token);
        }

        public ParserError(String message) {
            this(message, -1, -1, -1L);
        }
    }
}

