/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.index.JsIndex;
import org.netbeans.modules.javascript2.editor.jquery.JQueryDeclarationFinder;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.OccurrencesSupport;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;

public class DeclarationFinderImpl
implements DeclarationFinder {
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        JsParserResult jsResult = (JsParserResult)info;
        Model model = jsResult.getModel();
        OccurrencesSupport os = model.getOccurrencesSupport();
        Occurrence occurrence = os.getOccurrence(caretOffset);
        if (occurrence != null) {
            Collection<? extends TypeUsage> assignments;
            JsObject object = occurrence.getDeclarations().iterator().next();
            JsObject parent = object.getParent();
            Collection<? extends TypeUsage> collection = assignments = parent == null ? null : parent.getAssignmentForOffset(caretOffset);
            if (assignments != null && assignments.isEmpty()) {
                assignments = parent.getAssignments();
            }
            Snapshot snapshot = jsResult.getSnapshot();
            JsIndex jsIndex = JsIndex.get(snapshot.getSource().getFileObject());
            ArrayList<IndexResult> indexResults = new ArrayList<IndexResult>();
            if (assignments == null || assignments.isEmpty()) {
                if (object.isDeclared()) {
                    FileObject fo = object.getFileObject();
                    if (fo != null) {
                        return new DeclarationFinder.DeclarationLocation(fo, object.getDeclarationName().getOffsetRange().getStart());
                    }
                } else {
                    Collection<? extends IndexResult> items = jsIndex.query("fqn", ModelUtils.createFQN(object), QuerySupport.Kind.EXACT, JsIndex.TERMS_BASIC_INFO);
                    indexResults.addAll(items);
                    DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
                    if (location != null) {
                        return location;
                    }
                }
            } else {
                TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(snapshot, caretOffset);
                if (ts != null) {
                    ts.move(snapshot.getEmbeddedOffset(caretOffset));
                    if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                        String propertyName = ((Object)ts.token().text()).toString();
                        for (TypeUsage typeUsage : assignments) {
                            Collection<? extends IndexResult> items = jsIndex.query("fqn", typeUsage.getType() + "." + propertyName, QuerySupport.Kind.EXACT, JsIndex.TERMS_BASIC_INFO);
                            if (items.isEmpty()) {
                                items = jsIndex.query("fqn", typeUsage.getType() + ".prototype." + propertyName, QuerySupport.Kind.EXACT, JsIndex.TERMS_BASIC_INFO);
                            }
                            indexResults.addAll(items);
                        }
                        DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
                        if (location != null) {
                            return location;
                        }
                    }
                }
            }
        }
        JQueryDeclarationFinder jQueryFinder = new JQueryDeclarationFinder();
        return jQueryFinder.findDeclaration(info, caretOffset);
    }

    private DeclarationFinder.DeclarationLocation processIndexResult(List<IndexResult> indexResults) {
        if (!indexResults.isEmpty()) {
            IndexResult iResult = indexResults.get(0);
            String value = iResult.getValue("offset");
            int offset = Integer.parseInt(value);
            DeclarationFinder.DeclarationLocation location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), offset, (ElementHandle)IndexedElement.create(iResult));
            if (indexResults.size() > 1) {
                for (int i = 0; i < indexResults.size(); ++i) {
                    iResult = indexResults.get(i);
                    location.addAlternative((DeclarationFinder.AlternativeLocation)new AlternativeLocationImpl(iResult));
                }
            }
            return location;
        }
        return null;
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        OffsetRange result = OffsetRange.NONE;
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(doc, caretOffset);
        if (ts != null) {
            ts.move(caretOffset);
            if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                result = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
            }
        }
        if (result == null) {
            JQueryDeclarationFinder jQueryFinder = new JQueryDeclarationFinder();
            result = jQueryFinder.getReferenceSpan(doc, caretOffset);
        }
        return result;
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final IndexResult iResult;
        private final int offset;
        private final DeclarationFinder.DeclarationLocation location;
        private final IndexedElement element;

        public AlternativeLocationImpl(IndexResult iResult) {
            this.iResult = iResult;
            String value = iResult.getValue("offset");
            this.offset = Integer.parseInt(value);
            this.location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), this.offset);
            this.element = IndexedElement.create(iResult);
        }

        public ElementHandle getElement() {
            return this.element;
        }

        private String getStringLocation() {
            return this.iResult.getRelativePath() + " : " + this.offset;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            formatter.appendText(this.getStringLocation());
            return formatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            AlternativeLocationImpl ali = (AlternativeLocationImpl)o;
            return this.getStringLocation().compareTo(ali.getStringLocation());
        }
    }
}

