/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.doc.DocumentationUtils;
import org.netbeans.modules.javascript2.editor.doc.spi.DocIdentifier;
import org.netbeans.modules.javascript2.editor.doc.spi.DocParameter;
import org.netbeans.modules.javascript2.editor.doc.spi.JsComment;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.editor.embedding.JsEmbeddingProvider;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.CatchBlockImpl;
import org.netbeans.modules.javascript2.editor.model.impl.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.editor.model.impl.IdentifierImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsFunctionImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;
import org.netbeans.modules.javascript2.editor.model.impl.ModelBuilder;
import org.netbeans.modules.javascript2.editor.model.impl.ModelElementFactory;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.PathNodeVisitor;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.openide.filesystems.FileObject;

public class ModelVisitor
extends PathNodeVisitor {
    private final ModelBuilder modelBuilder;
    private final List<List<FunctionNode>> functionStack;
    private final JsParserResult parserResult;
    private JsObjectImpl fromAN = null;
    private boolean inVarNode = false;

    public ModelVisitor(JsParserResult parserResult) {
        FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        this.modelBuilder = new ModelBuilder(JsFunctionImpl.createGlobal(fileObject, Integer.MAX_VALUE));
        this.functionStack = new ArrayList<List<FunctionNode>>();
        this.parserResult = parserResult;
    }

    public JsObject getGlobalObject() {
        return this.modelBuilder.getGlobal();
    }

    @Override
    public Node enter(AccessNode accessNode) {
        BinaryNode node;
        BinaryNode binaryNode = node = this.getPath().get(this.getPath().size() - 1) instanceof BinaryNode ? (BinaryNode)this.getPath().get(this.getPath().size() - 1) : null;
        if ((node == null || node.tokenType() != TokenType.ASSIGN) && accessNode.getBase() instanceof IdentNode && "this".equals(((IdentNode)accessNode.getBase()).getName())) {
            IdentNode iNode = accessNode.getProperty();
            JsObject current = this.modelBuilder.getCurrentDeclarationFunction();
            JsObject property = current.getProperty(iNode.getName());
            if (property == null && current.getParent() != null && (current.getParent().getJSKind() == JsElement.Kind.CONSTRUCTOR || current.getParent().getJSKind() == JsElement.Kind.OBJECT)) {
                if ((current = current.getParent()).getName().equals("prototype")) {
                    current = current.getParent();
                }
                property = current.getProperty(iNode.getName());
            }
            if (property == null && current.getParent() == null) {
                property = this.modelBuilder.getGlobal().getProperty(iNode.getName());
            }
            if (property != null) {
                ((JsObjectImpl)property).addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, iNode.getStart(), iNode.getFinish()));
            }
        }
        return super.enter(accessNode);
    }

    @Override
    public Node leave(AccessNode accessNode) {
        if (accessNode.getBase() instanceof IdentNode) {
            IdentNode base = (IdentNode)accessNode.getBase();
            if (!"this".equals(base.getName())) {
                IdentifierImpl name = ModelElementFactory.create(this.parserResult, (IdentNode)accessNode.getBase());
                if (name != null) {
                    ArrayList<Identifier> fqname = new ArrayList<Identifier>();
                    fqname.add(name);
                    Collection<? extends JsObject> variables = ModelUtils.getVariables(this.modelBuilder.getCurrentDeclarationFunction());
                    this.fromAN = null;
                    for (JsObject jsObject : variables) {
                        if (!jsObject.getName().equals(name.getName())) continue;
                        this.fromAN = (JsObjectImpl)jsObject;
                        break;
                    }
                    if (this.fromAN == null) {
                        this.fromAN = ModelUtils.getJsObject(this.modelBuilder, fqname, false);
                    }
                    this.fromAN.addOccurrence(name.getOffsetRange());
                }
            } else {
                Node previous;
                JsObject current = this.modelBuilder.getCurrentDeclarationFunction();
                JsObject property = current.getProperty(accessNode.getProperty().getName());
                if (!(property != null || current.getParent() == null || current.getParent().getJSKind() != JsElement.Kind.CONSTRUCTOR && current.getParent().getJSKind() != JsElement.Kind.OBJECT && current.getParent().getJSKind() != JsElement.Kind.OBJECT_LITERAL || (previous = this.getPreviousFromPath(2)) instanceof BinaryNode && ((BinaryNode)previous).rhs() instanceof ReferenceNode || !(current = current.getParent()).getName().equals("prototype"))) {
                    current = current.getParent();
                }
                this.fromAN = (JsObjectImpl)current;
            }
        }
        if (this.fromAN != null) {
            boolean onLeftSite;
            JsObjectImpl property = (JsObjectImpl)this.fromAN.getProperty(accessNode.getProperty().getName());
            int pathSize = this.getPath().size();
            Node lastVisited = this.getPath().get(pathSize - 2);
            boolean bl = onLeftSite = lastVisited instanceof BinaryNode && ((BinaryNode)lastVisited).lhs().equals((Object)accessNode);
            if (property != null) {
                if (onLeftSite && !property.isDeclared()) {
                    property.setDeclared(true);
                }
                property.addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, accessNode.getProperty().getStart(), accessNode.getProperty().getFinish()));
            } else {
                IdentifierImpl name = ModelElementFactory.create(this.parserResult, accessNode.getProperty());
                if (name != null) {
                    if (pathSize > 1 && this.getPath().get(pathSize - 2) instanceof CallNode) {
                        CallNode callNode = (CallNode)this.getPath().get(pathSize - 2);
                        if (!callNode.getArgs().contains(accessNode)) {
                            property = ModelElementFactory.createVirtualFunction(this.parserResult, this.fromAN, name, callNode.getArgs().size());
                        } else {
                            property = new JsObjectImpl(this.fromAN, name, name.getOffsetRange(), onLeftSite);
                            property.addOccurrence(name.getOffsetRange());
                        }
                    } else {
                        property = new JsObjectImpl(this.fromAN, name, name.getOffsetRange(), onLeftSite);
                        property.addOccurrence(name.getOffsetRange());
                    }
                    this.fromAN.addProperty(name.getName(), property);
                }
            }
            if (property != null) {
                this.fromAN = property;
            }
        }
        if (!(this.getPath().get(this.getPath().size() - 1) instanceof AccessNode)) {
            this.fromAN = null;
        }
        return super.leave(accessNode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Node enter(BinaryNode binaryNode) {
        if (binaryNode.tokenType() == TokenType.ASSIGN && !(binaryNode.rhs() instanceof ReferenceNode) && !(binaryNode.rhs() instanceof ObjectNode) && (binaryNode.lhs() instanceof AccessNode || binaryNode.lhs() instanceof IdentNode)) {
            JsObjectImpl parent = this.modelBuilder.getCurrentDeclarationFunction();
            if (binaryNode.lhs() instanceof AccessNode) {
                AccessNode aNode = (AccessNode)binaryNode.lhs();
                JsObjectImpl property = null;
                if (aNode.getBase() instanceof IdentNode && "this".equals(((IdentNode)aNode.getBase()).getName())) {
                    IdentifierImpl identifier;
                    String fieldName = aNode.getProperty().getName();
                    if (!ModelUtils.isGlobal(parent) && !ModelUtils.isGlobal(parent.getParent()) && (parent.getParent() instanceof JsFunctionImpl || this.isInPropertyNode() || parent instanceof JsFunctionImpl)) {
                        if (this.isInPropertyNode() || !(parent.getParent() instanceof JsFunction) || parent instanceof JsFunctionImpl && !parent.getModifiers().contains(Modifier.PRIVATE)) {
                            parent = (JsObjectImpl)parent.getParent();
                        }
                        if ("prototype".equals(parent.getName())) {
                            parent = (JsObjectImpl)parent.getParent();
                        }
                    }
                    if ((property = (JsObjectImpl)parent.getProperty(fieldName)) == null && (identifier = ModelElementFactory.create(this.parserResult, aNode.getProperty())) != null) {
                        property = new JsObjectImpl(parent, identifier, identifier.getOffsetRange(), true);
                        parent.addProperty(fieldName, property);
                        JsDocumentationHolder docHolder = this.parserResult.getDocumentationHolder();
                        if (docHolder != null) {
                            property.setDocumentation(docHolder.getDocumentation((Node)aNode));
                            property.setDeprecated(docHolder.isDeprecated((Node)aNode));
                        }
                    }
                } else {
                    List<Identifier> fqName = this.getName(aNode);
                    if (fqName != null && (property = ModelUtils.getJsObject(this.modelBuilder, fqName, true)).getParent().getJSKind().isFunction() && !property.getModifiers().contains(Modifier.STATIC)) {
                        property.getModifiers().add(Modifier.STATIC);
                    }
                }
                if (property != null) {
                    Collection<Object> types;
                    String parameter = null;
                    if (binaryNode.rhs() instanceof IdentNode) {
                        IdentNode rhs = (IdentNode)binaryNode.rhs();
                        JsFunctionImpl function = this.modelBuilder.getCurrentDeclarationFunction();
                        if (function.getParameter(rhs.getName()) != null) {
                            parameter = "@param;" + ModelUtils.createFQN(function) + ":" + rhs.getName();
                        }
                    }
                    if (parameter == null) {
                        types = ModelUtils.resolveSemiTypeOfExpression(this.parserResult, binaryNode.rhs());
                    } else {
                        types = new ArrayList<TypeUsageImpl>();
                        types.add(new TypeUsageImpl(parameter, LexUtilities.getLexerOffset(this.parserResult, binaryNode.rhs().getStart()), false));
                    }
                    for (TypeUsage typeUsage : types) {
                        property.addAssignment(typeUsage, LexUtilities.getLexerOffset(this.parserResult, binaryNode.getStart() + 5));
                    }
                }
            } else {
                IdentNode ident = (IdentNode)binaryNode.lhs();
                IdentifierImpl name = ModelElementFactory.create(this.parserResult, ident);
                if (name != null) {
                    String newVarName = name.getName();
                    boolean hasParent = parent.getProperty(newVarName) != null;
                    boolean hasGrandParent = parent.getJSKind() == JsElement.Kind.METHOD && parent.getParent().getProperty(newVarName) != null;
                    Object var8_14 = null;
                    if (!hasParent && !hasGrandParent && this.modelBuilder.getGlobal().getProperty(newVarName) == null) {
                        this.addOccurence(ident, true);
                    } else {
                        JsObject jsObject;
                        JsObject jsObject2 = hasParent ? parent.getProperty(newVarName) : (jsObject = hasGrandParent ? parent.getParent().getProperty(newVarName) : null);
                        if (jsObject != null) {
                            ((JsObjectImpl)jsObject).addOccurrence(name.getOffsetRange());
                            if (binaryNode.rhs() instanceof UnaryNode && Token.descType((long)binaryNode.rhs().getToken()) == TokenType.NEW) {
                                this.modelBuilder.setCurrentObject((JsObjectImpl)jsObject);
                                binaryNode.rhs().accept((NodeVisitor)this);
                                this.modelBuilder.reset();
                                return null;
                            }
                        } else {
                            this.addOccurence(ident, true);
                        }
                    }
                    JsObjectImpl jsObject = (JsObjectImpl)parent.getProperty(newVarName);
                    if (jsObject == null) {
                        Model model = this.parserResult.getModel();
                        Collection<? extends JsObject> variables = model.getVariables(name.getOffsetRange().getStart());
                        for (JsObject jsObject3 : variables) {
                            if (!jsObject3.getName().equals(newVarName)) continue;
                            jsObject = (JsObjectImpl)jsObject3;
                            break;
                        }
                        if (jsObject == null) {
                            jsObject = new JsObjectImpl(model.getGlobalObject(), name, name.getOffsetRange(), false);
                        }
                    }
                    if (jsObject != null) {
                        void var8_16;
                        Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.parserResult, binaryNode.rhs());
                        for (TypeUsage type : types) {
                            jsObject.addAssignment(type, LexUtilities.getLexerOffset(this.parserResult, binaryNode.lhs().getFinish()));
                        }
                        if (var8_16 == null || !jsObject.getName().equals(var8_16.getName())) {
                            this.addOccurence(ident, true);
                        }
                    }
                }
            }
            if (binaryNode.rhs() instanceof IdentNode) {
                this.addOccurence((IdentNode)binaryNode.rhs(), false);
            }
        } else if (binaryNode.tokenType() != TokenType.ASSIGN || binaryNode.tokenType() == TokenType.ASSIGN && binaryNode.lhs() instanceof IndexNode) {
            if (binaryNode.lhs() instanceof IdentNode) {
                this.addOccurence((IdentNode)binaryNode.lhs(), true);
            }
            if (binaryNode.rhs() instanceof IdentNode) {
                this.addOccurence((IdentNode)binaryNode.rhs(), false);
            }
        }
        return super.enter(binaryNode);
    }

    @Override
    public Node enter(CallNode callNode) {
        if (callNode.getFunction() instanceof IdentNode) {
            IdentNode iNode = (IdentNode)callNode.getFunction();
            this.addOccurence(iNode, false, true, callNode.getArgs().size());
        }
        for (Node argument : callNode.getArgs()) {
            if (!(argument instanceof IdentNode)) continue;
            this.addOccurence((IdentNode)argument, false);
        }
        return super.enter(callNode);
    }

    @Override
    public Node enter(CatchNode catchNode) {
        IdentifierImpl exception = ModelElementFactory.create(this.parserResult, catchNode.getException());
        if (exception != null) {
            DeclarationScopeImpl inScope = this.modelBuilder.getCurrentDeclarationScope();
            CatchBlockImpl catchBlock = new CatchBlockImpl(inScope, (Identifier)exception, ModelUtils.documentOffsetRange(this.parserResult, catchNode.getStart(), catchNode.getFinish()));
            inScope.addDeclaredScope(catchBlock);
            this.modelBuilder.setCurrentObject(catchBlock);
        }
        return super.enter(catchNode);
    }

    @Override
    public Node leave(CatchNode catchNode) {
        if (!JsEmbeddingProvider.containsGeneratedIdentifier(catchNode.getException().getName())) {
            this.modelBuilder.reset();
        }
        return super.leave(catchNode);
    }

    @Override
    public Node enter(IdentNode identNode) {
        Node previousVisited = this.getPath().get(this.getPath().size() - 1);
        if (!(previousVisited instanceof AccessNode || previousVisited instanceof VarNode || previousVisited instanceof BinaryNode || previousVisited instanceof PropertyNode || previousVisited instanceof CatchNode)) {
            this.addOccurence(identNode, false);
        }
        return super.enter(identNode);
    }

    @Override
    public Node leave(IndexNode indexNode) {
        if (indexNode.getIndex() instanceof LiteralNode) {
            LiteralNode literal;
            JsObject property;
            Node base = indexNode.getBase();
            JsObjectImpl parent = null;
            if (base instanceof AccessNode) {
                parent = this.fromAN;
            } else if (base instanceof IdentNode) {
                IdentNode iNode = (IdentNode)base;
                if (!"this".equals(iNode.getName())) {
                    IdentifierImpl parentName = ModelElementFactory.create(this.parserResult, iNode);
                    if (parentName != null) {
                        ArrayList<Identifier> fqName = new ArrayList<Identifier>();
                        fqName.add(parentName);
                        parent = ModelUtils.getJsObject(this.modelBuilder, fqName, false);
                        parent.addOccurrence(parentName.getOffsetRange());
                    }
                } else {
                    Node previous;
                    JsObject current = this.modelBuilder.getCurrentDeclarationFunction();
                    property = current.getProperty(iNode.getName());
                    if (!(property != null || current.getParent() == null || current.getParent().getJSKind() != JsElement.Kind.CONSTRUCTOR && current.getParent().getJSKind() != JsElement.Kind.OBJECT && current.getParent().getJSKind() != JsElement.Kind.OBJECT_LITERAL || (previous = this.getPreviousFromPath(2)) instanceof BinaryNode && ((BinaryNode)previous).rhs() instanceof ReferenceNode || !(current = current.getParent()).getName().equals("prototype"))) {
                        current = current.getParent();
                    }
                    this.fromAN = (JsObjectImpl)current;
                }
            }
            if (parent != null && indexNode.getIndex() instanceof LiteralNode && (literal = (LiteralNode)indexNode.getIndex()).isString()) {
                String index = literal.getPropertyName();
                property = (JsObjectImpl)parent.getProperty(index);
                if (property != null) {
                    ((JsObjectImpl)property).addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, indexNode.getIndex().getStart(), indexNode.getIndex().getFinish()));
                } else {
                    IdentifierImpl name = ModelElementFactory.create(this.parserResult, (LiteralNode)indexNode.getIndex());
                    property = new JsObjectImpl(parent, name, name.getOffsetRange());
                    parent.addProperty(name.getName(), property);
                }
            }
        }
        return super.leave(indexNode);
    }

    @Override
    public Node enter(FunctionNode functionNode) {
        this.addToPath((Node)functionNode);
        ArrayList<FunctionNode> functions = new ArrayList<FunctionNode>(functionNode.getFunctions().size());
        for (FunctionNode fn : functionNode.getFunctions()) {
            functions.add(fn);
        }
        List<Identifier> name = null;
        boolean isPrivate = false;
        boolean isStatic = false;
        boolean isPrivilage = false;
        int pathSize = this.getPath().size();
        if (pathSize > 1 && this.getPath().get(pathSize - 2) instanceof ReferenceNode) {
            List<FunctionNode> siblings = this.functionStack.get(this.functionStack.size() - 1);
            siblings.remove(functionNode);
            if (pathSize > 3) {
                Node node = this.getPath().get(pathSize - 3);
                if (node instanceof PropertyNode) {
                    name = this.getName((PropertyNode)node);
                } else if (node instanceof BinaryNode) {
                    IdentNode iNode;
                    AccessNode aNode;
                    BinaryNode bNode = (BinaryNode)node;
                    if (bNode.lhs() instanceof AccessNode && (aNode = (AccessNode)bNode.lhs()).getBase() instanceof IdentNode && "this".equals((iNode = (IdentNode)aNode.getBase()).getName())) {
                        isPrivilage = true;
                    }
                    name = this.getName((BinaryNode)node);
                } else if (node instanceof VarNode) {
                    name = this.getName((VarNode)node);
                    boolean bl = isPrivate = this.functionStack.size() > 1;
                }
            }
        }
        if (name == null || name.isEmpty()) {
            name = new ArrayList<Identifier>(1);
            int start = functionNode.getIdent().getStart();
            int end = functionNode.getIdent().getFinish();
            if (end == 0) {
                end = this.parserResult.getSnapshot().getText().length();
            }
            name.add(new IdentifierImpl(functionNode.getIdent().getName(), ModelUtils.documentOffsetRange(this.parserResult, start, end)));
            if (pathSize > 2 && this.getPath().get(pathSize - 2) instanceof FunctionNode) {
                isPrivate = true;
            }
        }
        this.functionStack.add(functions);
        JsFunctionImpl fncScope = this.modelBuilder.getCurrentDeclarationFunction();
        if (functionNode.getKind() != FunctionNode.Kind.SCRIPT) {
            JsFunctionImpl scope = this.modelBuilder.getCurrentDeclarationFunction();
            boolean isAnonymous = false;
            if (this.getPreviousFromPath(2) instanceof ReferenceNode) {
                String methodName;
                Node node = this.getPreviousFromPath(3);
                if (node instanceof CallNode) {
                    isAnonymous = true;
                } else if (node instanceof AccessNode && this.getPreviousFromPath(4) instanceof CallNode && ("call".equals(methodName = ((AccessNode)node).getProperty().getName()) || "apply".equals(methodName))) {
                    isAnonymous = true;
                }
            }
            if ((fncScope = ModelElementFactory.create(this.parserResult, functionNode, name, this.modelBuilder, isAnonymous)) != null) {
                Set<Modifier> modifiers = fncScope.getModifiers();
                if (isPrivate || isPrivilage) {
                    modifiers.remove(Modifier.PUBLIC);
                    if (isPrivate) {
                        modifiers.add(Modifier.PRIVATE);
                    } else {
                        modifiers.add(Modifier.PROTECTED);
                    }
                }
                if (isStatic) {
                    modifiers.add(Modifier.STATIC);
                }
                scope.addDeclaredScope(fncScope);
                this.modelBuilder.setCurrentObject(fncScope);
            }
        }
        JsDocumentationHolder docHolder = this.parserResult.getDocumentationHolder();
        for (VarNode varNode : functionNode.getDeclarations()) {
            IdentifierImpl varName = new IdentifierImpl(varNode.getName().getName(), ModelUtils.documentOffsetRange(this.parserResult, varNode.getName().getStart(), varNode.getName().getFinish()));
            OffsetRange range = varNode.getInit() instanceof ObjectNode ? ModelUtils.documentOffsetRange(this.parserResult, varNode.getName().getStart(), ((ObjectNode)varNode.getInit()).getFinish()) : varName.getOffsetRange();
            JsObjectImpl variable = new JsObjectImpl(fncScope, varName, range);
            variable.setDeclared(true);
            if (functionNode.getKind() != FunctionNode.Kind.SCRIPT) {
                variable.getModifiers().remove(Modifier.PUBLIC);
                variable.getModifiers().add(Modifier.PRIVATE);
            }
            variable.addOccurrence(varName.getOffsetRange());
            this.modelBuilder.getCurrentObject().addProperty(varName.getName(), variable);
            if (docHolder == null) continue;
            variable.setDocumentation(docHolder.getDocumentation((Node)varNode));
            variable.setDeprecated(docHolder.isDeprecated((Node)varNode));
        }
        for (FunctionNode fn : functions) {
            String functionName;
            if (fn.getIdent().getStart() >= fn.getIdent().getFinish() || (functionName = fn.getIdent().getName()).startsWith("get ") || functionName.startsWith("set ")) continue;
            fn.accept((NodeVisitor)this);
        }
        for (Node node : functionNode.getStatements()) {
            node.accept((NodeVisitor)this);
        }
        if (fncScope != null) {
            fncScope.setDeprecated(docHolder.isDeprecated((Node)functionNode));
            List<Type> types = docHolder.getReturnType((Node)functionNode);
            if (types != null && !types.isEmpty()) {
                for (Type type : types) {
                    fncScope.addReturnType(new TypeUsageImpl(type.getType(), type.getOffset(), true));
                }
            }
            if (fncScope.areReturnTypesEmpty()) {
                fncScope.addReturnType(new TypeUsageImpl("undefined", -1, false));
            }
            List<DocParameter> docParams = docHolder.getParameters((Node)functionNode);
            for (DocParameter docParameter : docParams) {
                JsObjectImpl param;
                String sParamName;
                DocIdentifier paramName = docParameter.getParamName();
                if (paramName == null || (sParamName = paramName.getName()) == null || sParamName.isEmpty() || (param = (JsObjectImpl)fncScope.getParameter(sParamName)) == null) continue;
                for (Type type : docParameter.getParamTypes()) {
                    param.addAssignment(new TypeUsageImpl(type.getType(), type.getOffset(), true), param.getOffset());
                }
                this.addDocNameOccurence(param);
            }
            if (functionNode.getKind() != FunctionNode.Kind.SCRIPT && docHolder.isClass((Node)functionNode)) {
                fncScope.setJsKind(JsElement.Kind.CONSTRUCTOR);
            }
        }
        for (FunctionNode fn : functions) {
            if (fn.getIdent().getStart() < fn.getIdent().getFinish()) continue;
            fn.accept((NodeVisitor)this);
        }
        if (fncScope != null && functionNode.getKind() != FunctionNode.Kind.SCRIPT) {
            this.modelBuilder.reset();
        }
        this.functionStack.remove(this.functionStack.size() - 1);
        this.removeFromPathTheLast();
        return null;
    }

    @Override
    public Node enter(ObjectNode objectNode) {
        Node previousVisited = this.getPath().get(this.getPath().size() - 1);
        if (previousVisited instanceof CallNode || previousVisited instanceof LiteralNode.ArrayLiteralNode) {
            JsObjectImpl object = ModelElementFactory.createAnonymousObject(this.parserResult, objectNode, this.modelBuilder);
            this.modelBuilder.setCurrentObject(object);
            object.setJsKind(JsElement.Kind.OBJECT_LITERAL);
            return super.enter(objectNode);
        }
        if (previousVisited instanceof ReturnNode) {
            JsObjectImpl objectScope = ModelElementFactory.createAnonymousObject(this.parserResult, objectNode, this.modelBuilder);
            this.modelBuilder.setCurrentObject(objectScope);
            objectScope.setJsKind(JsElement.Kind.OBJECT_LITERAL);
        } else {
            JsObjectImpl objectScope;
            List<Identifier> fqName = null;
            int pathSize = this.getPath().size();
            boolean isDeclaredInParent = false;
            boolean isPrivate = false;
            boolean treatAsAnonymous = false;
            Node lastVisited = this.getPath().get(pathSize - 1);
            VarNode varNode = null;
            if (lastVisited instanceof VarNode) {
                fqName = this.getName((VarNode)lastVisited);
                isDeclaredInParent = true;
                JsFunctionImpl declarationScope = this.modelBuilder.getCurrentDeclarationFunction();
                varNode = (VarNode)lastVisited;
                if (fqName.size() == 1 && !ModelUtils.isGlobal(declarationScope)) {
                    isPrivate = true;
                }
            } else if (lastVisited instanceof PropertyNode) {
                fqName = this.getName((PropertyNode)lastVisited);
                isDeclaredInParent = true;
            } else if (lastVisited instanceof BinaryNode) {
                Node index;
                BinaryNode binNode = (BinaryNode)lastVisited;
                if (!(!(binNode.lhs() instanceof IndexNode) || (index = ((IndexNode)binNode.lhs()).getIndex()) instanceof LiteralNode && ((LiteralNode)index).isString())) {
                    treatAsAnonymous = true;
                }
                if (!treatAsAnonymous) {
                    if (this.getPath().size() > 1 && (lastVisited = this.getPath().get(this.getPath().size() - 2)) instanceof VarNode) {
                        varNode = (VarNode)lastVisited;
                    }
                    fqName = this.getName(binNode);
                    if (binNode.lhs() instanceof IdentNode || binNode.lhs() instanceof AccessNode && ((AccessNode)binNode.lhs()).getBase() instanceof IdentNode && ((IdentNode)((AccessNode)binNode.lhs()).getBase()).getName().equals("this")) {
                        isDeclaredInParent = true;
                    }
                }
            }
            if (!treatAsAnonymous) {
                if (fqName == null || fqName.isEmpty()) {
                    fqName = new ArrayList<Identifier>(1);
                    fqName.add(new IdentifierImpl("UNKNOWN", ModelUtils.documentOffsetRange(this.parserResult, objectNode.getStart(), objectNode.getFinish())));
                }
                if (varNode != null) {
                    objectScope = this.modelBuilder.getCurrentObject();
                } else {
                    JsObject alreadyThere = ModelUtils.getJsObjectByName(this.modelBuilder.getCurrentDeclarationFunction(), fqName.get(fqName.size() - 1).getName());
                    objectScope = ModelElementFactory.create(this.parserResult, objectNode, fqName, this.modelBuilder, isDeclaredInParent);
                    if (alreadyThere != null && objectScope != null) {
                        for (Occurrence occurrence : alreadyThere.getOccurrences()) {
                            objectScope.addOccurrence(occurrence.getOffsetRange());
                        }
                    }
                }
                if (objectScope != null) {
                    objectScope.setJsKind(JsElement.Kind.OBJECT_LITERAL);
                    this.modelBuilder.setCurrentObject(objectScope);
                    if (isPrivate) {
                        objectScope.getModifiers().remove(Modifier.PUBLIC);
                        objectScope.getModifiers().add(Modifier.PRIVATE);
                    }
                }
            } else {
                objectScope = ModelElementFactory.createAnonymousObject(this.parserResult, objectNode, this.modelBuilder);
                this.modelBuilder.setCurrentObject(objectScope);
            }
        }
        return super.enter(objectNode);
    }

    @Override
    public Node leave(ObjectNode objectNode) {
        this.modelBuilder.reset();
        return super.leave(objectNode);
    }

    @Override
    public Node enter(PropertyNode propertyNode) {
        if ((propertyNode.getKey() instanceof IdentNode || propertyNode.getKey() instanceof LiteralNode) && !(propertyNode.getValue() instanceof ObjectNode)) {
            JsObjectImpl scope = this.modelBuilder.getCurrentObject();
            IdentifierImpl name = null;
            Node key = propertyNode.getKey();
            if (key instanceof IdentNode) {
                name = ModelElementFactory.create(this.parserResult, (IdentNode)key);
            } else if (key instanceof LiteralNode) {
                name = ModelElementFactory.create(this.parserResult, (LiteralNode)key);
            }
            if (name != null) {
                JsObjectImpl property = (JsObjectImpl)scope.getProperty(name.getName());
                if (property == null) {
                    property = ModelElementFactory.create(this.parserResult, propertyNode, name, this.modelBuilder, true);
                } else {
                    JsObjectImpl newProperty = ModelElementFactory.create(this.parserResult, propertyNode, name, this.modelBuilder, true);
                    if (newProperty != null) {
                        newProperty.addOccurrence(property.getDeclarationName().getOffsetRange());
                        for (Occurrence occurrence : property.getOccurrences()) {
                            newProperty.addOccurrence(occurrence.getOffsetRange());
                        }
                        property = newProperty;
                    }
                }
                if (property != null) {
                    if (propertyNode.getGetter() != null) {
                        FunctionNode getter = ((ReferenceNode)propertyNode.getGetter()).getReference();
                        property.addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, getter.getIdent().getStart(), getter.getIdent().getFinish()));
                    }
                    if (propertyNode.getSetter() != null) {
                        FunctionNode setter = ((ReferenceNode)propertyNode.getSetter()).getReference();
                        property.addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, setter.getIdent().getStart(), setter.getIdent().getFinish()));
                    }
                    scope.addProperty(name.getName(), property);
                    property.setDeclared(true);
                    Node value = propertyNode.getValue();
                    if (!(value instanceof CallNode)) {
                        Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.parserResult, value);
                        if (!types.isEmpty()) {
                            property.addAssignment(types, LexUtilities.getLexerOffset(this.parserResult, name.getOffsetRange().getStart()));
                        }
                        if (value instanceof IdentNode) {
                            String iName;
                            IdentNode iNode = (IdentNode)value;
                            JsFunction function = (JsFunction)((Object)ModelUtils.getDeclarationScope(property));
                            JsObjectImpl param = (JsObjectImpl)function.getParameter(iName = iNode.getName());
                            if (param != null) {
                                param.addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), iNode.getFinish()));
                            } else {
                                Collection<? extends JsObject> variables = ModelUtils.getVariables((DeclarationScope)((Object)function));
                                for (JsObject jsObject : variables) {
                                    if (!iName.equals(jsObject.getName())) continue;
                                    ((JsObjectImpl)jsObject).addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), iNode.getFinish()));
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        return super.enter(propertyNode);
    }

    @Override
    public Node enter(ReferenceNode referenceNode) {
        if (referenceNode.getReference() instanceof FunctionNode) {
            this.addToPath((Node)referenceNode);
            referenceNode.getReference().accept((NodeVisitor)this);
            this.removeFromPathTheLast();
            return null;
        }
        return super.enter(referenceNode);
    }

    @Override
    public Node enter(ReturnNode returnNode) {
        Collection<TypeUsage> types;
        Node expression = returnNode.getExpression();
        if (expression instanceof IdentNode) {
            this.addOccurence((IdentNode)expression, false);
        }
        if ((types = ModelUtils.resolveSemiTypeOfExpression(this.parserResult, expression)).isEmpty()) {
            types.add(new TypeUsageImpl("unresolved", LexUtilities.getLexerOffset(this.parserResult, returnNode.getStart()), true));
        }
        JsFunctionImpl function = this.modelBuilder.getCurrentDeclarationFunction();
        function.addReturnType(types);
        return super.enter(returnNode);
    }

    @Override
    public Node enter(TernaryNode ternaryNode) {
        if (ternaryNode.lhs() instanceof IdentNode) {
            this.addOccurence((IdentNode)ternaryNode.lhs(), false);
        }
        if (ternaryNode.rhs() instanceof IdentNode) {
            this.addOccurence((IdentNode)ternaryNode.rhs(), false);
        }
        if (ternaryNode.third() instanceof IdentNode) {
            this.addOccurence((IdentNode)ternaryNode.third(), false);
        }
        return super.enter(ternaryNode);
    }

    @Override
    public Node enter(UnaryNode unaryNode) {
        if (Token.descType((long)unaryNode.getToken()) == TokenType.NEW) {
            Node lastNode = this.getPath().get(this.getPath().size() - 1);
            if (unaryNode.rhs() instanceof CallNode && ((CallNode)unaryNode.rhs()).getFunction() instanceof IdentNode && !(lastNode instanceof PropertyNode) && !this.inVarNode && this.modelBuilder.getCurrentObject() != null) {
                int start = LexUtilities.getLexerOffset(this.parserResult, unaryNode.getStart());
                if (this.getPath().get(this.getPath().size() - 1) instanceof VarNode) {
                    start = LexUtilities.getLexerOffset(this.parserResult, ((VarNode)this.getPath().get(this.getPath().size() - 1)).getName().getFinish());
                }
                Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.parserResult, (Node)unaryNode);
                for (TypeUsage type : types) {
                    this.modelBuilder.getCurrentObject().addAssignment(type, start);
                }
            }
        } else if (unaryNode.rhs() instanceof IdentNode) {
            this.addOccurence((IdentNode)unaryNode.rhs(), false);
        }
        return super.enter(unaryNode);
    }

    @Override
    public Node enter(VarNode varNode) {
        if (!(varNode.getInit() instanceof ObjectNode) && !(varNode.getInit() instanceof ReferenceNode)) {
            JsObject parent = this.modelBuilder.getCurrentObject();
            if (parent instanceof CatchBlockImpl) {
                parent = parent.getParent();
            }
            JsObjectImpl variable = (JsObjectImpl)parent.getProperty(varNode.getName().getName());
            IdentifierImpl name = ModelElementFactory.create(this.parserResult, varNode.getName());
            if (name != null) {
                List<Type> returnTypes;
                if (variable == null) {
                    variable = new JsObjectImpl(parent, name, name.getOffsetRange(), true);
                    if (parent.getJSKind() != JsElement.Kind.FILE) {
                        variable.getModifiers().remove(Modifier.PUBLIC);
                        variable.getModifiers().add(Modifier.PRIVATE);
                    }
                    parent.addProperty(name.getName(), variable);
                    variable.addOccurrence(name.getOffsetRange());
                } else if (!variable.isDeclared()) {
                    JsObjectImpl newVariable = new JsObjectImpl(parent, name, name.getOffsetRange(), true);
                    newVariable.addOccurrence(name.getOffsetRange());
                    for (String string : variable.getProperties().keySet()) {
                        JsObject jsObject = variable.getProperty(string);
                        if (jsObject instanceof JsObjectImpl) {
                            ((JsObjectImpl)jsObject).setParent(newVariable);
                        }
                        newVariable.addProperty(string, jsObject);
                    }
                    if (parent.getJSKind() != JsElement.Kind.FILE) {
                        newVariable.getModifiers().remove(Modifier.PUBLIC);
                        newVariable.getModifiers().add(Modifier.PRIVATE);
                    }
                    for (TypeUsage typeUsage : variable.getAssignments()) {
                        newVariable.addAssignment(typeUsage, typeUsage.getOffset());
                    }
                    for (Occurrence occurrence : variable.getOccurrences()) {
                        newVariable.addOccurrence(occurrence.getOffsetRange());
                    }
                    parent.addProperty(name.getName(), newVariable);
                    variable = newVariable;
                }
                JsDocumentationHolder docHolder = this.parserResult.getDocumentationHolder();
                variable.setDeprecated(docHolder.isDeprecated((Node)varNode));
                variable.setDocumentation(docHolder.getDocumentation((Node)varNode));
                this.modelBuilder.setCurrentObject(variable);
                if (varNode.getInit() instanceof IdentNode) {
                    this.addOccurence((IdentNode)varNode.getInit(), false);
                }
                if (!(varNode.getInit() instanceof UnaryNode) || Token.descType((long)((UnaryNode)varNode.getInit()).getToken()) != TokenType.NEW) {
                    this.inVarNode = true;
                    Collection<TypeUsage> types = ModelUtils.resolveSemiTypeOfExpression(this.parserResult, varNode.getInit());
                    for (TypeUsage typeUsage : types) {
                        variable.addAssignment(typeUsage, LexUtilities.getLexerOffset(this.parserResult, varNode.getName().getFinish()));
                    }
                }
                if ((returnTypes = docHolder.getReturnType((Node)varNode)) != null && !returnTypes.isEmpty()) {
                    for (Type type : returnTypes) {
                        variable.addAssignment(new TypeUsageImpl(type.getType(), type.getOffset(), true), varNode.getName().getFinish());
                    }
                }
            }
        } else if (varNode.getInit() instanceof ObjectNode) {
            JsObjectImpl variable;
            JsFunctionImpl function = this.modelBuilder.getCurrentDeclarationFunction();
            IdentifierImpl name = ModelElementFactory.create(this.parserResult, varNode.getName());
            if (name != null && (variable = (JsObjectImpl)function.getProperty(name.getName())) != null) {
                this.modelBuilder.setCurrentObject(variable);
                variable.setDeclared(true);
                variable.setJsKind(JsElement.Kind.OBJECT_LITERAL);
            }
        }
        return super.enter(varNode);
    }

    @Override
    public Node leave(VarNode varNode) {
        if (!(varNode.getInit() instanceof ReferenceNode) && ModelElementFactory.create(this.parserResult, varNode.getName()) != null) {
            this.modelBuilder.reset();
        }
        this.inVarNode = false;
        return super.leave(varNode);
    }

    private List<Identifier> getName(PropertyNode propertyNode) {
        FunctionNode fNode;
        String fName;
        Node previousNode;
        ArrayList<Identifier> name = new ArrayList<Identifier>(1);
        if ((propertyNode.getGetter() != null || propertyNode.getSetter() != null) && (previousNode = this.getPreviousFromPath(1)) instanceof FunctionNode && ((fName = (fNode = (FunctionNode)previousNode).getIdent().getName()).startsWith("get ") || fName.startsWith("set "))) {
            name.add(new IdentifierImpl(fName, ModelUtils.documentOffsetRange(this.parserResult, fNode.getIdent().getStart(), fNode.getIdent().getFinish())));
            return name;
        }
        if (propertyNode.getKey() instanceof IdentNode) {
            IdentNode ident = (IdentNode)propertyNode.getKey();
            name.add(new IdentifierImpl(ident.getName(), ModelUtils.documentOffsetRange(this.parserResult, ident.getStart(), ident.getFinish())));
        } else if (propertyNode.getKey() instanceof LiteralNode) {
            LiteralNode lNode = (LiteralNode)propertyNode.getKey();
            name.add(new IdentifierImpl(lNode.getString(), ModelUtils.documentOffsetRange(this.parserResult, lNode.getStart(), lNode.getFinish())));
        }
        return name;
    }

    private List<Identifier> getName(VarNode varNode) {
        ArrayList<Identifier> name = new ArrayList<Identifier>();
        name.add(new IdentifierImpl(varNode.getName().getName(), ModelUtils.documentOffsetRange(this.parserResult, varNode.getName().getStart(), varNode.getName().getFinish())));
        return name;
    }

    private List<Identifier> getName(BinaryNode binaryNode) {
        ArrayList<Identifier> name = new ArrayList();
        Node lhs = binaryNode.lhs();
        if (lhs instanceof AccessNode) {
            name = this.getName((AccessNode)lhs);
        } else if (lhs instanceof IdentNode) {
            IdentNode ident = (IdentNode)lhs;
            name.add(new IdentifierImpl(ident.getName(), ModelUtils.documentOffsetRange(this.parserResult, ident.getStart(), ident.getFinish())));
        } else if (lhs instanceof IndexNode) {
            IndexNode indexNode = (IndexNode)lhs;
            if (indexNode.getBase() instanceof AccessNode) {
                List<Identifier> aName = this.getName((AccessNode)indexNode.getBase());
                if (aName != null) {
                    name.addAll(this.getName((AccessNode)indexNode.getBase()));
                } else {
                    return null;
                }
            }
            if (indexNode.getIndex() instanceof LiteralNode) {
                LiteralNode lNode = (LiteralNode)indexNode.getIndex();
                name.add(new IdentifierImpl(lNode.getPropertyName(), ModelUtils.documentOffsetRange(this.parserResult, lNode.getStart(), lNode.getFinish())));
            }
        }
        return name;
    }

    private List<Identifier> getName(AccessNode aNode) {
        ArrayList<Identifier> name = new ArrayList<Identifier>();
        name.add(new IdentifierImpl(aNode.getProperty().getName(), ModelUtils.documentOffsetRange(this.parserResult, aNode.getProperty().getStart(), aNode.getProperty().getFinish())));
        while (aNode.getBase() instanceof AccessNode) {
            aNode = (AccessNode)aNode.getBase();
            name.add(new IdentifierImpl(aNode.getProperty().getName(), ModelUtils.documentOffsetRange(this.parserResult, aNode.getProperty().getStart(), aNode.getProperty().getFinish())));
        }
        if (aNode.getBase() instanceof IdentNode) {
            IdentNode ident;
            if (name.size() > 0 && aNode.getBase() instanceof IdentNode && !"this".equals((ident = (IdentNode)aNode.getBase()).getName())) {
                name.add(new IdentifierImpl(ident.getName(), ModelUtils.documentOffsetRange(this.parserResult, ident.getStart(), ident.getFinish())));
            }
            Collections.reverse(name);
            return name;
        }
        return null;
    }

    public List<Identifier> getNodeName(Node node) {
        if (node instanceof AccessNode) {
            return this.getName((AccessNode)node);
        }
        if (node instanceof BinaryNode) {
            return this.getName((BinaryNode)node);
        }
        if (node instanceof VarNode) {
            return this.getName((VarNode)node);
        }
        if (node instanceof PropertyNode) {
            return this.getName((PropertyNode)node);
        }
        if (node instanceof FunctionNode) {
            if (((FunctionNode)node).getKind() == FunctionNode.Kind.SCRIPT) {
                return Collections.emptyList();
            }
            IdentNode ident = ((FunctionNode)node).getIdent();
            return Arrays.asList(new IdentifierImpl(ident.getName(), ModelUtils.documentOffsetRange(this.parserResult, ident.getStart(), ident.getFinish())));
        }
        return Collections.emptyList();
    }

    private boolean isInPropertyNode() {
        boolean inFunction = false;
        for (int i = this.getPath().size() - 1; i > 0; --i) {
            Node node = this.getPath().get(i);
            if (node instanceof FunctionNode) {
                if (!inFunction) {
                    inFunction = true;
                    continue;
                }
                return false;
            }
            if (!(node instanceof PropertyNode)) continue;
            return true;
        }
        return false;
    }

    private void addOccurence(IdentNode iNode, boolean leftSite) {
        this.addOccurence(iNode, leftSite, false, 0);
    }

    private void addOccurence(IdentNode iNode, boolean leftSite, boolean isFunction, int countParam) {
        if ("this".equals(iNode.getName())) {
            return;
        }
        JsElement property = null;
        JsElement parameter = null;
        for (DeclarationScope scope = this.modelBuilder.getCurrentDeclarationScope(); scope != null && property == null && parameter == null; scope = scope.getInScope()) {
            JsFunction function = (JsFunction)((Object)scope);
            property = function.getProperty(iNode.getName());
            parameter = function.getParameter(iNode.getName());
        }
        if (parameter != null) {
            if (property == null) {
                property = parameter;
            } else if (property.getJSKind() != JsElement.Kind.VARIABLE) {
                property = parameter;
            }
        }
        if (property != null) {
            this.addDocNameOccurence((JsObjectImpl)property);
            this.addDocTypesOccurence((JsObjectImpl)property);
            ((JsObjectImpl)property).addOccurrence(ModelUtils.documentOffsetRange(this.parserResult, iNode.getStart(), iNode.getFinish()));
        } else {
            IdentifierImpl name = ModelElementFactory.create(this.parserResult, iNode);
            if (name != null) {
                JsObjectImpl newObject;
                if (!isFunction) {
                    newObject = new JsObjectImpl(this.modelBuilder.getGlobal(), name, name.getOffsetRange(), leftSite);
                } else {
                    FileObject fo = this.parserResult.getSnapshot().getSource().getFileObject();
                    newObject = new JsFunctionImpl(fo, (JsObject)this.modelBuilder.getGlobal(), (Identifier)name, Collections.EMPTY_LIST);
                }
                newObject.addOccurrence(name.getOffsetRange());
                this.modelBuilder.getGlobal().addProperty(name.getName(), newObject);
            }
        }
    }

    private void addDocNameOccurence(JsObjectImpl jsObject) {
        JsDocumentationHolder holder = this.parserResult.getDocumentationHolder();
        JsComment comment = holder.getCommentForOffset(jsObject.getOffset(), holder.getCommentBlocks());
        if (comment != null) {
            for (DocParameter docParameter : comment.getParameters()) {
                DocIdentifier paramName = docParameter.getParamName();
                String name = docParameter.getParamName() == null ? "" : docParameter.getParamName().getName();
                if (!name.equals(jsObject.getName())) continue;
                jsObject.addOccurrence(DocumentationUtils.getOffsetRange(paramName));
            }
        }
    }

    private void addDocTypesOccurence(JsObjectImpl jsObject) {
        JsDocumentationHolder holder = this.parserResult.getDocumentationHolder();
        if (holder.getOccurencesMap().containsKey(jsObject.getName())) {
            for (OffsetRange offsetRange : holder.getOccurencesMap().get(jsObject.getName())) {
                jsObject.addOccurrence(offsetRange);
            }
        }
    }

    private Node getPreviousFromPath(int back) {
        int size = this.getPath().size();
        if (size >= back) {
            return this.getPath().get(size - back);
        }
        return null;
    }
}

