/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.CallNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.ReferenceNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.TokenType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.editor.embedding.JsEmbeddingProvider;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.index.JsIndex;
import org.netbeans.modules.javascript2.editor.jquery.JQueryModel;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Model;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsFunctionImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsFunctionReference;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectReference;
import org.netbeans.modules.javascript2.editor.model.impl.ModelBuilder;
import org.netbeans.modules.javascript2.editor.model.impl.ParameterObject;
import org.netbeans.modules.javascript2.editor.model.impl.PathNodeVisitor;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.openide.filesystems.FileObject;

public class ModelUtils {
    private static final Collection<JsTokenId> CTX_DELIMITERS = Arrays.asList(JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_CURLY, JsTokenId.OPERATOR_SEMICOLON);

    public static JsObjectImpl getJsObject(ModelBuilder builder, List<Identifier> fqName, boolean isLHS) {
        int index;
        JsObject result = builder.getCurrentObject();
        JsObject tmpObject = null;
        String firstName = fqName.get(0).getName();
        while (tmpObject == null && result != null && result.getParent() != null) {
            if (result instanceof JsFunctionImpl) {
                tmpObject = ((JsFunctionImpl)result).getParameter(firstName);
            }
            if (tmpObject == null) {
                if (result.getProperty(firstName) != null) {
                    tmpObject = result;
                }
                result = result.getParent();
                continue;
            }
            result = tmpObject;
        }
        if (tmpObject == null) {
            for (DeclarationScope scope = builder.getCurrentDeclarationFunction(); scope != null && tmpObject == null && scope.getInScope() != null; scope = scope.getInScope()) {
                tmpObject = ((JsFunction)((Object)scope)).getParameter(firstName);
            }
            if (tmpObject == null) {
                tmpObject = builder.getGlobal();
            } else {
                result = tmpObject;
            }
        }
        int n = index = tmpObject instanceof ParameterObject ? 1 : 0;
        while (index < fqName.size()) {
            Identifier name = fqName.get(index);
            result = tmpObject.getProperty(name.getName());
            if (result == null) {
                result = new JsObjectImpl(tmpObject, name, name.getOffsetRange(), index < fqName.size() - 1 ? false : isLHS);
                tmpObject.addProperty(name.getName(), result);
            }
            tmpObject = result;
            ++index;
        }
        return result;
    }

    public static boolean isGlobal(JsObject object) {
        return object.getJSKind() == JsElement.Kind.FILE;
    }

    public static JsObject findJsObject(Model model, int offset) {
        JsObject result = null;
        JsObject global = model.getGlobalObject();
        result = ModelUtils.findJsObject(global, offset);
        if (result == null) {
            result = global;
        }
        return result;
    }

    public static JsObject findJsObject(JsObject object, int offset) {
        JsObjectImpl jsObject = (JsObjectImpl)object;
        JsObject result = null;
        JsObject tmpObject = null;
        if (jsObject.getOffsetRange().containsInclusive(offset)) {
            result = jsObject;
            for (JsObject jsObject2 : jsObject.getProperties().values()) {
                JsElement.Kind kind = jsObject2.getJSKind();
                if (kind == JsElement.Kind.OBJECT || kind == JsElement.Kind.ANONYMOUS_OBJECT || kind == JsElement.Kind.OBJECT_LITERAL || kind == JsElement.Kind.FUNCTION || kind == JsElement.Kind.METHOD || kind == JsElement.Kind.CONSTRUCTOR) {
                    tmpObject = ModelUtils.findJsObject(jsObject2, offset);
                }
                if (tmpObject == null) continue;
                result = tmpObject;
                break;
            }
        }
        return result;
    }

    public static JsObject findJsObjectByName(JsObject global, String fqName) {
        JsObject result;
        JsObject property = result = global;
        StringTokenizer stringTokenizer = new StringTokenizer(fqName, ".");
        while (stringTokenizer.hasMoreTokens() && result != null) {
            String token = stringTokenizer.nextToken();
            property = result.getProperty(token);
            if (property == null) {
                if ((result = result instanceof JsFunction ? ((JsFunction)result).getParameter(token) : null) != null) continue;
                break;
            }
            result = property;
        }
        return result;
    }

    public static JsObject findJsObjectByName(Model model, String fqName) {
        return ModelUtils.findJsObjectByName(model.getGlobalObject(), fqName);
    }

    public static JsObject getGlobalObject(JsObject jsObject) {
        JsObject result = jsObject;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    public static DeclarationScope getDeclarationScope(JsObject object) {
        JsObject result = object;
        while (result.getParent() != null && !(result.getParent() instanceof DeclarationScope)) {
            result = result.getParent();
        }
        return (DeclarationScope)((Object)result.getParent());
    }

    public static DeclarationScope getDeclarationScope(Model model, int offset) {
        DeclarationScope result = null;
        JsObject global = model.getGlobalObject();
        result = ModelUtils.getDeclarationScope((DeclarationScope)((Object)global), offset);
        if (result == null) {
            result = (DeclarationScope)((Object)global);
        }
        return result;
    }

    public static DeclarationScope getDeclarationScope(DeclarationScope scope, int offset) {
        DeclarationScopeImpl dScope = (DeclarationScopeImpl)scope;
        DeclarationScope result = null;
        if (result == null && dScope.getOffsetRange().containsInclusive(offset)) {
            result = dScope;
            boolean deep = true;
            block0: while (deep) {
                deep = false;
                for (DeclarationScope declarationScope : result.getDeclarationsScope()) {
                    if (!((DeclarationScopeImpl)declarationScope).getOffsetRange().containsInclusive(offset)) continue;
                    result = declarationScope;
                    deep = true;
                    continue block0;
                }
            }
        }
        return result;
    }

    public static String createFQN(JsObject object) {
        StringBuilder result = new StringBuilder();
        result.append(object.getName());
        JsObject parent = object;
        if (object.getParent() == null) {
            return object.getName();
        }
        while ((parent = parent.getParent()).getParent() != null) {
            result.insert(0, ".");
            result.insert(0, parent.getName());
        }
        return result.toString();
    }

    public static OffsetRange documentOffsetRange(JsParserResult result, int start, int end) {
        int lStart = LexUtilities.getLexerOffset(result, start);
        int lEnd = LexUtilities.getLexerOffset(result, end);
        if (lStart == -1 || lEnd == -1) {
            return OffsetRange.NONE;
        }
        if (lEnd < lStart) {
            int length = lStart - lEnd;
            lEnd = lStart + length;
        }
        return new OffsetRange(lStart, lEnd);
    }

    public static Collection<? extends JsObject> getVariables(DeclarationScope inScope) {
        ArrayList<JsObject> result = new ArrayList<JsObject>();
        while (inScope != null) {
            for (JsObject jsObject : ((JsObject)((Object)inScope)).getProperties().values()) {
                result.add(jsObject);
            }
            for (JsObject jsObject : ((JsFunction)((Object)inScope)).getParameters()) {
                result.add(jsObject);
            }
            inScope = inScope.getInScope();
        }
        return result;
    }

    public static Collection<? extends JsObject> getVariables(Model model, int offset) {
        DeclarationScope scope = ModelUtils.getDeclarationScope(model, offset);
        return ModelUtils.getVariables(scope);
    }

    public static JsObject getJsObjectByName(DeclarationScope inScope, String simpleName) {
        Collection<? extends JsObject> variables = ModelUtils.getVariables(inScope);
        for (JsObject jsObject : variables) {
            if (!simpleName.equals(jsObject.getName())) continue;
            return jsObject;
        }
        return null;
    }

    private static TypeUsage tryResolveWindowProperty(JsIndex jsIndex, String name) {
        for (IndexedElement indexedElement : jsIndex.getProperties("window")) {
            if (!indexedElement.getName().equals(name)) continue;
            return new TypeUsageImpl("window." + indexedElement.getName(), -1, true);
        }
        return null;
    }

    private static String getSemiType(TokenSequence<JsTokenId> ts, int offset) {
        String result = "UNKNOWN";
        ts.move(offset);
        if (!ts.moveNext()) {
            return result;
        }
        State state = State.INIT;
        while (ts.movePrevious()) {
            Token token = ts.token();
            if (CTX_DELIMITERS.contains(token.id())) continue;
            switch (state) {
                case INIT: {
                    if (token.id() != JsTokenId.IDENTIFIER) break;
                }
            }
        }
        return result;
    }

    public static Collection<TypeUsage> resolveSemiTypeOfExpression(JsParserResult parserResult, Node expression) {
        SemiTypeResolverVisitor visitor = new SemiTypeResolverVisitor(parserResult);
        if (expression != null) {
            expression.accept((NodeVisitor)visitor);
            return visitor.getSemiTypes();
        }
        return new HashSet<TypeUsage>();
    }

    public static Collection<TypeUsage> resolveTypeFromSemiType(JsObject object, TypeUsage uType) {
        HashSet<TypeUsage> result = new HashSet<TypeUsage>();
        TypeUsageImpl type = (TypeUsageImpl)uType;
        if (type.isResolved()) {
            result.add(type);
        } else if ("undefined".equals(type.getType())) {
            if (object.getJSKind() == JsElement.Kind.CONSTRUCTOR) {
                result.add(new TypeUsageImpl(ModelUtils.createFQN(object), type.getOffset(), true));
            } else {
                result.add(new TypeUsageImpl("undefined", type.getOffset(), true));
            }
        } else if (JsEmbeddingProvider.containsGeneratedIdentifier(type.getType())) {
            result.add(new TypeUsageImpl("undefined", type.getOffset(), true));
        } else if ("@this".equals(type.getType())) {
            JsObject parent = null;
            parent = object.getJSKind() == JsElement.Kind.CONSTRUCTOR ? object : (object.getParent() != null && object.getParent().getJSKind() != JsElement.Kind.FILE ? object.getParent() : object);
            if (parent != null && (parent.getJSKind() == JsElement.Kind.FUNCTION || parent.getJSKind() == JsElement.Kind.METHOD)) {
                if (parent.getParent().getJSKind() == JsElement.Kind.FILE) {
                    result.add(new TypeUsageImpl(ModelUtils.createFQN(parent), 0, true));
                } else {
                    JsObject grandParent = parent.getParent();
                    if (grandParent != null && grandParent.getJSKind() == JsElement.Kind.OBJECT_LITERAL) {
                        result.add(new TypeUsageImpl(ModelUtils.createFQN(grandParent), type.getOffset(), true));
                    } else {
                        result.add(new TypeUsageImpl(ModelUtils.createFQN(parent), type.getOffset(), true));
                    }
                }
            } else if (parent != null) {
                result.add(new TypeUsageImpl(ModelUtils.createFQN(parent), type.getOffset(), true));
            }
        } else if (type.getType().startsWith("@this.")) {
            Identifier objectName = object.getDeclarationName();
            if (objectName != null && object.getOffsetRange().getEnd() == objectName.getOffsetRange().getEnd()) {
                String pName = type.getType().substring(type.getType().indexOf(46) + 1);
                JsObject property = object.getParent().getProperty(pName);
                if (property != null && property.getJSKind().isFunction()) {
                    JsFunctionImpl function = property instanceof JsFunctionImpl ? (JsFunctionImpl)property : ((JsFunctionReference)property).getOriginal();
                    object.getParent().addProperty(object.getName(), new JsFunctionReference(object.getParent(), object.getDeclarationName(), function, true));
                }
            }
        } else if (type.getType().startsWith("@new;")) {
            String function = type.getType().substring(5);
            JsObject possible = null;
            for (JsObject parent = object; possible == null && parent != null; parent = parent.getParent()) {
                possible = parent.getProperty(function);
            }
            if (possible != null) {
                result.add(new TypeUsageImpl(ModelUtils.createFQN(possible), possible.getOffset(), true));
            } else {
                result.add(type);
            }
        } else if (type.getType().startsWith("@call;")) {
            String functionName = type.getType().substring(6);
            JsObject globalObject = ModelUtils.getGlobalObject(object);
            JsObject function = globalObject.getProperty(functionName);
            if (function != null && function instanceof JsFunction) {
                result.addAll(((JsFunction)function).getReturnTypes());
            }
        } else if (type.getType().startsWith("@anonym;")) {
            int start = Integer.parseInt(type.getType().substring(8));
            JsObject byOffset = ModelUtils.findJsObject(object, start);
            if (byOffset != null && byOffset.isAnonymous()) {
                result.add(new TypeUsageImpl(ModelUtils.createFQN(byOffset), byOffset.getOffset(), true));
            }
        } else if (type.getType().startsWith("@var;")) {
            String name = type.getType().substring(5);
            JsFunction declarationScope = (JsFunction)((Object)ModelUtils.getDeclarationScope(object));
            if (declarationScope != null) {
                Collection<? extends JsObject> parameters = declarationScope.getParameters();
                boolean isParameter = false;
                for (JsObject jsObject : parameters) {
                    if (!name.equals(jsObject.getName())) continue;
                    Collection<? extends TypeUsage> assignments = jsObject.getAssignmentForOffset(jsObject.getOffset());
                    result.addAll(assignments);
                    isParameter = true;
                    break;
                }
                if (!isParameter) {
                    result.add(new TypeUsageImpl(name, type.getOffset(), false));
                }
            }
        } else if (type.getType().startsWith("@param;")) {
            String functionName = type.getType().substring(7);
            int index = functionName.indexOf(":");
            if (index > 0) {
                JsObject jsObject;
                String fqn = functionName.substring(0, index);
                JsObject globalObject = ModelUtils.getGlobalObject(object);
                JsObject function = ModelUtils.findJsObjectByName(globalObject, fqn);
                if (function instanceof JsFunction && (jsObject = ((JsFunction)function).getParameter(functionName.substring(index + 1))) != null) {
                    result.addAll(jsObject.getAssignments());
                }
            }
        } else {
            result.add(type);
        }
        return result;
    }

    public static Collection<TypeUsage> resolveTypeFromExpression(Model model, JsIndex jsIndex, List<String> exp, int offset) {
        ArrayList<JsObject> localObjects = new ArrayList<JsObject>();
        ArrayList<JsObject> lastResolvedObjects = new ArrayList<JsObject>();
        ArrayList<TypeUsage> lastResolvedTypes = new ArrayList<TypeUsage>();
        block0: for (int i = exp.size() - 1; i > -1; --i) {
            String name;
            String kind = exp.get(i);
            if ("this".equals(name = exp.get(--i))) {
                JsObject thisObject;
                JsObject first = thisObject = ModelUtils.findJsObject(model, offset);
                while (thisObject != null && thisObject.getParent() != null && thisObject.getJSKind() != JsElement.Kind.CONSTRUCTOR && thisObject.getJSKind() != JsElement.Kind.ANONYMOUS_OBJECT && thisObject.getJSKind() != JsElement.Kind.OBJECT_LITERAL) {
                    thisObject = thisObject.getParent();
                }
                if ((thisObject == null || thisObject.getParent() == null) && first != null) {
                    thisObject = first;
                }
                if (thisObject != null) {
                    name = thisObject.getName();
                }
            }
            if (i == exp.size() - 2) {
                JsObject localObject = null;
                for (JsObject jsObject : model.getVariables(offset)) {
                    if (!jsObject.getName().equals(name)) continue;
                    localObjects.add(jsObject);
                    localObject = jsObject;
                    break;
                }
                block3: for (JsObject jsObject : ModelUtils.getLibrariesGlobalObjects()) {
                    for (JsObject jsObject2 : jsObject.getProperties().values()) {
                        if (!jsObject2.getName().equals(name)) continue;
                        lastResolvedTypes.add(new TypeUsageImpl(jsObject2.getName(), -1, true));
                        continue block3;
                    }
                }
                TypeUsage windowProperty = ModelUtils.tryResolveWindowProperty(jsIndex, name);
                if (windowProperty != null) {
                    lastResolvedTypes.add(windowProperty);
                }
                if (localObject == null || localObject.getJSKind() != JsElement.Kind.PARAMETER && (ModelUtils.isGlobal(localObject.getParent()) || localObject.getJSKind() != JsElement.Kind.VARIABLE)) {
                    ArrayList<TypeUsage> arrayList = new ArrayList<TypeUsage>();
                    ModelUtils.resolveAssignments(jsIndex, name, arrayList);
                    lastResolvedTypes.addAll(arrayList);
                }
                if (localObjects.isEmpty()) continue;
                for (JsObject lObject : localObjects) {
                    if (lObject.getAssignmentForOffset(offset).isEmpty()) {
                        boolean bl;
                        boolean bl2 = bl = lObject.getJSKind() == JsElement.Kind.OBJECT_LITERAL;
                        if (lObject instanceof JsObjectReference) {
                            name = ((JsObjectReference)lObject).getOriginal().getDeclarationName().getName();
                        }
                        if (bl) {
                            lastResolvedTypes.add(new TypeUsageImpl(name, -1, true));
                        }
                    }
                    if ("@mtd".equals(kind)) {
                        if (!lObject.getJSKind().isFunction()) continue;
                        lastResolvedTypes.addAll(((JsFunction)lObject).getReturnTypes());
                        continue;
                    }
                    Collection<? extends TypeUsage> collection = lObject.getAssignmentForOffset(offset);
                    if (collection.isEmpty()) {
                        lastResolvedObjects.add(lObject);
                        continue;
                    }
                    ModelUtils.resolveAssignments(model, lObject, offset, lastResolvedObjects, lastResolvedTypes);
                    continue block0;
                }
                continue;
            }
            ArrayList<JsObject> newResolvedObjects = new ArrayList<JsObject>();
            ArrayList<? extends TypeUsage> newResolvedTypes = new ArrayList<TypeUsage>();
            for (JsObject localObject : lastResolvedObjects) {
                JsObject jsObject = localObject.getProperty(name);
                if (jsObject == null) continue;
                if ("@mtd".equals(kind)) {
                    if (!jsObject.getJSKind().isFunction()) continue;
                    Collection<? extends TypeUsage> resovledTypes = ((JsFunction)jsObject).getReturnTypes();
                    newResolvedTypes.addAll(resovledTypes);
                    continue;
                }
                Collection<? extends TypeUsage> lastTypeAssignment = jsObject.getAssignmentForOffset(offset);
                if (lastTypeAssignment.isEmpty()) {
                    newResolvedObjects.add(jsObject);
                    continue;
                }
                newResolvedTypes.addAll(lastTypeAssignment);
            }
            for (TypeUsage typeUsage : lastResolvedTypes) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(typeUsage.getType());
                arrayList.addAll(ModelUtils.findPrototypeChain(typeUsage.getType(), jsIndex));
                Collection<? extends IndexResult> indexResults = null;
                for (String string : arrayList) {
                    indexResults = jsIndex.findFQN(string + "." + name);
                    if (indexResults.isEmpty()) {
                        indexResults = jsIndex.findFQN(string + ".prototype." + name);
                    }
                    if (indexResults.isEmpty()) continue;
                    break;
                }
                for (IndexResult indexResult : indexResults) {
                    JsElement.Kind jsKind = IndexedElement.Flag.getJsKind(Integer.parseInt(indexResult.getValue("flag")));
                    if ("@mtd".equals(kind) && jsKind.isFunction()) {
                        Collection<TypeUsage> collection = IndexedElement.getReturnTypes(indexResult);
                        newResolvedTypes.addAll(collection);
                        continue;
                    }
                    String string = typeUsage.getType() + "." + name;
                    ArrayList<TypeUsage> fromAssignment = new ArrayList<TypeUsage>();
                    ModelUtils.resolveAssignments(jsIndex, string, fromAssignment);
                    if (fromAssignment.isEmpty()) {
                        newResolvedTypes.add(new TypeUsageImpl(string));
                        continue;
                    }
                    newResolvedTypes.addAll(fromAssignment);
                }
                block10: for (JsObject jsObject : ModelUtils.getLibrariesGlobalObjects()) {
                    for (JsObject jsObject3 : jsObject.getProperties().values()) {
                        if (!jsObject3.getName().equals(typeUsage.getType())) continue;
                        JsObject property = jsObject3.getProperty(name);
                        if (property == null) continue block10;
                        JsElement.Kind jsKind = property.getJSKind();
                        if ("@mtd".equals(kind) && jsKind.isFunction()) {
                            newResolvedTypes.addAll(((JsFunction)property).getReturnTypes());
                            continue block10;
                        }
                        newResolvedObjects.add(property);
                        continue block10;
                    }
                }
            }
            lastResolvedObjects = newResolvedObjects;
            lastResolvedTypes = newResolvedTypes;
        }
        HashMap<String, TypeUsage> resultTypes = new HashMap<String, TypeUsage>();
        for (TypeUsage typeUsage : lastResolvedTypes) {
            if (resultTypes.containsKey(typeUsage.getType())) continue;
            resultTypes.put(typeUsage.getType(), typeUsage);
        }
        for (JsObject jsObject : lastResolvedObjects) {
            String fqn = ModelUtils.createFQN(jsObject);
            if (resultTypes.containsKey(fqn)) continue;
            resultTypes.put(fqn, new TypeUsageImpl(fqn, offset));
        }
        return resultTypes.values();
    }

    public static Collection<TypeUsage> resolveTypes(Collection<? extends TypeUsage> unresolved, JsParserResult parserResult) {
        ArrayList<TypeUsage> types = new ArrayList<TypeUsage>(unresolved);
        Model model = parserResult.getModel();
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        JsIndex jsIndex = JsIndex.get(fo);
        int cycle = 0;
        boolean resolvedAll = false;
        while (!resolvedAll && cycle < 10) {
            ++cycle;
            resolvedAll = true;
            ArrayList<TypeUsage> resolved = new ArrayList<TypeUsage>();
            for (TypeUsage typeUsage : types) {
                if (!((TypeUsageImpl)typeUsage).isResolved()) {
                    resolvedAll = false;
                    String sexp = typeUsage.getType();
                    if (sexp.startsWith("@exp;")) {
                        int start = sexp.charAt(5) == '@' ? 6 : 5;
                        sexp = sexp.substring(start);
                        ArrayList<String> nExp = new ArrayList<String>();
                        String[] split = sexp.split("@");
                        for (int i = split.length - 1; i > -1; --i) {
                            nExp.add(split[i].substring(split[i].indexOf(59) + 1));
                            if (split[i].startsWith("call;")) {
                                nExp.add("@mtd");
                                continue;
                            }
                            nExp.add("@pro");
                        }
                        ModelUtils.addUnigueType(resolved, ModelUtils.resolveTypeFromExpression(model, jsIndex, nExp, typeUsage.getOffset()));
                        continue;
                    }
                    ModelUtils.addUnigueType(resolved, new TypeUsageImpl(typeUsage.getType(), typeUsage.getOffset(), true));
                    continue;
                }
                ModelUtils.addUnigueType(resolved, typeUsage);
            }
            types.clear();
            types = new ArrayList(resolved);
        }
        return types;
    }

    private static void resolveAssignments(Model model, JsObject jsObject, int offset, List<JsObject> resolvedObjects, List<TypeUsage> resolvedTypes) {
        Collection<? extends TypeUsage> assignments = jsObject.getAssignmentForOffset(offset);
        for (Type type : assignments) {
            JsObject byOffset = ModelUtils.findObjectForOffset(type.getType(), offset, model);
            if (byOffset != null) {
                if (jsObject.getName().equals(byOffset.getName())) continue;
                resolvedObjects.add(byOffset);
                ModelUtils.resolveAssignments(model, byOffset, offset, resolvedObjects, resolvedTypes);
                continue;
            }
            resolvedTypes.add((TypeUsage)type);
        }
    }

    private static void resolveAssignments(JsIndex jsIndex, String fqn, List<TypeUsage> resolved) {
        HashSet<String> alreadyProcessed = new HashSet<String>();
        for (TypeUsage type : resolved) {
            alreadyProcessed.add(type.getType());
        }
        ModelUtils.resolveAssignments(jsIndex, fqn, resolved, alreadyProcessed);
    }

    private static void resolveAssignments(JsIndex jsIndex, String fqn, List<TypeUsage> resolved, Set<String> alreadyProcessed) {
        if (!alreadyProcessed.contains(fqn)) {
            alreadyProcessed.add(fqn);
            if (!fqn.startsWith("@exp;")) {
                Collection<? extends IndexResult> indexResults = jsIndex.findFQN(fqn);
                boolean hasAssignments = false;
                boolean isType = false;
                for (IndexResult indexResult : indexResults) {
                    Collection<TypeUsage> assignments;
                    Collection<IndexedElement> properties = IndexedElement.createProperties(indexResult, fqn);
                    for (IndexedElement property : properties) {
                        if (!property.isDeclared() && !"prototype".equals(property.getName())) continue;
                        isType = true;
                        break;
                    }
                    if (isType) {
                        ModelUtils.addUnigueType(resolved, new TypeUsageImpl(fqn, -1, true));
                    }
                    if ((assignments = IndexedElement.getAssignments(indexResult)).isEmpty()) continue;
                    hasAssignments = true;
                    for (TypeUsage type : assignments) {
                        if (alreadyProcessed.contains(type.getType())) continue;
                        ModelUtils.resolveAssignments(jsIndex, type.getType(), resolved, alreadyProcessed);
                    }
                }
                if (!hasAssignments) {
                    ModelUtils.addUnigueType(resolved, new TypeUsageImpl(fqn, -1, true));
                }
            } else {
                ModelUtils.addUnigueType(resolved, new TypeUsageImpl(fqn, -1, false));
            }
        }
    }

    public static JsObject findObjectForOffset(String name, int offset, Model model) {
        for (JsObject jsObject : model.getVariables(offset)) {
            if (!jsObject.getName().equals(name)) continue;
            return jsObject;
        }
        return null;
    }

    public static Collection<String> findPrototypeChain(String fqn, JsIndex jsIndex) {
        return ModelUtils.findPrototypeChain(fqn, jsIndex, new HashSet<String>());
    }

    private static Collection<String> findPrototypeChain(String fqn, JsIndex jsIndex, Set<String> alreadyCheck) {
        ArrayList<String> result = new ArrayList<String>();
        if (!alreadyCheck.contains(fqn)) {
            alreadyCheck.add(fqn);
            Collection<IndexedElement> properties = jsIndex.getProperties(fqn);
            for (IndexedElement property : properties) {
                if (!"prototype".equals(property.getName())) continue;
                Collection<? extends IndexResult> indexResults = jsIndex.findFQN(property.getFQN());
                for (IndexResult indexResult : indexResults) {
                    Collection<TypeUsage> assignments = IndexedElement.getAssignments(indexResult);
                    for (TypeUsage typeUsage : assignments) {
                        result.add(typeUsage.getType());
                    }
                    for (TypeUsage typeUsage : assignments) {
                        result.addAll(ModelUtils.findPrototypeChain(typeUsage.getType(), jsIndex, alreadyCheck));
                    }
                }
            }
        }
        return result;
    }

    private static Collection<JsObject> getLibrariesGlobalObjects() {
        ArrayList<JsObject> result = new ArrayList<JsObject>();
        JsObject libGlobal = JQueryModel.getGlobalObject();
        if (libGlobal != null) {
            result.add(libGlobal);
        }
        return result;
    }

    public static void addUnigueType(Collection<TypeUsage> where, TypeUsage type) {
        boolean isThere = false;
        String typeName = type.getType();
        for (TypeUsage utype : where) {
            if (!utype.getType().equals(typeName)) continue;
            isThere = true;
            break;
        }
        if (!isThere) {
            where.add(type);
        }
    }

    public static void addUnigueType(Collection<TypeUsage> where, Collection<TypeUsage> what) {
        for (TypeUsage type : what) {
            ModelUtils.addUnigueType(where, type);
        }
    }

    public static void addDocTypesOccurence(JsObject jsObject, JsDocumentationHolder docHolder) {
        if (docHolder.getOccurencesMap().containsKey(jsObject.getName())) {
            for (OffsetRange offsetRange : docHolder.getOccurencesMap().get(jsObject.getName())) {
                ((JsObjectImpl)jsObject).addOccurrence(offsetRange);
            }
        }
    }

    private static class SemiTypeResolverVisitor
    extends PathNodeVisitor {
        private static TypeUsage BOOLEAN_TYPE = new TypeUsageImpl("Boolean", -1, true);
        private static TypeUsage STRING_TYPE = new TypeUsageImpl("String", -1, true);
        private static TypeUsage NUMBER_TYPE = new TypeUsageImpl("Number", -1, true);
        private static TypeUsage ARRAY_TYPE = new TypeUsageImpl("Array", -1, true);
        private static TypeUsage REGEXP_TYPE = new TypeUsageImpl("RegExp", -1, true);
        private final Set<TypeUsage> result = new HashSet<TypeUsage>();
        private StringBuilder sb = new StringBuilder();
        private final JsParserResult parserResult;

        public SemiTypeResolverVisitor(JsParserResult parserResult) {
            this.parserResult = parserResult;
        }

        public Collection<TypeUsage> getSemiTypes() {
            return this.result;
        }

        private void add(TypeUsage type) {
            boolean isThere = false;
            for (TypeUsage stored : this.result) {
                if (!stored.getType().equals(type.getType())) continue;
                isThere = true;
                break;
            }
            if (!isThere) {
                this.result.add(type);
            }
        }

        @Override
        public Node enter(AccessNode aNode) {
            if (aNode.getBase() instanceof IdentNode) {
                IdentNode iNode = (IdentNode)aNode.getBase();
                if (iNode.getName().equals("this")) {
                    List<? extends Node> path = this.getPath();
                    if (path.size() <= 0 || !(path.get(path.size() - 1) instanceof CallNode)) {
                        this.sb.append("@this.");
                        this.sb.append(aNode.getProperty().getName());
                        this.add(new TypeUsageImpl(this.sb.toString(), LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), false));
                    }
                } else {
                    if ("@call;".equals(this.sb.toString())) {
                        this.sb.append(aNode.getProperty().getName());
                    } else {
                        this.sb.insert(0, aNode.getProperty().getName());
                        this.sb.insert(0, "@pro;");
                    }
                    this.sb.insert(0, ((IdentNode)aNode.getBase()).getName());
                    this.sb.insert(0, "@exp;");
                    this.add(new TypeUsageImpl(this.sb.toString(), aNode.getStart()));
                }
                return null;
            }
            if ("@call;".equals(this.sb.toString())) {
                this.sb.append(aNode.getProperty().getName());
            } else {
                this.sb.insert(0, aNode.getProperty().getName());
                this.sb.insert(0, "@pro;");
            }
            return super.enter(aNode);
        }

        @Override
        public Node enter(BinaryNode binaryNode) {
            if (!binaryNode.isAssignment()) {
                if (this.isResultString(binaryNode)) {
                    this.add(STRING_TYPE);
                    return null;
                }
                TokenType tokenType = binaryNode.tokenType();
                if (tokenType == TokenType.EQ || tokenType == TokenType.EQ_STRICT || tokenType == TokenType.NE || tokenType == TokenType.NE_STRICT || tokenType == TokenType.GE || tokenType == TokenType.GT || tokenType == TokenType.LE || tokenType == TokenType.LT) {
                    if (this.getPath().isEmpty()) {
                        this.add(BOOLEAN_TYPE);
                    }
                    return null;
                }
            }
            return super.enter(binaryNode);
        }

        private boolean isResultString(BinaryNode binaryNode) {
            boolean result = false;
            TokenType tokenType = binaryNode.tokenType();
            Node lhs = binaryNode.lhs();
            Node rhs = binaryNode.rhs();
            if (tokenType == TokenType.ADD && (lhs instanceof LiteralNode && ((LiteralNode)lhs).isString() || rhs instanceof LiteralNode && ((LiteralNode)rhs).isString())) {
                result = true;
            } else if (lhs instanceof BinaryNode) {
                result = this.isResultString((BinaryNode)lhs);
            } else if (rhs instanceof BinaryNode) {
                result = this.isResultString((BinaryNode)rhs);
            }
            return result;
        }

        @Override
        public Node enter(CallNode callNode) {
            super.enter(callNode);
            if (callNode.getFunction() instanceof ReferenceNode) {
                FunctionNode function = ((ReferenceNode)callNode.getFunction()).getReference();
                String name = function.getIdent().getName();
                this.add(new TypeUsageImpl("@call;" + name, LexUtilities.getLexerOffset(this.parserResult, function.getStart()), false));
            } else {
                Node previousNode;
                int pathSize = this.getPath().size();
                if (pathSize > 1 && (previousNode = this.getPath().get(pathSize - 2)) instanceof AccessNode && callNode.getFunction() instanceof IdentNode) {
                    String name = ((IdentNode)callNode.getFunction()).getName();
                    this.sb.insert(0, name);
                    this.sb.insert(0, "@call;");
                    return null;
                }
                if (this.sb.length() < 6) {
                    this.sb.append("@call;");
                } else {
                    this.sb.insert(6, "@call;");
                }
                callNode.getFunction().accept((NodeVisitor)this);
            }
            return null;
        }

        @Override
        public Node enter(IdentNode iNode) {
            if (this.getPath().isEmpty()) {
                if (iNode.getName().equals("this")) {
                    this.add(new TypeUsageImpl("@this", LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), false));
                } else {
                    this.add(new TypeUsageImpl("@var;" + iNode.getName(), LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), false));
                }
            } else {
                int pathSize = this.getPath().size();
                Node lastNode = this.getPath().get(pathSize - 1);
                if (lastNode instanceof CallNode) {
                    boolean addFunctionName = true;
                    if (pathSize > 1) {
                        lastNode = this.getPath().get(pathSize - 2);
                        addFunctionName = !(lastNode instanceof AccessNode);
                        this.sb.insert(0, "@exp;");
                    }
                    if (addFunctionName) {
                        this.sb.append(iNode.getName());
                    }
                    this.add(new TypeUsageImpl(this.sb.toString(), LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), false));
                } else if (!(lastNode instanceof AccessNode)) {
                    if (iNode.getName().equals("this")) {
                        this.add(new TypeUsageImpl("@this", LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), false));
                    } else {
                        this.add(new TypeUsageImpl("@var;" + iNode.getName(), LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), false));
                    }
                }
            }
            return null;
        }

        @Override
        public Node enter(IndexNode indexNode) {
            return null;
        }

        @Override
        public Node enter(LiteralNode lNode) {
            Object value = lNode.getObject();
            if (value instanceof Boolean) {
                this.add(BOOLEAN_TYPE);
            } else if (value instanceof String) {
                this.add(STRING_TYPE);
            } else if (value instanceof Integer || value instanceof Float || value instanceof Double) {
                this.add(NUMBER_TYPE);
            } else if (lNode instanceof LiteralNode.ArrayLiteralNode) {
                this.add(ARRAY_TYPE);
            } else if (value instanceof Lexer.RegexToken) {
                this.add(REGEXP_TYPE);
            }
            return null;
        }

        @Override
        public Node enter(ObjectNode objectNode) {
            this.add(new TypeUsageImpl("@anonym;" + objectNode.getStart(), LexUtilities.getLexerOffset(this.parserResult, objectNode.getStart()), false));
            return null;
        }

        @Override
        public Node enter(UnaryNode uNode) {
            if (jdk.nashorn.internal.parser.Token.descType((long)uNode.getToken()) == TokenType.NEW && uNode.rhs() instanceof CallNode && ((CallNode)uNode.rhs()).getFunction() instanceof IdentNode) {
                IdentNode iNode = (IdentNode)((CallNode)uNode.rhs()).getFunction();
                this.add(new TypeUsageImpl("@new;" + iNode.getName(), LexUtilities.getLexerOffset(this.parserResult, iNode.getStart()), false));
                return null;
            }
            return super.enter(uNode);
        }
    }

    private static enum State {
        INIT;

    }
}

