/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model.impl;

import java.util.Stack;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.impl.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsFunctionImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;

public final class ModelBuilder {
    private final JsFunctionImpl globalObject;
    private Stack<JsObjectImpl> stack;
    private Stack<DeclarationScopeImpl> functionStack;
    private int anonymObjectCount;

    ModelBuilder(JsFunctionImpl globalObject) {
        this.globalObject = globalObject;
        this.stack = new Stack();
        this.functionStack = new Stack();
        this.anonymObjectCount = 0;
        this.setCurrentObject(globalObject);
    }

    JsObjectImpl getGlobal() {
        return this.globalObject;
    }

    JsObjectImpl getCurrentObject() {
        return this.stack.isEmpty() ? this.globalObject : this.stack.peek();
    }

    DeclarationScopeImpl getCurrentDeclarationScope() {
        return this.functionStack.isEmpty() ? this.globalObject : this.functionStack.peek();
    }

    JsFunctionImpl getCurrentDeclarationFunction() {
        JsObject declarationScope = this.getCurrentDeclarationScope();
        while (!(declarationScope instanceof JsFunctionImpl)) {
            declarationScope = declarationScope.getParent();
        }
        return (JsFunctionImpl)declarationScope;
    }

    void setCurrentObject(JsObjectImpl object) {
        this.stack.push(object);
        if (object instanceof DeclarationScopeImpl) {
            this.functionStack.push((DeclarationScopeImpl)object);
        }
    }

    void reset() {
        if (!this.stack.empty() && this.stack.pop() instanceof DeclarationScopeImpl && !this.functionStack.empty()) {
            this.functionStack.pop();
        }
    }

    String getUnigueNameForAnonymObject() {
        return "Anonym$" + this.anonymObjectCount++;
    }
}

