/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.Type;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.AnonymousObject;
import org.netbeans.modules.javascript2.editor.model.impl.JsElementImpl;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.OccurrenceImpl;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;

public class JsObjectImpl
extends JsElementImpl
implements JsObject {
    private final HashMap<String, JsObject> properties = new HashMap();
    private final Identifier declarationName;
    private JsObject parent;
    private final List<Occurrence> occurrences;
    private final Map<Integer, Collection<TypeUsage>> assignments;
    private final boolean hasName;
    private String documentation;
    protected JsElement.Kind kind;
    private boolean deprecated;

    public JsObjectImpl(JsObject parent, Identifier name, OffsetRange offsetRange) {
        super(parent != null ? parent.getFileObject() : null, name.getName(), name.getName().equals("prototype"), offsetRange, EnumSet.of(Modifier.PUBLIC));
        this.declarationName = name;
        this.parent = parent;
        this.occurrences = new ArrayList<Occurrence>();
        this.assignments = new HashMap<Integer, Collection<TypeUsage>>();
        this.hasName = name.getOffsetRange().getStart() != name.getOffsetRange().getEnd();
        this.kind = null;
        this.deprecated = false;
    }

    public JsObjectImpl(JsObject parent, Identifier name, OffsetRange offsetRange, boolean isDeclared, Set<Modifier> modifiers) {
        super(parent != null ? parent.getFileObject() : null, name.getName(), isDeclared, offsetRange, modifiers);
        this.declarationName = name;
        this.parent = parent;
        this.occurrences = new ArrayList<Occurrence>();
        this.assignments = new HashMap<Integer, Collection<TypeUsage>>();
        this.hasName = name.getOffsetRange().getStart() != name.getOffsetRange().getEnd();
        this.kind = null;
        this.deprecated = false;
    }

    public JsObjectImpl(JsObject parent, Identifier name, OffsetRange offsetRange, boolean isDeclared) {
        this(parent, name, offsetRange, isDeclared, EnumSet.of(Modifier.PUBLIC));
    }

    protected JsObjectImpl(JsObject parent, String name, boolean isDeclared, OffsetRange offsetRange, Set<Modifier> modifiers) {
        super(parent != null ? parent.getFileObject() : null, name, isDeclared, offsetRange, modifiers);
        this.declarationName = null;
        this.parent = parent;
        this.occurrences = new ArrayList<Occurrence>();
        this.assignments = new HashMap<Integer, Collection<TypeUsage>>();
        this.hasName = false;
        this.deprecated = false;
    }

    @Override
    public Identifier getDeclarationName() {
        return this.declarationName;
    }

    @Override
    public JsElement.Kind getJSKind() {
        if (this.kind != null) {
            return this.kind;
        }
        if (this.parent == null) {
            return JsElement.Kind.FILE;
        }
        if (this.isDeclared()) {
            if ("arguments".equals(this.getName())) {
                return JsElement.Kind.VARIABLE;
            }
            if (!this.getAssignmentForOffset(this.getDeclarationName().getOffsetRange().getEnd()).isEmpty() && this.hasOnlyVirtualProperties()) {
                if (this.getParent().getParent() == null || this.getModifiers().contains(Modifier.PRIVATE)) {
                    return JsElement.Kind.VARIABLE;
                }
                return JsElement.Kind.PROPERTY;
            }
        } else if (!this.getProperties().isEmpty()) {
            return JsElement.Kind.OBJECT;
        }
        if (this.getProperties().isEmpty()) {
            if (this.getParent().isAnonymous() && this.getParent() instanceof AnonymousObject) {
                return JsElement.Kind.PROPERTY;
            }
            if (this.getParent().getParent() == null || this.getModifiers().contains(Modifier.PRIVATE)) {
                return JsElement.Kind.VARIABLE;
            }
            if (this.getParent() instanceof JsFunction && this.isDeclared()) {
                return this.getModifiers().contains(Modifier.PRIVATE) ? JsElement.Kind.VARIABLE : JsElement.Kind.PROPERTY;
            }
            return JsElement.Kind.PROPERTY;
        }
        return JsElement.Kind.OBJECT;
    }

    private boolean hasOnlyVirtualProperties() {
        for (JsObject jsObject : this.getProperties().values()) {
            if (!jsObject.isDeclared()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<String, ? extends JsObject> getProperties() {
        return this.properties;
    }

    @Override
    public void addProperty(String name, JsObject property) {
        this.properties.put(name, property);
    }

    @Override
    public JsObject getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public JsObject getParent() {
        return this.parent;
    }

    public void setParent(JsObject newParent) {
        this.parent = newParent;
    }

    @Override
    public int getOffset() {
        return this.declarationName.getOffsetRange().getStart();
    }

    @Override
    public List<Occurrence> getOccurrences() {
        return this.occurrences;
    }

    public void addOccurrence(OffsetRange offsetRange) {
        OccurrenceImpl occurrence = new OccurrenceImpl(offsetRange, this);
        if (!this.occurrences.contains(occurrence)) {
            this.occurrences.add(occurrence);
        }
    }

    public void addAssignment(Collection<TypeUsage> typeNames, int offset) {
        Collection<TypeUsage> types = this.assignments.get(offset);
        if (types == null) {
            types = new ArrayList<TypeUsage>();
            this.assignments.put(offset, types);
        }
        types.addAll(typeNames);
    }

    public void addAssignment(TypeUsage typeName, int offset) {
        Collection<TypeUsage> types = this.assignments.get(offset);
        if (types == null) {
            types = new ArrayList<TypeUsage>();
            this.assignments.put(offset, types);
        }
        types.add(typeName);
    }

    @Override
    public Collection<? extends TypeUsage> getAssignmentForOffset(int offset) {
        ArrayList<TypeUsage> result = Collections.EMPTY_LIST;
        int closeOffset = -1;
        for (Integer position : this.assignments.keySet()) {
            if (closeOffset >= position || position > offset) continue;
            closeOffset = position;
            result = new ArrayList<TypeUsage>(this.assignments.get(position));
        }
        if (result.isEmpty()) {
            HashSet resolved = new HashSet();
            result = resolved;
        }
        return result;
    }

    public int getCountOfAssignments() {
        return this.assignments.size();
    }

    @Override
    public Collection<? extends TypeUsage> getAssignments() {
        ArrayList<TypeUsage> values = new ArrayList<TypeUsage>();
        for (Collection<TypeUsage> types : this.assignments.values()) {
            values.addAll(types);
        }
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean hasExactName() {
        return this.hasName;
    }

    protected void setJsKind(JsElement.Kind kind) {
        this.kind = kind;
    }

    protected Collection<TypeUsage> resolveAssignments(JsObject jsObject, int offset) {
        HashSet<String> visited = new HashSet<String>();
        return this.resolveAssignments(jsObject, offset, visited);
    }

    protected Collection<TypeUsage> resolveAssignments(JsObject jsObject, int offset, Collection<String> visited) {
        HashSet<TypeUsage> result = new HashSet<TypeUsage>();
        String fqn = ModelUtils.createFQN(jsObject);
        if (visited.contains(fqn)) {
            return result;
        }
        visited.add(fqn);
        Collection<Object> offsetAssignments = Collections.EMPTY_LIST;
        int closeOffset = -1;
        for (Integer position : ((JsObjectImpl)jsObject).assignments.keySet()) {
            if (closeOffset >= position || position > offset) continue;
            closeOffset = position;
            offsetAssignments = ((JsObjectImpl)jsObject).assignments.get(position);
        }
        if (offsetAssignments.isEmpty() && !jsObject.getProperties().isEmpty()) {
            result.add(new TypeUsageImpl(ModelUtils.createFQN(jsObject), jsObject.getOffset(), true));
        } else {
            for (Type assignment : offsetAssignments) {
                TypeUsageImpl assign = (TypeUsageImpl)assignment;
                if (visited.contains(assign.getType())) continue;
                if (assign.isResolved()) {
                    result.add(assign);
                    continue;
                }
                DeclarationScope scope = ModelUtils.getDeclarationScope(jsObject);
                JsObject object = ModelUtils.getJsObjectByName(scope, assign.getType());
                if (object == null) continue;
                Collection<TypeUsage> resolvedFromObject = this.resolveAssignments(object, closeOffset, visited);
                if (resolvedFromObject.isEmpty()) {
                    result.add(new TypeUsageImpl(ModelUtils.createFQN(object), assign.getOffset(), true));
                    continue;
                }
                result.addAll(resolvedFromObject);
            }
        }
        return result;
    }

    public void resolveTypes(JsDocumentationHolder jsDocHolder) {
        if (this.parent == null) {
            return;
        }
        ArrayList resolved = new ArrayList();
        for (Integer index : this.assignments.keySet()) {
            resolved.clear();
            Collection<TypeUsage> unresolved = this.assignments.get(index);
            JsObject global = ModelUtils.getGlobalObject(this.parent);
            for (TypeUsage type : unresolved) {
                ArrayList<TypeUsage> resolvedHere = new ArrayList<TypeUsage>();
                if (!((TypeUsageImpl)type).isResolved()) {
                    resolvedHere.addAll(ModelUtils.resolveTypeFromSemiType(this, type));
                } else {
                    resolvedHere.add(type);
                }
                if (!type.getType().contains("this")) {
                    for (TypeUsage typeHere : resolvedHere) {
                        DeclarationScope declarationScope;
                        if (typeHere.getOffset() <= 0) continue;
                        JsObject jsObject = ModelUtils.findJsObjectByName(global, typeHere.getType());
                        if (jsObject == null && typeHere.getType().indexOf(46) == -1 && global instanceof DeclarationScope && (jsObject = ModelUtils.getJsObjectByName(declarationScope = ModelUtils.getDeclarationScope((DeclarationScope)((Object)global), typeHere.getOffset()), typeHere.getType())) == null) {
                            JsObject decParent;
                            JsObject jsObject2 = decParent = this.parent.getJSKind() != JsElement.Kind.ANONYMOUS_OBJECT && this.parent.getJSKind() != JsElement.Kind.OBJECT_LITERAL ? this.parent : this.parent.getParent();
                            while (jsObject == null && decParent != null) {
                                jsObject = decParent.getProperty(typeHere.getType());
                                decParent = decParent.getParent();
                            }
                        }
                        if (jsObject == null) continue;
                        ((JsObjectImpl)jsObject).addOccurrence(new OffsetRange(typeHere.getOffset(), typeHere.getOffset() + typeHere.getType().length()));
                        this.moveOccurrenceOfProperties((JsObjectImpl)jsObject, this);
                    }
                }
                resolved.addAll(resolvedHere);
            }
            unresolved.clear();
            unresolved.addAll(resolved);
        }
        if (!this.isAnonymous() && this.assignments.isEmpty()) {
            JsObject global = ModelUtils.getGlobalObject(this.parent);
            ArrayList<Occurrence> correctedOccurrences = new ArrayList<Occurrence>();
            JsObjectImpl obAssignment = this.findRightTypeAssignment(this.getDeclarationName().getOffsetRange().getStart(), global);
            if (obAssignment != null && !obAssignment.getModifiers().contains(Modifier.PRIVATE)) {
                obAssignment.addOccurrence(this.getDeclarationName().getOffsetRange());
            }
            for (Occurrence occurrence : new ArrayList<Occurrence>(this.occurrences)) {
                obAssignment = this.findRightTypeAssignment(occurrence.getOffsetRange().getStart(), global);
                if (obAssignment != null && !obAssignment.getModifiers().contains(Modifier.PRIVATE)) {
                    obAssignment.addOccurrence(occurrence.getOffsetRange());
                    continue;
                }
                correctedOccurrences.add(occurrence);
            }
            if (this.occurrences.size() != correctedOccurrences.size()) {
                this.occurrences.clear();
                this.occurrences.addAll(correctedOccurrences);
            }
        }
    }

    private void clearOccurrences() {
        this.occurrences.clear();
    }

    protected void moveOccurrenceOfProperties(JsObjectImpl original, JsObject created) {
        if (original.equals(created)) {
            return;
        }
        for (JsObject jsObject : original.getProperties().values()) {
            JsObjectImpl usedProperty;
            if (!jsObject.getModifiers().contains(Modifier.PUBLIC) && !jsObject.getModifiers().contains(Modifier.PROTECTED) || (usedProperty = (JsObjectImpl)created.getProperty(jsObject.getName())) == null) continue;
            ((JsObjectImpl)jsObject).addOccurrence(usedProperty.getDeclarationName().getOffsetRange());
            for (Occurrence occur : usedProperty.getOccurrences()) {
                ((JsObjectImpl)jsObject).addOccurrence(occur.getOffsetRange());
            }
            usedProperty.clearOccurrences();
            usedProperty.setDeclared(false);
            this.moveOccurrenceOfProperties((JsObjectImpl)jsObject, usedProperty);
        }
        JsObject prototype = original.getProperty("prototype");
        if (prototype != null) {
            this.moveOccurrenceOfProperties((JsObjectImpl)prototype, created);
        }
    }

    private JsObjectImpl findRightTypeAssignment(int offset, JsObject global) {
        JsObject current;
        Collection<? extends TypeUsage> findedAssignments;
        JsObject currentParent = this;
        ArrayList<String> propertyPath = new ArrayList<String>();
        do {
            current = currentParent;
            findedAssignments = current.getAssignmentForOffset(offset);
            propertyPath.add(current.getName());
            currentParent = current.getParent();
        } while (findedAssignments.isEmpty() && currentParent != null);
        for (TypeUsage typeUsage : findedAssignments) {
            current = ModelUtils.findJsObjectByName(global, typeUsage.getType());
            for (int i = propertyPath.size() - 2; i > -1 && current != null; current = current.getProperty((String)propertyPath.get(i)), --i) {
            }
            if (current == null) continue;
            return current;
        }
        return null;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String doc) {
        this.documentation = doc;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean depreceted) {
        this.deprecated = depreceted;
    }
}

