/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.DeclarationScopeImpl;
import org.netbeans.modules.javascript2.editor.model.impl.IdentifierImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.ParameterObject;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;
import org.openide.filesystems.FileObject;

public class JsFunctionImpl
extends DeclarationScopeImpl
implements JsFunction {
    private final HashMap<String, JsObject> parametersByName;
    private final List<JsObject> parameters;
    private final Set<TypeUsage> returnTypes;
    private boolean isAnonymous;
    private boolean areReturnTypesResolved = false;

    public JsFunctionImpl(DeclarationScope scope, JsObject parentObject, Identifier name, List<Identifier> parameters, OffsetRange offsetRange) {
        super(scope, parentObject, name, offsetRange);
        this.parametersByName = new HashMap(parameters.size());
        this.parameters = new ArrayList<JsObject>(parameters.size());
        for (Identifier identifier : parameters) {
            ParameterObject parameter = new ParameterObject(this, identifier);
            this.parametersByName.put(identifier.getName(), parameter);
            this.parameters.add(parameter);
        }
        this.isAnonymous = false;
        this.returnTypes = new HashSet<TypeUsage>();
        this.setDeclared(true);
        if (parentObject != null) {
            JsObjectImpl arguments = new JsObjectImpl((JsObject)this, new IdentifierImpl("arguments", new OffsetRange(name.getOffsetRange().getStart(), name.getOffsetRange().getStart())), name.getOffsetRange(), false, EnumSet.of(Modifier.PRIVATE));
            arguments.addAssignment(new TypeUsageImpl("Arguments", this.getOffset(), true), this.getOffset());
            this.addProperty(arguments.getName(), arguments);
        }
    }

    public static JsFunctionImpl createGlobal(FileObject fileObject, int length) {
        String name = fileObject != null ? fileObject.getName() : "VirtualSource";
        IdentifierImpl ident = new IdentifierImpl(name, new OffsetRange(0, length));
        return new JsFunctionImpl(fileObject, ident);
    }

    private JsFunctionImpl(FileObject file, Identifier name) {
        this(null, null, name, Collections.EMPTY_LIST, name.getOffsetRange());
        this.setFileObject(file);
    }

    protected JsFunctionImpl(FileObject file, JsObject parentObject, Identifier name, List<Identifier> parameters) {
        this(null, parentObject, name, parameters, name.getOffsetRange());
        this.setFileObject(file);
        this.setDeclared(false);
    }

    @Override
    public Collection<? extends JsObject> getParameters() {
        return this.parameters;
    }

    @Override
    public JsElement.Kind getJSKind() {
        if (this.kind != null) {
            return this.kind;
        }
        if (this.getParent() == null) {
            return JsElement.Kind.FILE;
        }
        if (this.getName().startsWith("get ")) {
            return JsElement.Kind.PROPERTY_GETTER;
        }
        if (this.getName().startsWith("set ")) {
            return JsElement.Kind.PROPERTY_SETTER;
        }
        if (this.getParent() != null && this.getParent() instanceof JsFunction) {
            for (JsObject jsObject : this.getProperties().values()) {
                if (!jsObject.isDeclared() || !jsObject.getModifiers().contains(Modifier.PROTECTED) && (!jsObject.getModifiers().contains(Modifier.PUBLIC) || jsObject.getModifiers().contains(Modifier.STATIC)) || this.isAnonymous() || this.getParent().getName().equals("prototype")) continue;
                return JsElement.Kind.CONSTRUCTOR;
            }
        }
        JsElement.Kind result = JsElement.Kind.FUNCTION;
        if (this.getParent().getJSKind() != JsElement.Kind.FILE) {
            result = JsElement.Kind.METHOD;
        }
        return result;
    }

    @Override
    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public void setAnonymous(boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    @Override
    public JsObject getParameter(String name) {
        JsObject result = this.parametersByName.get(name);
        return result;
    }

    @Override
    public Collection<? extends TypeUsage> getReturnTypes() {
        if (this.areReturnTypesResolved) {
            return Collections.EMPTY_LIST;
        }
        HashSet<TypeUsage> returns = new HashSet<TypeUsage>();
        HashSet<String> nameReturnTypes = new HashSet<String>();
        this.areReturnTypesResolved = true;
        for (TypeUsage type : this.returnTypes) {
            if (((TypeUsageImpl)type).isResolved()) {
                if (nameReturnTypes.contains(type.getType())) continue;
                returns.add(type);
                nameReturnTypes.add(type.getType());
                continue;
            }
            if (type.getType().startsWith("@")) {
                String typeName = type.getType();
                if (typeName.endsWith(this.getName()) && typeName.startsWith("@call")) continue;
                Collection<TypeUsage> resolved = ModelUtils.resolveTypeFromSemiType(this, type);
                for (TypeUsage typeResolved : resolved) {
                    if (nameReturnTypes.contains(type.getType())) continue;
                    returns.add(typeResolved);
                    nameReturnTypes.add(typeResolved.getType());
                }
                continue;
            }
            JsObject jsObject = ModelUtils.getJsObjectByName(this, type.getType());
            if (jsObject == null) continue;
            Collection<TypeUsage> resolveAssignments = this.resolveAssignments(jsObject, type.getOffset());
            for (TypeUsage typeResolved : resolveAssignments) {
                if (nameReturnTypes.contains(type.getType())) continue;
                returns.add(typeResolved);
                nameReturnTypes.add(typeResolved.getType());
            }
        }
        this.areReturnTypesResolved = false;
        return returns;
    }

    public void addReturnType(TypeUsage type) {
        boolean isThere = false;
        for (TypeUsage typeUsage : this.returnTypes) {
            if (!type.getType().equals(typeUsage.getType())) continue;
            isThere = true;
        }
        if (!isThere) {
            this.returnTypes.add(type);
        }
    }

    public void addReturnType(Collection<TypeUsage> types) {
        for (TypeUsage typeUsage : types) {
            this.addReturnType(typeUsage);
        }
    }

    public boolean areReturnTypesEmpty() {
        return this.returnTypes.isEmpty();
    }

    @Override
    public void resolveTypes(JsDocumentationHolder docHolder) {
        super.resolveTypes(docHolder);
        HashSet<String> nameReturnTypes = new HashSet<String>();
        ArrayList<TypeUsage> resolved = new ArrayList<TypeUsage>();
        for (TypeUsage type : this.returnTypes) {
            if (type.getType().equals("unresolved") && this.returnTypes.size() > 1) continue;
            if (!((TypeUsageImpl)type).isResolved()) {
                for (TypeUsage rType : ModelUtils.resolveTypeFromSemiType(this, type)) {
                    if (nameReturnTypes.contains(type.getType())) continue;
                    resolved.add(rType);
                    nameReturnTypes.add(rType.getType());
                }
                continue;
            }
            if (nameReturnTypes.contains(type.getType())) continue;
            resolved.add(type);
            nameReturnTypes.add(type.getType());
        }
        for (TypeUsage type : resolved) {
            JsObject jsObject;
            if (type.getOffset() <= 0 || (jsObject = ModelUtils.findJsObjectByName(this, type.getType())) == null) continue;
            ((JsObjectImpl)jsObject).addOccurrence(new OffsetRange(type.getOffset(), type.getOffset() + type.getType().length()));
        }
        this.returnTypes.clear();
        this.returnTypes.addAll(resolved);
        for (JsObject param : this.parameters) {
            Collection<? extends TypeUsage> types = param.getAssignmentForOffset(param.getDeclarationName().getOffsetRange().getStart());
            for (TypeUsage typeUsage : types) {
                JsObject jsObject = ModelUtils.getJsObjectByName(this, typeUsage.getType());
                if (jsObject == null) continue;
                ModelUtils.addDocTypesOccurence(jsObject, docHolder);
                this.moveOccurrenceOfProperties((JsObjectImpl)jsObject, param);
            }
        }
    }
}

