/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model.impl;

import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.classpath.ClassPathProviderImpl;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class JsElementImpl
implements JsElement {
    private final String name;
    private final OffsetRange offsetRange;
    private final Set<Modifier> modifiers;
    private FileObject fileObject;
    private boolean isDeclared;

    public JsElementImpl(FileObject fileObject, String name, boolean isDeclared, OffsetRange offsetRange, Set<Modifier> modifiers) {
        this.fileObject = fileObject;
        this.name = name;
        this.offsetRange = offsetRange;
        this.modifiers = modifiers;
        this.isDeclared = isDeclared;
    }

    public JsElementImpl(FileObject fileObject, String name, boolean isDeclared, OffsetRange offsetRange) {
        this(fileObject, name, isDeclared, offsetRange, Collections.emptySet());
    }

    public ElementKind getKind() {
        ElementKind result = ElementKind.OTHER;
        switch (this.getJSKind()) {
            case CONSTRUCTOR: {
                result = ElementKind.CONSTRUCTOR;
                break;
            }
            case METHOD: 
            case FUNCTION: 
            case PROPERTY_GETTER: 
            case PROPERTY_SETTER: {
                result = ElementKind.METHOD;
                break;
            }
            case OBJECT: 
            case ANONYMOUS_OBJECT: 
            case OBJECT_LITERAL: {
                result = ElementKind.CLASS;
                break;
            }
            case PROPERTY: {
                result = ElementKind.FIELD;
                break;
            }
            case FILE: {
                result = ElementKind.FILE;
                break;
            }
            case PARAMETER: {
                result = ElementKind.PARAMETER;
                break;
            }
            case VARIABLE: {
                result = ElementKind.VARIABLE;
                break;
            }
            case FIELD: {
                result = ElementKind.FIELD;
            }
        }
        return result;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    protected void setFileObject(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public String getMimeType() {
        return "text/javascript";
    }

    public String getName() {
        return this.name;
    }

    public String getIn() {
        return null;
    }

    @Override
    public boolean isDeclared() {
        return this.isDeclared;
    }

    public void setDeclared(boolean isDeclared) {
        this.isDeclared = isDeclared;
    }

    public final OffsetRange getOffsetRange(ParserResult result) {
        return this.getOffsetRange();
    }

    @Override
    public final OffsetRange getOffsetRange() {
        return this.offsetRange;
    }

    @Override
    public int getOffset() {
        return this.offsetRange.getStart();
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public boolean signatureEquals(ElementHandle handle) {
        return false;
    }

    public void addModifier(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public boolean isPlatform() {
        FileObject fo = this.getFileObject();
        if (fo != null) {
            return JsElementImpl.isInternalFile(fo);
        }
        return false;
    }

    private static boolean isInternalFile(FileObject file) {
        for (FileObject dir : ClassPathProviderImpl.getJsStubs()) {
            if (!dir.equals(file) && !FileUtil.isParentOf((FileObject)dir, (FileObject)file)) continue;
            return true;
        }
        return false;
    }
}

