/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import org.netbeans.modules.javascript2.editor.doc.spi.JsDocumentationHolder;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.Identifier;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.OccurrencesSupport;
import org.netbeans.modules.javascript2.editor.model.impl.JsFunctionImpl;
import org.netbeans.modules.javascript2.editor.model.impl.JsObjectImpl;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.ModelVisitor;
import org.netbeans.modules.javascript2.editor.model.impl.UsageBuilder;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;

public final class Model {
    private static final Logger LOGGER = Logger.getLogger(OccurrencesSupport.class.getName());
    private final JsParserResult parserResult;
    private final OccurrencesSupport occurrencesSupport;
    private final UsageBuilder usageBuilder;
    private ModelVisitor visitor;

    Model(JsParserResult parserResult) {
        this.parserResult = parserResult;
        this.occurrencesSupport = new OccurrencesSupport(this);
        this.usageBuilder = new UsageBuilder();
    }

    private synchronized ModelVisitor getModelVisitor() {
        if (this.visitor == null) {
            long start = System.currentTimeMillis();
            this.visitor = new ModelVisitor(this.parserResult);
            FunctionNode root = this.parserResult.getRoot();
            if (root != null) {
                root.accept((NodeVisitor)this.visitor);
            }
            long startResolve = System.currentTimeMillis();
            this.resolveLocalTypes(this.getGlobalObject(), this.parserResult.getDocumentationHolder());
            long end = System.currentTimeMillis();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(MessageFormat.format("Building model took {0}ms. Resolving types took {1}ms", end - start, end - startResolve));
            }
        }
        return this.visitor;
    }

    public JsObject getGlobalObject() {
        return this.getModelVisitor().getGlobalObject();
    }

    public OccurrencesSupport getOccurrencesSupport() {
        return this.occurrencesSupport;
    }

    public Collection<? extends JsObject> getVariables(int offset) {
        ArrayList<JsObject> result = new ArrayList<JsObject>();
        for (DeclarationScope scope = ModelUtils.getDeclarationScope(this, offset); scope != null; scope = scope.getInScope()) {
            for (JsObject jsObject : ((JsObject)((Object)scope)).getProperties().values()) {
                result.add(jsObject);
            }
            for (JsObject jsObject : ((JsFunction)((Object)scope)).getParameters()) {
                result.add(jsObject);
            }
        }
        return result;
    }

    private void resolveLocalTypes(JsObject object, JsDocumentationHolder docHolder) {
        if (object instanceof JsFunctionImpl) {
            ((JsFunctionImpl)object).resolveTypes(docHolder);
        } else {
            ((JsObjectImpl)object).resolveTypes(docHolder);
        }
        for (JsObject jsObject : object.getProperties().values()) {
            this.resolveLocalTypes(jsObject, docHolder);
        }
    }

    public List<Identifier> getNodeName(Node node) {
        return this.getModelVisitor().getNodeName(node);
    }
}

