/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.jsdoc.model;

import java.util.List;
import org.netbeans.modules.javascript2.editor.doc.spi.DocIdentifier;
import org.netbeans.modules.javascript2.editor.doc.spi.DocIdentifierImpl;
import org.netbeans.modules.javascript2.editor.doc.spi.DocParameter;
import org.netbeans.modules.javascript2.editor.jsdoc.model.JsDocElementType;
import org.netbeans.modules.javascript2.editor.jsdoc.model.ParameterElement;
import org.netbeans.modules.javascript2.editor.model.Type;

public class NamedParameterElement
extends ParameterElement
implements DocParameter {
    private final DocIdentifier paramName;
    private final boolean optional;
    private final String defaultValue;

    private NamedParameterElement(JsDocElementType type, DocIdentifier paramName, List<Type> paramTypes, String paramDescription, boolean optional, String defaultValue) {
        super(type, paramTypes, paramDescription);
        this.paramName = paramName;
        this.optional = optional;
        this.defaultValue = defaultValue;
    }

    public static NamedParameterElement create(JsDocElementType type, DocIdentifier paramName, List<Type> paramTypes, String paramDescription, boolean optional, String defaultValue) {
        return new NamedParameterElement(type, paramName, paramTypes, paramDescription, optional, defaultValue);
    }

    public static NamedParameterElement create(JsDocElementType type, DocIdentifier paramName, List<Type> paramTypes, String paramDescription, boolean optional) {
        return new NamedParameterElement(type, paramName, paramTypes, paramDescription, optional, null);
    }

    public static NamedParameterElement create(JsDocElementType type, DocIdentifier paramName, List<Type> paramTypes, String paramDescription) {
        return new NamedParameterElement(type, paramName, paramTypes, paramDescription, false, null);
    }

    public static NamedParameterElement createWithNameDiagnostics(JsDocElementType type, DocIdentifier paramName, List<Type> paramTypes, String paramDescription) {
        int nameOffset = paramName.getOffset();
        String name = paramName.getName();
        boolean optional = name.matches("\\[.*\\]");
        String defaultValue = null;
        if (optional) {
            ++nameOffset;
            int indexOfEqual = (name = name.substring(1, name.length() - 1)).indexOf("=");
            if (indexOfEqual != -1) {
                defaultValue = name.substring(indexOfEqual + 1);
                name = name.substring(0, indexOfEqual);
            }
        }
        return new NamedParameterElement(type, new DocIdentifierImpl(name, nameOffset), paramTypes, paramDescription, optional, defaultValue);
    }

    @Override
    public DocIdentifier getParamName() {
        return this.paramName;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }
}

