/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.jquery;

import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public abstract class JQueryCompletionItem
implements CompletionProposal {
    private final int anchorOffset;
    private final ElementHandle element;

    public static CompletionProposal create(HtmlTag tag, int anchorOffset, String surround) {
        SimpleElement element = new SimpleElement(tag.getName(), ElementKind.TAG);
        return new HTMLTagCompletionItem(element, anchorOffset, surround);
    }

    public static CompletionProposal create(HtmlTagAttribute attribute, int anchorOffset, String surround) {
        SimpleElement element = new SimpleElement(attribute.getName(), ElementKind.ATTRIBUTE);
        return new HTMLTagCompletionItem(element, anchorOffset, surround);
    }

    public static CompletionProposal createCSSItem(String name, int anchorOffset, String surround) {
        SimpleElement element = new SimpleElement(name, ElementKind.RULE);
        return new CssCompletionItem(element, anchorOffset, surround);
    }

    static CompletionProposal createJQueryItem(String name, int anchorOffset, String surround, String codeTemplate) {
        SimpleElement element = new SimpleElement(name, ElementKind.CALL);
        return new JQuerySimpleItem(element, anchorOffset, surround, codeTemplate);
    }

    public JQueryCompletionItem(ElementHandle element, int anchorOffset) {
        this.anchorOffset = anchorOffset;
        this.element = element;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return 20;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public static class SimpleElement
    implements ElementHandle {
        private final String name;
        private final ElementKind kind;

        public SimpleElement(String name, ElementKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getName() {
            return this.name;
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }

    public static class JQuerySimpleItem
    extends HTMLTagCompletionItem {
        private static ImageIcon jQIcon = null;
        private final String template;

        public JQuerySimpleItem(ElementHandle element, int anchorOffset, String surround) {
            this(element, anchorOffset, surround, null);
        }

        public JQuerySimpleItem(ElementHandle element, int anchorOffset, String surround, String template) {
            super(element, anchorOffset, surround);
            this.template = template != null && !template.isEmpty() ? ":" + template : element.getName() + "${cursor}";
        }

        @Override
        public String getCustomInsertTemplate() {
            if (this.getSurround().isEmpty()) {
                return this.template;
            }
            return this.getSurround() + this.template + this.getSurround();
        }

        @Override
        public ImageIcon getIcon() {
            if (jQIcon == null) {
                jQIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/jquery/resources/jquery_16_2.png"));
            }
            return jQIcon;
        }
    }

    public static class CssCompletionItem
    extends HTMLTagCompletionItem {
        private static ImageIcon cssIcon = null;

        public CssCompletionItem(ElementHandle element, int anchorOffset, String surround) {
            super(element, anchorOffset, surround);
        }

        @Override
        public ImageIcon getIcon() {
            if (cssIcon == null) {
                cssIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/editor/jquery/resources/style_sheet_16.png"));
            }
            return cssIcon;
        }
    }

    public static class HTMLTagCompletionItem
    extends JQueryCompletionItem {
        private final String surround;

        public HTMLTagCompletionItem(ElementHandle element, int anchorOffset, String surround) {
            super(element, anchorOffset);
            this.surround = surround;
        }

        @Override
        public int getAnchorOffset() {
            return super.getAnchorOffset();
        }

        public String getSurround() {
            return this.surround;
        }

        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.reset();
            formatter.appendText(this.getName());
            return formatter.getText();
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        @Override
        public String getCustomInsertTemplate() {
            if (this.surround.isEmpty()) {
                return super.getCustomInsertTemplate();
            }
            return this.surround + this.getName() + this.surround;
        }
    }
}

