/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.jquery;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.javascript2.editor.CompletionContextFinder;
import org.netbeans.modules.javascript2.editor.jquery.JQueryCompletionItem;
import org.netbeans.modules.javascript2.editor.jquery.JQueryUtils;
import org.netbeans.modules.javascript2.editor.jquery.SelectorsLoader;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class JQueryCodeCompletion {
    private static final Logger LOGGER = Logger.getLogger(JQueryCodeCompletion.class.getName());
    protected static final String HELP_LOCATION = "docs/jquery-api.xml";
    private static File jQueryApiFile;
    private static Collection<HtmlTagAttribute> allAttributes;
    private int lastTsOffset = 0;
    private static HashMap<String, List<SelectorKind>> contextMap;
    private static Collection<SelectorItem> afterColonList;

    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContextFinder.CompletionContext jsCompletionContext, String prefix) {
        long start = System.currentTimeMillis();
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        ParserResult parserResult = ccContext.getParserResult();
        int offset = ccContext.getCaretOffset();
        this.lastTsOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(offset);
        switch (jsCompletionContext) {
            case GLOBAL: 
            case EXPRESSION: 
            case OBJECT_PROPERTY: {
                if (!JQueryUtils.isInJQuerySelector(parserResult, this.lastTsOffset)) break;
                this.addSelectors(result, parserResult, prefix, this.lastTsOffset);
                break;
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Counting jQuery CC took {0}ms ", end - start);
        return result;
    }

    private int findParamIndex(ParserResult parserResult, int offset) {
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(parserResult.getSnapshot().getTokenHierarchy(), offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() || !ts.movePrevious()) {
            return -1;
        }
        Token<? extends JsTokenId> token = LexUtilities.findNext(ts, Arrays.asList(JsTokenId.WHITESPACE));
        int paramIndex = 0;
        while (token.id() != JsTokenId.EOL && token.id() != JsTokenId.BRACKET_LEFT_PAREN) {
            if (token.id() == JsTokenId.OPERATOR_COMMA) {
                ++paramIndex;
            } else if (token.id() == JsTokenId.OPERATOR_DOT) {
                return -1;
            }
            token = LexUtilities.findNext(ts, Arrays.asList(JsTokenId.WHITESPACE));
        }
        if (token.id() == JsTokenId.BRACKET_LEFT_PAREN) {
            return paramIndex;
        }
        return -1;
    }

    private String findFunctionName(ParserResult parserResult, int offset) {
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(parserResult.getSnapshot().getTokenHierarchy(), offset);
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext() || !ts.movePrevious()) {
            return null;
        }
        Token<? extends JsTokenId> token = LexUtilities.findNext(ts, Arrays.asList(JsTokenId.WHITESPACE));
        while (token.id() != JsTokenId.EOL && token.id() != JsTokenId.BRACKET_LEFT_PAREN) {
            if (token.id() == JsTokenId.OPERATOR_DOT) {
                return null;
            }
            token = LexUtilities.findNext(ts, Arrays.asList(JsTokenId.WHITESPACE));
        }
        if (token.id() == JsTokenId.BRACKET_LEFT_PAREN && ts.movePrevious() && (token = LexUtilities.findNext(ts, Arrays.asList(JsTokenId.WHITESPACE))).id() == JsTokenId.IDENTIFIER) {
            return ((Object)token.text()).toString();
        }
        return null;
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        if (element.getKind() == ElementKind.CALL) {
            String name = element.getName();
            int index = (name = name.substring(1)).indexOf(40);
            if (index > -1) {
                name = name.substring(0, index);
            }
            return SelectorsLoader.getDocumentation(this.getJQueryAPIFile(), name);
        }
        if (element.getKind() == ElementKind.METHOD && JQueryUtils.isJQuery(info, this.lastTsOffset)) {
            return SelectorsLoader.getMethodDocumentation(this.getJQueryAPIFile(), element.getName());
        }
        return null;
    }

    private void fillContextMap() {
        contextMap.put(" (", Arrays.asList(SelectorKind.TAG, SelectorKind.ID, SelectorKind.CLASS, SelectorKind.AFTER_COLON));
        contextMap.put("#", Arrays.asList(SelectorKind.ID));
        contextMap.put(".", Arrays.asList(SelectorKind.CLASS));
        contextMap.put("[", Arrays.asList(SelectorKind.TAG_ATTRIBUTE));
        contextMap.put(":", Arrays.asList(SelectorKind.AFTER_COLON));
    }

    private void fillAfterColonList() {
        if (this.getJQueryAPIFile() != null) {
            afterColonList = SelectorsLoader.getSelectors(this.getJQueryAPIFile());
        }
    }

    private synchronized File getJQueryAPIFile() {
        if (jQueryApiFile == null) {
            jQueryApiFile = InstalledFileLocator.getDefault().locate(HELP_LOCATION, "org.netbeans.modules.javascript2.editor", false);
        }
        return jQueryApiFile;
    }

    private SelectorContext findSelectorContext(String text) {
        int index;
        StringBuilder prefix = new StringBuilder();
        for (index = text.length() - 1; index > -1; --index) {
            char c = text.charAt(index);
            switch (c) {
                case ' ': 
                case '(': 
                case ',': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.TAG, SelectorKind.ID, SelectorKind.CLASS));
                }
                case '#': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.ID));
                }
                case '.': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.CLASS));
                }
                case '[': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.TAG_ATTRIBUTE));
                }
                case ':': {
                    return new SelectorContext(prefix.toString(), index, Arrays.asList(SelectorKind.AFTER_COLON));
                }
            }
            prefix.insert(0, c);
        }
        if (index < 0) {
            return new SelectorContext(prefix.toString(), 0, Arrays.asList(SelectorKind.TAG, SelectorKind.ID, SelectorKind.CLASS, SelectorKind.AFTER_COLON));
        }
        return null;
    }

    private void addSelectors(List<CompletionProposal> result, ParserResult parserResult, String prefix, int offset) {
        SelectorContext context;
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(parserResult.getSnapshot().getTokenHierarchy(), offset);
        if (ts == null) {
            return;
        }
        ts.move(offset);
        if (!ts.moveNext() || !ts.movePrevious()) {
            return;
        }
        String wrapup = "";
        String prefixText = prefix;
        int anchorOffsetDelta = 0;
        if (contextMap.isEmpty()) {
            this.fillContextMap();
        }
        if ((context = this.findSelectorContext(prefixText)) != null) {
            int docOffset = parserResult.getSnapshot().getOriginalOffset(offset) - prefixText.length();
            int anchorOffset = docOffset + anchorOffsetDelta;
            block7: for (SelectorKind selectorKind : context.kinds) {
                switch (selectorKind) {
                    case TAG: {
                        Collection<HtmlTag> tags = this.getHtmlTags(context.prefix);
                        for (HtmlTag htmlTag : tags) {
                            result.add(JQueryCompletionItem.create(htmlTag, anchorOffset, wrapup));
                        }
                        continue block7;
                    }
                    case TAG_ATTRIBUTE: {
                        String tagName = prefix.substring(anchorOffsetDelta, context.prefixIndex);
                        String attributePrefix = prefix.substring(context.prefixIndex + 1);
                        anchorOffset = docOffset + prefix.length() - context.prefix.length();
                        Collection<HtmlTagAttribute> attributes = this.getHtmlAttributes(tagName, attributePrefix);
                        for (HtmlTagAttribute htmlTagAttribute : attributes) {
                            result.add(JQueryCompletionItem.create(htmlTagAttribute, anchorOffset, ""));
                        }
                        continue block7;
                    }
                    case ID: {
                        Collection<String> tagIds = this.getTagIds(context.prefix, parserResult);
                        for (String tagId : tagIds) {
                            result.add(JQueryCompletionItem.createCSSItem("#" + tagId, anchorOffset, wrapup));
                        }
                        continue block7;
                    }
                    case CLASS: {
                        Collection<String> classes = this.getCSSClasses(context.prefix, parserResult);
                        for (String cl : classes) {
                            result.add(JQueryCompletionItem.createCSSItem("." + cl, anchorOffset, wrapup));
                        }
                        continue block7;
                    }
                    case AFTER_COLON: {
                        if (afterColonList.isEmpty()) {
                            this.fillAfterColonList();
                        }
                        for (SelectorItem selector : afterColonList) {
                            if (!selector.getDisplayText().startsWith(context.prefix)) continue;
                            result.add(JQueryCompletionItem.createJQueryItem(":" + selector.displayText, anchorOffset, wrapup, selector.getInsertTemplate()));
                        }
                        break;
                    }
                }
            }
        }
    }

    private Collection<String> getTagIds(String tagIdPrefix, ParserResult parserResult) {
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findIdsByPrefix(tagIdPrefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return unique;
    }

    private Collection<String> getCSSClasses(String classPrefix, ParserResult parserResult) {
        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return Collections.emptyList();
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        HashSet<String> unique = new HashSet<String>();
        try {
            CssIndex cssIndex = CssIndex.create((Project)project);
            Map findIdsByPrefix = cssIndex.findClassesByPrefix(classPrefix);
            for (Collection ids : findIdsByPrefix.values()) {
                for (String id : ids) {
                    unique.add(id);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return unique;
    }

    private Collection<HtmlTagAttribute> getHtmlAttributes(String tagName, String prefix) {
        Collection<Object> result = Collections.emptyList();
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        HtmlTag htmlTag = htmlModel.getTag(tagName);
        if (htmlTag != null) {
            if (prefix.isEmpty()) {
                result = tagName.isEmpty() ? this.getAllAttributes(htmlModel) : htmlTag.getAttributes();
            } else {
                Collection<HtmlTagAttribute> attributes = htmlTag.getAttributes();
                if (tagName.isEmpty()) {
                    attributes = allAttributes;
                }
                result = new ArrayList<HtmlTagAttribute>();
                for (HtmlTagAttribute htmlTagAttribute : attributes) {
                    if (!htmlTagAttribute.getName().startsWith(prefix)) continue;
                    result.add(htmlTagAttribute);
                }
            }
        }
        return result;
    }

    private Collection<HtmlTag> getHtmlTags(String prefix) {
        List<HtmlTag> result = Collections.emptyList();
        HtmlModel htmlModel = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        Collection allTags = htmlModel.getAllTags();
        if (prefix.isEmpty()) {
            result = allTags;
        } else {
            result = new ArrayList();
            for (HtmlTag htmlTag : allTags) {
                if (!htmlTag.getName().startsWith(prefix)) continue;
                result.add(htmlTag);
            }
        }
        return result;
    }

    private synchronized Collection<HtmlTagAttribute> getAllAttributes(HtmlModel htmlModel) {
        if (allAttributes == null) {
            this.initAllAttributes(htmlModel);
        }
        return allAttributes;
    }

    private synchronized void initAllAttributes(HtmlModel htmlModel) {
        assert (allAttributes == null);
        HashMap<String, HtmlTagAttribute> result = new HashMap<String, HtmlTagAttribute>();
        for (HtmlTag htmlTag : htmlModel.getAllTags()) {
            for (HtmlTagAttribute htmlTagAttribute : htmlTag.getAttributes()) {
                if (result.containsKey(htmlTagAttribute.getName())) continue;
                result.put(htmlTagAttribute.getName(), htmlTagAttribute);
            }
        }
        allAttributes = result.values();
    }

    static {
        contextMap = new HashMap();
        afterColonList = Collections.emptyList();
    }

    private static class SelectorContext {
        String prefix;
        Collection<SelectorKind> kinds;
        int prefixIndex;

        public SelectorContext(String prefix, int prefixIndex, Collection<SelectorKind> kinds) {
            this.prefix = prefix;
            this.kinds = kinds;
            this.prefixIndex = prefixIndex;
        }
    }

    protected static class SelectorItem {
        private final String displayText;
        private final String insertTemplate;
        private final String helpId;
        private final String helpText;

        public SelectorItem(String displayText) {
            this(displayText, displayText, null, null);
        }

        public SelectorItem(String displayText, String insertTemplate) {
            this(displayText, insertTemplate, null, null);
        }

        public SelectorItem(String displayText, String insertTemplate, String helpId, String helpText) {
            this.displayText = displayText;
            this.insertTemplate = insertTemplate;
            this.helpId = helpId;
            this.helpText = helpText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public String getInsertTemplate() {
            return this.insertTemplate;
        }

        public String getHelpId() {
            return this.helpId;
        }

        public String getHelpText() {
            return this.helpText;
        }
    }

    private static enum SelectorKind {
        TAG,
        TAG_ATTRIBUTE,
        CLASS,
        ID,
        TAG_ATTRIBUTE_COMPARATION,
        AFTER_COLON;

    }
}

