/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.javascript2.editor.index.IndexedElement;
import org.netbeans.modules.javascript2.editor.index.QuerySupportFactory;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;

public class JsIndex {
    private static final Logger LOG = Logger.getLogger(JsIndex.class.getName());
    private final QuerySupport querySupport;
    private static final JsIndex EMPTY = new JsIndex(null);
    public static final String FIELD_IS_GLOBAL = "isglobal";
    public static final String FIELD_BASE_NAME = "bn";
    public static final String FIELD_FQ_NAME = "fqn";
    public static final String FIELD_PROPERTY = "prop";
    public static final String FIELD_OFFSET = "offset";
    public static final String FIELD_ASSIGNMENS = "assign";
    public static final String FIELD_RETURN_TYPES = "return";
    public static final String FIELD_PARAMETERS = "param";
    public static final String FIELD_FLAG = "flag";
    @SuppressWarnings(value={"MS_MUTABLE_ARRAY"})
    public static final String[] TERMS_BASIC_INFO = new String[]{"bn", "fqn", "offset", "return", "param", "flag", "isglobal", "assign"};
    static final String[] TERMS_PROPERTIES = new String[]{"prop", "assign", "return", "flag"};
    private static WeakHashMap<FileObject, JsIndex> cache = new WeakHashMap();
    private static AtomicBoolean isIndexChanged = new AtomicBoolean(true);
    private Collection<IndexedElement> allGlobalItems = new ArrayList<IndexedElement>();
    private static final Object LOCK = new Object();
    private final int MAX_FIND_PROPERTIES_RECURSION = 15;

    private JsIndex(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    public static JsIndex get(Collection<FileObject> roots) {
        LOG.log(Level.FINE, "JsIndex for roots: {0}", roots);
        return new JsIndex(QuerySupportFactory.get(roots));
    }

    public static synchronized void changeInIndex() {
        isIndexChanged.set(true);
    }

    public static JsIndex get(FileObject fo) {
        JsIndex index = cache.get(fo);
        if (index == null) {
            LOG.log(Level.FINE, "Creating JsIndex for FileObject: {0}", fo);
            index = new JsIndex(QuerySupportFactory.get(fo));
            cache.put(fo, index);
        }
        return index;
    }

    public Collection<? extends IndexResult> query(String fieldName, String fieldValue, QuerySupport.Kind kind, String ... fieldsToLoad) {
        if (this.querySupport != null) {
            try {
                return this.querySupport.query(fieldName, fieldValue, kind, fieldsToLoad);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IndexedElement> getGlobalVar(String prefix) {
        Collection<IndexedElement> sortedItems;
        if (isIndexChanged.get()) {
            Object object = LOCK;
            synchronized (object) {
                if (isIndexChanged.get()) {
                    ArrayList<IndexedElement> globals = new ArrayList<IndexedElement>();
                    Collection<? extends IndexResult> globalObjects = this.query(FIELD_IS_GLOBAL, "1", QuerySupport.Kind.EXACT, TERMS_BASIC_INFO);
                    for (IndexResult indexResult : globalObjects) {
                        IndexedElement indexedElement = IndexedElement.create(indexResult);
                        globals.add(indexedElement);
                    }
                    this.allGlobalItems.clear();
                    this.allGlobalItems.addAll(globals);
                    isIndexChanged.set(false);
                }
            }
        }
        prefix = prefix == null ? "" : prefix;
        Object object = LOCK;
        synchronized (object) {
            sortedItems = JsIndex.getElementsByPrefix(prefix, this.allGlobalItems);
        }
        return sortedItems;
    }

    private static Collection<IndexedElement> getElementsByPrefix(String prefix, Collection<IndexedElement> items) {
        ArrayList<IndexedElement> result = new ArrayList<IndexedElement>();
        for (IndexedElement indexedElement : items) {
            if (!indexedElement.getFQN().startsWith(prefix)) continue;
            result.add(indexedElement);
        }
        return result;
    }

    public Collection<IndexedElement> getPropertiesWithPrefix(String fqn, String prexif) {
        return JsIndex.getElementsByPrefix(prexif, this.getProperties(fqn));
    }

    public Collection<IndexedElement> getProperties(String fqn) {
        return this.getProperties(fqn, 0, new ArrayList<String>());
    }

    private Collection<IndexedElement> getProperties(String fqn, int deepLevel, Collection<String> resolvedTypes) {
        if (deepLevel > 15) {
            return Collections.EMPTY_LIST;
        }
        resolvedTypes.add(fqn);
        ++deepLevel;
        Collection<? extends IndexResult> results = this.query(FIELD_FQ_NAME, fqn, QuerySupport.Kind.EXACT, TERMS_PROPERTIES);
        ArrayList<IndexedElement> result = new ArrayList<IndexedElement>();
        for (IndexResult indexResult : results) {
            TypeUsage type;
            Collection<TypeUsage> assignments = IndexedElement.getAssignments(indexResult);
            if (!assignments.isEmpty() && !resolvedTypes.contains((type = assignments.iterator().next()).getType())) {
                result.addAll(this.getProperties(type.getType(), deepLevel, resolvedTypes));
            }
            for (IndexedElement indexedElement : IndexedElement.createProperties(indexResult, fqn)) {
                result.add(indexedElement);
            }
        }
        return result;
    }

    public Collection<? extends IndexResult> findFQN(String fqn) {
        Collection<? extends IndexResult> results = this.query(FIELD_FQ_NAME, fqn, QuerySupport.Kind.EXACT, TERMS_PROPERTIES);
        return results;
    }
}

