/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.model.JsElement;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.model.impl.JsElementImpl;
import org.netbeans.modules.javascript2.editor.model.impl.ModelUtils;
import org.netbeans.modules.javascript2.editor.model.impl.TypeUsageImpl;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;

public class IndexedElement
extends JsElementImpl {
    private final JsElement.Kind jsKind;
    private final String fqn;
    private final boolean isAnonymous;
    private final boolean isPlatform;
    private final Collection<TypeUsage> assignments;

    public IndexedElement(FileObject fileObject, String name, String fqn, boolean isDeclared, boolean isAnonymous, JsElement.Kind kind, OffsetRange offsetRange, Set<Modifier> modifiers, Collection<TypeUsage> assignments, boolean isPlatform) {
        super(fileObject, name, isDeclared, offsetRange, modifiers);
        this.jsKind = kind;
        this.fqn = fqn;
        this.isAnonymous = isAnonymous;
        this.assignments = assignments;
        this.isPlatform = isPlatform;
    }

    @Override
    public JsElement.Kind getJSKind() {
        return this.jsKind;
    }

    public String getFQN() {
        return this.fqn;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public Collection<TypeUsage> getAssignments() {
        return this.assignments;
    }

    @Override
    public boolean isPlatform() {
        return this.isPlatform;
    }

    public static IndexDocument createDocument(JsObject object, IndexingSupport support, Indexable indexable) {
        IndexDocument elementDocument = support.createDocument(indexable);
        elementDocument.addPair("bn", object.getName(), true, true);
        elementDocument.addPair("fqn", ModelUtils.createFQN(object), true, true);
        elementDocument.addPair("isglobal", ModelUtils.isGlobal(object.getParent()) ? "1" : "0", true, true);
        elementDocument.addPair("offset", Integer.toString(object.getOffset()), true, true);
        elementDocument.addPair("flag", Integer.toString(Flag.getFlag(object)), false, true);
        StringBuilder sb = new StringBuilder();
        for (JsObject jsObject : object.getProperties().values()) {
            if (jsObject.getModifiers().contains(Modifier.PRIVATE)) continue;
            sb.append(IndexedElement.codeProperty(jsObject)).append("#@#");
        }
        elementDocument.addPair("prop", sb.toString(), false, true);
        sb = new StringBuilder();
        for (TypeUsage typeUsage : object.getAssignments()) {
            sb.append(typeUsage.getType());
            sb.append(":");
            sb.append(typeUsage.getOffset());
            sb.append("|");
        }
        elementDocument.addPair("assign", sb.toString(), false, true);
        if (object.getJSKind().isFunction()) {
            sb = new StringBuilder();
            for (TypeUsage typeUsage : ((JsFunction)object).getReturnTypes()) {
                sb.append(typeUsage.getType());
                sb.append(",");
                sb.append(typeUsage.getOffset());
                sb.append("|");
            }
            elementDocument.addPair("return", sb.toString(), false, true);
            elementDocument.addPair("param", IndexedElement.codeParameters(((JsFunction)object).getParameters()), false, true);
        }
        return elementDocument;
    }

    public static IndexedElement create(IndexResult indexResult) {
        IndexedElement result;
        FileObject fo = indexResult.getFile();
        String name = indexResult.getValue("bn");
        String fqn = indexResult.getValue("fqn");
        int flag = Integer.parseInt(indexResult.getValue("flag"));
        boolean isDeclared = Flag.isDeclared(flag);
        boolean isAnonymous = Flag.isAnonymous(flag);
        JsElement.Kind kind = Flag.getJsKind(flag);
        Set<Modifier> modifiers = Flag.getModifiers(flag);
        int offset = Integer.parseInt(indexResult.getValue("offset"));
        Collection<TypeUsage> assignments = IndexedElement.getAssignments(indexResult);
        boolean isPlatform = Flag.isPlatform(flag);
        if (!kind.isFunction()) {
            result = new IndexedElement(fo, name, fqn, isDeclared, isAnonymous, kind, new OffsetRange(offset, offset + name.length()), modifiers, assignments, isPlatform);
        } else {
            Collection<TypeUsage> returnTypes = IndexedElement.getReturnTypes(indexResult);
            ArrayList<String> rTypes = new ArrayList<String>();
            for (TypeUsage type : returnTypes) {
                rTypes.add(type.getType());
            }
            String paramText = indexResult.getValue("param");
            LinkedHashMap<String, Collection<String>> params = IndexedElement.decodeParameters(paramText);
            result = new FunctionIndexedElement(fo, name, fqn, new OffsetRange(offset, offset + name.length()), flag, params, rTypes, assignments);
        }
        return result;
    }

    public static Collection<IndexedElement> createProperties(IndexResult indexResult, String fqn) {
        ArrayList<IndexedElement> result = new ArrayList<IndexedElement>();
        FileObject fo = indexResult.getFile();
        for (String sProperties : indexResult.getValues("prop")) {
            String[] split = sProperties.split("#@#");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].isEmpty()) continue;
                result.add(IndexedElement.decodeProperty(split[i], fo, fqn));
            }
        }
        return result;
    }

    public static Collection<TypeUsage> getAssignments(IndexResult indexResult) {
        return IndexedElement.getAssignments(indexResult.getValue("assign"));
    }

    private static Collection<TypeUsage> getAssignments(String sAssignments) {
        ArrayList<TypeUsage> result = new ArrayList<TypeUsage>();
        if (sAssignments != null) {
            StringTokenizer st = new StringTokenizer(sAssignments, "|");
            while (st.hasMoreTokens()) {
                int offset;
                String token = st.nextToken();
                int index = token.indexOf(58);
                if (index <= -1) continue;
                String type = token.substring(0, index);
                String sOffset = token.substring(index + 1);
                try {
                    offset = Integer.parseInt(sOffset);
                }
                catch (NumberFormatException nfe) {
                    offset = -1;
                }
                result.add(new TypeUsageImpl(type, offset, true));
            }
        }
        return result;
    }

    public static Collection<TypeUsage> getReturnTypes(IndexResult indexResult) {
        ArrayList<TypeUsage> result = new ArrayList<TypeUsage>();
        String text = indexResult.getValue("return");
        if (text != null) {
            StringTokenizer st = new StringTokenizer(text, "|");
            while (st.hasMoreTokens()) {
                int offset;
                String token = st.nextToken();
                int index = token.indexOf(44);
                if (index <= -1) continue;
                String type = token.substring(0, index);
                String sOffset = token.substring(index + 1);
                try {
                    offset = Integer.parseInt(sOffset);
                }
                catch (NumberFormatException nfe) {
                    offset = -1;
                }
                result.add(new TypeUsageImpl(type, offset, true));
            }
        }
        return result;
    }

    private static String codeProperty(JsObject property) {
        StringBuilder result = new StringBuilder();
        JsElement.Kind jsKind = property.getJSKind();
        result.append(property.getName()).append(';');
        result.append(jsKind.getId()).append(';');
        result.append(Flag.getFlag(property)).append(';');
        for (TypeUsage typeUsage : property.getAssignments()) {
            result.append(typeUsage.getType());
            result.append(":");
            result.append(typeUsage.getOffset());
            result.append("|");
        }
        result.append(';');
        if (jsKind.isFunction()) {
            result.append(IndexedElement.codeParameters(((JsFunction)property).getParameters()));
            result.append(";");
            Iterator<? extends TypeUsage> it = ((JsFunction)property).getReturnTypes().iterator();
            while (it.hasNext()) {
                TypeUsage typeUsage = it.next();
                result.append(typeUsage.getType());
                if (!it.hasNext()) continue;
                result.append(',');
            }
        }
        return result.toString();
    }

    private static String codeParameters(Collection<? extends JsObject> params) {
        StringBuilder result = new StringBuilder();
        Iterator<? extends JsObject> it = params.iterator();
        while (it.hasNext()) {
            JsObject parametr = it.next();
            result.append(parametr.getName());
            result.append(":");
            Iterator<? extends TypeUsage> itType = parametr.getAssignmentForOffset(parametr.getOffset() + 1).iterator();
            while (itType.hasNext()) {
                TypeUsage type = itType.next();
                result.append(type.getType());
                if (!itType.hasNext()) continue;
                result.append("|");
            }
            if (!it.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    private static LinkedHashMap<String, Collection<String>> decodeParameters(String paramsText) {
        LinkedHashMap<String, Collection<String>> parameters = new LinkedHashMap<String, Collection<String>>();
        StringTokenizer stringTokenizer = new StringTokenizer(paramsText, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String paramName;
            String param = stringTokenizer.nextToken();
            int index = param.indexOf(58);
            ArrayList<String> types = new ArrayList<String>();
            if (index > 0) {
                paramName = param.substring(0, index);
                String typesText = param.substring(index + 1);
                StringTokenizer stParamType = new StringTokenizer(typesText, "|");
                while (stParamType.hasMoreTokens()) {
                    types.add(stParamType.nextToken());
                }
            } else {
                paramName = param;
            }
            parameters.put(paramName, types);
        }
        return parameters;
    }

    private static IndexedElement decodeProperty(String text, FileObject fo, String fqn) {
        List assignments;
        String[] parts = text.split(";");
        String name = parts[0];
        JsElement.Kind jsKind = JsElement.Kind.fromId(Integer.parseInt(parts[1]));
        int flag = Integer.parseInt(parts[2]);
        String fqnOfProperty = fqn + "." + name;
        Collection<Object> collection = assignments = parts.length > 3 ? IndexedElement.getAssignments(parts[3]) : Collections.EMPTY_LIST;
        if (parts.length > 4 && jsKind.isFunction()) {
            String paramsText = parts[4];
            LinkedHashMap<String, Collection<String>> parameters = IndexedElement.decodeParameters(paramsText);
            ArrayList<String> returnTypes = new ArrayList<String>();
            if (parts.length > 5) {
                String returnTypesText = parts[5];
                StringTokenizer stringTokenizer = new StringTokenizer(returnTypesText, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    returnTypes.add(stringTokenizer.nextToken());
                }
            }
            return new FunctionIndexedElement(fo, name, fqnOfProperty, OffsetRange.NONE, flag, parameters, returnTypes, assignments);
        }
        return new IndexedElement(fo, name, fqnOfProperty, Flag.isDeclared(flag), Flag.isAnonymous(flag), jsKind, OffsetRange.NONE, Flag.getModifiers(flag), assignments, Flag.isPlatform(flag));
    }

    public static class Flag {
        private static final int PRIVATE = 1;
        private static final int PUBLIC = 2;
        private static final int STATIC = 4;
        private static final int PRIVILAGE = 8;
        private static final int DEPRICATED = 16;
        private static final int GLOBAL = 32;
        private static final int DECLARED = 64;
        private static final int ANONYMOUS = 128;
        private static final int FILE = 256;
        private static final int PROPERTY = 512;
        private static final int VARIABLE = 1024;
        private static final int OBJECT = 2048;
        private static final int METHOD = 4096;
        private static final int FUNCTION = 8192;
        private static final int ANONYMOUS_OBJECT = 16384;
        private static final int CONSTRUCTOR = 32768;
        private static final int FIELD = 65536;
        private static final int PARAMETER = 131072;
        private static final int PROPERTY_GETTER = 262144;
        private static final int PROPERTY_SETTER = 524288;
        private static final int PLATFORM = 0x100000;

        public static int getFlag(JsObject object) {
            JsElement.Kind kind;
            int value = 0;
            Set modifiers = object.getModifiers();
            if (modifiers.contains(Modifier.PRIVATE)) {
                value |= 1;
            }
            if (modifiers.contains(Modifier.PUBLIC)) {
                value |= 2;
            }
            if (modifiers.contains(Modifier.STATIC)) {
                value |= 4;
            }
            if (modifiers.contains(Modifier.PROTECTED)) {
                value |= 8;
            }
            if (modifiers.contains(Modifier.DEPRECATED)) {
                value |= 0x10;
            }
            if (ModelUtils.isGlobal(object)) {
                value |= 0x20;
            }
            if (object.isDeclared()) {
                value |= 0x40;
            }
            if (object.isAnonymous()) {
                value |= 0x80;
            }
            if ((kind = object.getJSKind()) == JsElement.Kind.ANONYMOUS_OBJECT) {
                value |= 0x4000;
            }
            if (kind == JsElement.Kind.CONSTRUCTOR) {
                value |= 0x8000;
            }
            if (kind == JsElement.Kind.FIELD) {
                value |= 0x10000;
            }
            if (kind == JsElement.Kind.FILE) {
                value |= 0x100;
            }
            if (kind == JsElement.Kind.FUNCTION) {
                value |= 0x2000;
            }
            if (kind == JsElement.Kind.METHOD) {
                value |= 0x1000;
            }
            if (kind == JsElement.Kind.OBJECT) {
                value |= 0x800;
            }
            if (kind == JsElement.Kind.PARAMETER) {
                value |= 0x20000;
            }
            if (kind == JsElement.Kind.PROPERTY) {
                value |= 0x200;
            }
            if (kind == JsElement.Kind.PROPERTY_GETTER) {
                value |= 0x40000;
            }
            if (kind == JsElement.Kind.PROPERTY_SETTER) {
                value |= 0x80000;
            }
            if (kind == JsElement.Kind.VARIABLE) {
                value |= 0x400;
            }
            if (object.isPlatform()) {
                value |= 0x100000;
            }
            return value;
        }

        public static Set<Modifier> getModifiers(int flag) {
            EnumSet<Modifier> result = EnumSet.noneOf(Modifier.class);
            if ((flag & 1) != 0) {
                result.add(Modifier.PRIVATE);
            }
            if ((flag & 2) != 0) {
                result.add(Modifier.PUBLIC);
            }
            if ((flag & 4) != 0) {
                result.add(Modifier.STATIC);
            }
            if ((flag & 8) != 0) {
                result.add(Modifier.PROTECTED);
            }
            if ((flag & 0x10) != 0) {
                result.add(Modifier.DEPRECATED);
            }
            return result;
        }

        public static boolean isGlobal(int flag) {
            return (flag & 0x20) != 0;
        }

        public static boolean isDeclared(int flag) {
            return (flag & 0x40) != 0;
        }

        public static boolean isAnonymous(int flag) {
            return (flag & 0x80) != 0;
        }

        public static boolean isPlatform(int flag) {
            return (flag & 0x100000) != 0;
        }

        public static JsElement.Kind getJsKind(int flag) {
            JsElement.Kind result = JsElement.Kind.VARIABLE;
            if ((flag & 0x4000) != 0) {
                result = JsElement.Kind.ANONYMOUS_OBJECT;
            } else if ((flag & 0x8000) != 0) {
                result = JsElement.Kind.CONSTRUCTOR;
            } else if ((flag & 0x10000) != 0) {
                result = JsElement.Kind.FIELD;
            } else if ((flag & 0x100) != 0) {
                result = JsElement.Kind.FILE;
            } else if ((flag & 0x2000) != 0) {
                result = JsElement.Kind.FUNCTION;
            } else if ((flag & 0x1000) != 0) {
                result = JsElement.Kind.METHOD;
            } else if ((flag & 0x800) != 0) {
                result = JsElement.Kind.OBJECT;
            } else if ((flag & 0x20000) != 0) {
                result = JsElement.Kind.PARAMETER;
            } else if ((flag & 0x200) != 0) {
                result = JsElement.Kind.PROPERTY;
            } else if ((flag & 0x40000) != 0) {
                result = JsElement.Kind.PROPERTY_GETTER;
            } else if ((flag & 0x80000) != 0) {
                result = JsElement.Kind.PROPERTY_SETTER;
            } else if ((flag & 0x400) != 0) {
                result = JsElement.Kind.VARIABLE;
            }
            return result;
        }
    }

    public static class FunctionIndexedElement
    extends IndexedElement {
        private final LinkedHashMap<String, Collection<String>> parameters;
        private final Collection<String> returnTypes;

        public FunctionIndexedElement(FileObject fileObject, String name, String fqn, OffsetRange offsetRange, int flag, LinkedHashMap<String, Collection<String>> parameters, Collection<String> returnTypes, Collection<TypeUsage> assignments) {
            super(fileObject, name, fqn, Flag.isDeclared(flag), Flag.isAnonymous(flag), Flag.getJsKind(flag), offsetRange, Flag.getModifiers(flag), assignments, Flag.isPlatform(flag));
            this.parameters = parameters;
            this.returnTypes = returnTypes;
        }

        public LinkedHashMap<String, Collection<String>> getParameters() {
            return this.parameters;
        }

        public Collection<String> getReturnTypes() {
            return this.returnTypes;
        }
    }
}

