/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.hints;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.embedding.JsEmbeddingProvider;
import org.netbeans.modules.javascript2.editor.hints.JsAstRule;
import org.netbeans.modules.javascript2.editor.hints.JsConventionRule;
import org.netbeans.modules.javascript2.editor.hints.JsFunctionDocumentationRule;
import org.netbeans.modules.javascript2.editor.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;

public class JsHintsProvider
implements HintsProvider {
    private volatile boolean cancel = false;

    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints) {
        List otherHints;
        Map allHints = manager.getHints(false, context);
        List conventionHints = (List)allHints.get("jsconvention.option.hints");
        boolean countConventionHints = false;
        if (conventionHints != null) {
            for (Rule.AstRule astRule : conventionHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                countConventionHints = true;
            }
        }
        if (countConventionHints && !this.cancel) {
            JsConventionRule rule = new JsConventionRule();
            this.invokeHint(rule, manager, context, hints, -1);
        }
        List documentationRules = (List)allHints.get("jsdocumentation.option.hints");
        boolean documentationHints = false;
        if (documentationRules != null) {
            for (Rule.AstRule astRule : documentationRules) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                documentationHints = true;
            }
        }
        if (documentationHints && !this.cancel) {
            JsFunctionDocumentationRule rule = new JsFunctionDocumentationRule();
            this.invokeHint(rule, manager, context, hints, -1);
        }
        if ((otherHints = (List)allHints.get("js.other.hints")) != null && !this.cancel) {
            for (Rule.AstRule astRule : otherHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                JsAstRule rule = (JsAstRule)astRule;
                this.invokeHint(rule, manager, context, hints, -1);
            }
        }
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
        Map allSuggestions = manager.getHints(true, context);
        List otherHints = (List)allSuggestions.get("js.other.hints");
        if (otherHints != null && !this.cancel) {
            for (Rule.AstRule astRule : otherHints) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)astRule)) continue;
                JsAstRule rule = (JsAstRule)astRule;
                this.invokeHint(rule, manager, context, suggestions, caretOffset);
            }
        }
    }

    private void invokeHint(JsAstRule rule, HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int caretOffset) {
        try {
            rule.computeHints((JsRuleContext)context, suggestions, caretOffset, manager);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> suggestions, int start, int end) {
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        ParserResult parserResult = context.parserResult;
        if (parserResult != null) {
            List errors = parserResult.getDiagnostics();
            String mimepath = parserResult.getSnapshot().getMimePath().getPath();
            if (!"text/javascript".equals(mimepath) && !"text/x-json".equals(mimepath)) {
                int nextCorrect = -1;
                for (Error error : errors) {
                    int pos = parserResult.getSnapshot().getOriginalOffset(error.getStartPosition());
                    if (pos < 0 || nextCorrect > error.getStartPosition() || JsEmbeddingProvider.containsGeneratedIdentifier(error.getDisplayName())) continue;
                    TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsPositionedSequence(parserResult.getSnapshot(), error.getStartPosition());
                    if (ts != null && ts.movePrevious()) {
                        Token<? extends JsTokenId> token = LexUtilities.findPreviousNonWsNonComment(ts);
                        if (!JsEmbeddingProvider.containsGeneratedIdentifier(((Object)token.text()).toString())) {
                            unhandled.add(error);
                            continue;
                        }
                        nextCorrect = this.findNextCorrectOffset(ts, error.getStartPosition());
                        continue;
                    }
                    unhandled.add(error);
                }
            } else {
                unhandled.addAll(errors);
            }
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    public List<Rule> getBuiltinRules() {
        return Collections.emptyList();
    }

    public RuleContext createRuleContext() {
        return new JsRuleContext();
    }

    private int findNextCorrectOffset(TokenSequence<? extends JsTokenId> ts, int offset) {
        ts.move(offset);
        if (ts.moveNext()) {
            LexUtilities.findNextIncluding(ts, Collections.singletonList(JsTokenId.BRACKET_LEFT_CURLY));
            LexUtilities.findNextIncluding(ts, Collections.singletonList(JsTokenId.EOL));
        }
        return ts.offset();
    }

    public static class JsRuleContext
    extends RuleContext {
        private JsParserResult jsParserResult = null;

        public JsParserResult getJsParserResult() {
            if (this.jsParserResult == null) {
                this.jsParserResult = (JsParserResult)this.parserResult;
            }
            return this.jsParserResult;
        }
    }
}

